/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.util.SOLIDUtils;

public class SequenceRenderer {
    private static Logger log = Logger.getLogger(SequenceRenderer.class);
    public static final int AMINO_ACID_RESOLUTION = 5;
    public static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    protected TranslatedSequenceDrawer translatedSequenceDrawer;
    protected Strand strand = Strand.POSITIVE;
    private boolean hasSequence = true;

    public SequenceRenderer() {
        this.translatedSequenceDrawer = new TranslatedSequenceDrawer();
    }

    public void draw(RenderContext context, Rectangle trackRectangle, boolean showColorSpace, boolean showTranslation, int resolutionThreshold) {
        if (context.getScale() >= (double)resolutionThreshold) {
            context.getGraphic2DForColor(UIConstants.LIGHT_GREY).fill(trackRectangle);
        } else {
            byte[] seq;
            double locScale = context.getScale();
            double origin = context.getOrigin();
            String chr = context.getChr();
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            int end = (int)(origin + (double)trackRectangle.width * locScale) + 1;
            int start = Math.max(0, (int)origin - 1);
            if (end <= start) {
                return;
            }
            int firstCodonOffset = 0;
            int lastCodonOffset = 0;
            if (showTranslation) {
                if (start > 1) {
                    firstCodonOffset = 2;
                    start -= firstCodonOffset;
                }
                lastCodonOffset = 2;
                end += lastCodonOffset;
            }
            if ((seq = genome.getSequence(chr, start, end)) == null) {
                this.hasSequence = false;
                return;
            }
            this.hasSequence = true;
            int untranslatedSequenceHeight = (int)trackRectangle.getHeight();
            if (showTranslation) {
                untranslatedSequenceHeight = showColorSpace ? (int)trackRectangle.getHeight() / 5 * 2 : (int)(trackRectangle.getHeight() / 4.0);
                Rectangle translatedSequenceRect = new Rectangle(trackRectangle.x, trackRectangle.y + untranslatedSequenceHeight, (int)trackRectangle.getWidth(), (int)trackRectangle.getHeight() - untranslatedSequenceHeight);
                if (context.getScale() < 5.0) {
                    this.translatedSequenceDrawer.draw(context, start, translatedSequenceRect, seq, this.strand);
                }
            }
            Rectangle untranslatedSequenceRect = new Rectangle(trackRectangle.x, trackRectangle.y, (int)trackRectangle.getWidth(), untranslatedSequenceHeight);
            byte[] seqCS = null;
            if (showColorSpace) {
                seqCS = SOLIDUtils.convertToColorSpace(seq);
            }
            if (seq != null && seq.length > 0) {
                int fontSize;
                int hCS = showColorSpace ? untranslatedSequenceRect.height / 2 : 0;
                int yBase = hCS + untranslatedSequenceRect.y + 2;
                int yCS = untranslatedSequenceRect.y + 2;
                int dY = (showColorSpace ? hCS : untranslatedSequenceRect.height) - 4;
                int dX = (int)(1.0 / locScale);
                Graphics2D g = (Graphics2D)context.getGraphics().create();
                if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                if ((fontSize = Math.min(untranslatedSequenceRect.height, Math.min(dX, 12))) >= 8) {
                    Font f = FontManager.getFont(1, fontSize);
                    g.setFont(f);
                }
                int firstVisibleNucleotideStart = start;
                int lastVisibleNucleotideEnd = Math.min(end, seq.length + start);
                int lastPx0 = -1;
                int scale = Math.max(1, (int)context.getScale());
                for (int loc = firstVisibleNucleotideStart; loc < lastVisibleNucleotideEnd; loc += scale) {
                    if (loc >= lastVisibleNucleotideEnd) continue;
                    int idx = loc - start;
                    int pX0 = (int)(((double)loc - origin) / locScale);
                    if (pX0 <= lastPx0) continue;
                    lastPx0 = pX0;
                    char c = (char)seq[idx];
                    if (Strand.NEGATIVE.equals((Object)this.strand)) {
                        c = this.complementChar(c);
                    }
                    Color color = nucleotideColors.get(Character.valueOf(c));
                    if (fontSize >= 8) {
                        if (color == null) {
                            color = Color.black;
                        }
                        g.setColor(color);
                        this.drawCenteredText(g, new char[]{c}, pX0, yBase + 2, dX, dY - 2);
                        if (!showColorSpace) continue;
                        g.setColor(Color.black);
                        String cCS = String.valueOf(seqCS[idx]);
                        this.drawCenteredText(g, cCS.toCharArray(), pX0 - dX / 2, yCS + 2, dX, dY - 2);
                        continue;
                    }
                    int bw = Math.max(1, dX - 1);
                    if (color == null) continue;
                    g.setColor(color);
                    g.fillRect(pX0, yBase, bw, dY);
                }
            }
        }
    }

    protected char complementChar(char inputChar) {
        switch (inputChar) {
            case 'A': {
                return 'T';
            }
            case 'T': 
            case 'U': {
                return 'A';
            }
            case 'G': {
                return 'C';
            }
            case 'C': {
                return 'G';
            }
            case 'M': {
                return 'K';
            }
            case 'R': {
                return 'Y';
            }
            case 'Y': {
                return 'R';
            }
            case 'K': {
                return 'M';
            }
            case 'V': {
                return 'B';
            }
            case 'H': {
                return 'D';
            }
            case 'D': {
                return 'H';
            }
            case 'B': {
                return 'V';
            }
            case 'a': {
                return 't';
            }
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'g': {
                return 'c';
            }
            case 'c': {
                return 'g';
            }
            case 'm': {
                return 'k';
            }
            case 'r': {
                return 'y';
            }
            case 'y': {
                return 'r';
            }
            case 'k': {
                return 'm';
            }
            case 'v': {
                return 'b';
            }
            case 'h': {
                return 'd';
            }
            case 'd': {
                return 'h';
            }
            case 'b': {
                return 'v';
            }
        }
        return inputChar;
    }

    private void drawCenteredText(Graphics2D g, char[] chars, int x, int y, int w, int h) {
        FontMetrics fm = g.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h / 2 - descent / 2 + ascent / 2;
        g.drawChars(chars, 0, 1, msgX, msgY);
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    public boolean hasSequence() {
        return this.hasSequence;
    }

    static {
        Color AColor = new Color(0, 150, 0);
        nucleotideColors.put(Character.valueOf('A'), AColor);
        nucleotideColors.put(Character.valueOf('a'), AColor);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        Color GColor = new Color(209, 113, 5);
        nucleotideColors.put(Character.valueOf('G'), GColor);
        nucleotideColors.put(Character.valueOf('g'), GColor);
        nucleotideColors.put(Character.valueOf('N'), Color.gray);
        nucleotideColors.put(Character.valueOf('n'), Color.gray);
    }

    public static class TranslatedSequenceDrawer {
        public static final int HEIGHT_PER_BAND = 14;
        public static final int TOTAL_HEIGHT = 42;
        public static final Color AA_COLOR_1 = new Color(128, 128, 128);
        public static final Color AA_COLOR_2 = new Color(170, 170, 170);
        public static final Color AA_FONT_COLOR = Color.WHITE;
        public static final int MIN_FONT_SIZE = 6;
        public static final int MIN_FONT_VBUFFER = 1;
        public static final int IDEAL_FONT_VBUFFER = 2;
        protected static final Color STOP_CODON_COLOR = Color.RED;
        protected static final Color METHIONINE_COLOR = Color.GREEN;
        protected static final Color NUCLEOTIDE_SEPARATOR_COLOR = new Color(150, 150, 150, 120);

        public void draw(RenderContext context, int start, Rectangle trackRectangle, byte[] seq, Strand strand) {
            int idealHeightPerBand = trackRectangle.height / 3;
            if (trackRectangle.height % 3 == 2) {
                ++idealHeightPerBand;
            }
            int minHeightPerBand = Math.min(idealHeightPerBand, trackRectangle.height - 2 * idealHeightPerBand);
            double locScale = context.getScale();
            double origin = context.getOrigin();
            int oneAcidBoxWidth = this.getPixelFromChromosomeLocation(context.getChr(), 3, origin, locScale) - this.getPixelFromChromosomeLocation(context.getChr(), 0, origin, locScale) + 1;
            int oneAcidBoxMinDimension = Math.min(oneAcidBoxWidth, minHeightPerBand);
            int fontSize = 0;
            boolean shouldDrawLetters = false;
            if (oneAcidBoxMinDimension >= 8) {
                int idealFontSize = oneAcidBoxMinDimension - 4;
                fontSize = Math.max(idealFontSize, 6);
                shouldDrawLetters = true;
            }
            boolean shouldDrawNucleotideLines = shouldDrawLetters && (double)oneAcidBoxWidth >= 2.5 * (double)fontSize;
            Rectangle bandRectangle = new Rectangle(trackRectangle.x, 0, trackRectangle.width, 0);
            int heightAlreadyUsed = 0;
            bandRectangle.y = trackRectangle.y;
            bandRectangle.height = idealHeightPerBand;
            HashSet<Integer> nucleotideLineXPositions = new HashSet<Integer>();
            this.drawOneTranslation(context, start, bandRectangle, 0, shouldDrawLetters, fontSize, nucleotideLineXPositions, seq, strand);
            bandRectangle.y = trackRectangle.y + (heightAlreadyUsed += bandRectangle.height);
            bandRectangle.height = idealHeightPerBand;
            this.drawOneTranslation(context, start, bandRectangle, 1, shouldDrawLetters, fontSize, nucleotideLineXPositions, seq, strand);
            bandRectangle.y = trackRectangle.y + (heightAlreadyUsed += bandRectangle.height);
            bandRectangle.height = trackRectangle.height - heightAlreadyUsed;
            this.drawOneTranslation(context, start, bandRectangle, 2, shouldDrawLetters, fontSize, nucleotideLineXPositions, seq, strand);
            if (shouldDrawNucleotideLines) {
                Graphics2D graphicsForNucleotideLines = context.getGraphic2DForColor(NUCLEOTIDE_SEPARATOR_COLOR);
                graphicsForNucleotideLines.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
                int topYCoord = trackRectangle.y - 1;
                Iterator i$ = nucleotideLineXPositions.iterator();
                while (i$.hasNext()) {
                    int xVal = (Integer)i$.next();
                    if (xVal < trackRectangle.x || xVal > trackRectangle.x + trackRectangle.width) continue;
                    graphicsForNucleotideLines.drawLine(xVal, topYCoord, xVal, topYCoord + trackRectangle.height);
                }
            }
        }

        protected void drawOneTranslation(RenderContext context, int start, Rectangle bandRectangle, int readingFrame, boolean shouldDrawLetters, int fontSize, Set<Integer> nucleotideLineXPositions, byte[] seq, Strand strand) {
            int readingFrameOfFullSeq;
            int indexOfFirstCodonStart;
            double locScale = context.getScale();
            double origin = context.getOrigin();
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(AA_FONT_COLOR).create();
            if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if ((indexOfFirstCodonStart = readingFrame - (readingFrameOfFullSeq = start % 3)) < 0) {
                indexOfFirstCodonStart += 3;
            }
            if (seq != null && seq.length > 0) {
                Graphics2D g = (Graphics2D)context.getGraphics().create();
                if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                String nucSequence = new String(seq, indexOfFirstCodonStart, seq.length - indexOfFirstCodonStart);
                AminoAcidSequence aaSequence = AminoAcidManager.getInstance().getAminoAcidSequence(strand, start + indexOfFirstCodonStart, nucSequence);
                if (aaSequence != null && aaSequence.hasNonNullSequence()) {
                    boolean odd;
                    Rectangle aaRect = new Rectangle(0, bandRectangle.y, 1, bandRectangle.height);
                    int aaSeqStartPosition = aaSequence.getStartPosition();
                    int firstFullAcidIndex = (int)Math.floor((aaSeqStartPosition - readingFrame) / 3);
                    boolean bl = odd = firstFullAcidIndex % 2 == 1;
                    if (shouldDrawLetters) {
                        Font f = FontManager.getFont(1, fontSize);
                        g.setFont(f);
                    }
                    for (AminoAcid acid : aaSequence.getSequence()) {
                        if (acid == null) continue;
                        int px = this.getPixelFromChromosomeLocation(context.getChr(), aaSeqStartPosition, origin, locScale);
                        int px2 = this.getPixelFromChromosomeLocation(context.getChr(), aaSeqStartPosition + 3, origin, locScale);
                        if ((double)px <= bandRectangle.getMaxX() && (double)px2 >= bandRectangle.getX()) {
                            aaRect.x = px;
                            aaRect.width = px2 - px;
                            nucleotideLineXPositions.add(aaRect.x);
                            nucleotideLineXPositions.add(aaRect.x + aaRect.width);
                            Graphics2D bgGraphics = context.getGraphic2DForColor(this.getColorForAminoAcid(acid.getSymbol(), odd));
                            bgGraphics.fill(aaRect);
                            if (shouldDrawLetters) {
                                String acidString = new String(new char[]{acid.getSymbol()});
                                GraphicUtils.drawCenteredText(acidString, aaRect, fontGraphics);
                            }
                        }
                        odd = !odd;
                        aaSeqStartPosition += 3;
                    }
                }
            }
        }

        protected Color getColorForAminoAcid(char acidSymbol, boolean odd) {
            switch (acidSymbol) {
                case 'M': {
                    return METHIONINE_COLOR;
                }
                case '*': {
                    return STOP_CODON_COLOR;
                }
            }
            return odd ? AA_COLOR_1 : AA_COLOR_2;
        }

        protected int getPixelFromChromosomeLocation(String chr, int chromosomeLocation, double origin, double locationScale) {
            return (int)Math.round(((double)chromosomeLocation - origin) / locationScale);
        }

        public Color getDefaultColor() {
            return Color.BLACK;
        }
    }
}

