/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import com.google.common.base.Objects;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class Exon
extends AbstractFeature
implements IExon {
    private int number;
    private int codingStart;
    private int codingEnd;
    private AminoAcidSequence aminoAcidSequence;
    private byte[] seqBytes;
    private boolean utr = false;
    private int mrnaBase = -1;

    public void setMrnaBase(int base) {
        this.mrnaBase = base;
    }

    public int getAminoAcidNumber(int genomeCoordinate) {
        if (this.mrnaBase < 0) {
            return -1;
        }
        if (genomeCoordinate < this.getStart() || genomeCoordinate > this.getEnd()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.getStrand() == Strand.POSITIVE) {
            int mrnaCoord = this.mrnaBase + (genomeCoordinate - this.codingStart);
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        if (this.getStrand() == Strand.NEGATIVE) {
            int mrnaCoord = this.mrnaBase + (this.codingEnd - 1 - genomeCoordinate);
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        return 0;
    }

    public Exon(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.codingStart = start;
        this.codingEnd = end;
    }

    public void setUTR(boolean utr) {
        this.utr = utr;
        if (utr) {
            this.codingStart = this.getStrand() == Strand.POSITIVE ? (this.codingEnd = this.getEnd()) : (this.codingEnd = this.getStart());
        }
    }

    @Override
    public boolean isUTR() {
        return this.utr;
    }

    public boolean isUTR(int position) {
        return this.utr || position < this.codingStart || position > this.codingEnd;
    }

    public void setCodingStart(int codingStart) {
        this.codingStart = Math.max(this.getStart(), codingStart);
    }

    public void setCodingEnd(int codingEnd) {
        this.codingEnd = Math.min(this.getEnd(), codingEnd);
    }

    public void setPhase(int phase) {
        if (this.getStrand() == Strand.POSITIVE) {
            this.readingFrame = phase;
        } else if (this.getStrand() == Strand.NEGATIVE) {
            int modLen;
            this.readingFrame = modLen = (this.getCodingLength() - phase) % 3;
        }
    }

    @Override
    public int getCdStart() {
        return this.codingStart;
    }

    @Override
    public int getCdEnd() {
        return this.codingEnd;
    }

    public int getCodingLength() {
        return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart);
    }

    public AminoAcidSequence getAminoAcidSequence(Genome genome) {
        if (this.aminoAcidSequence == null || !Objects.equal(this.aminoAcidSequence.getCodonTableKey(), AminoAcidManager.getInstance().getCodonTable().getKey())) {
            this.computeAminoAcidSequence(genome);
        }
        return this.aminoAcidSequence;
    }

    private void computeAminoAcidSequence(Genome genome) {
        if (this.utr) {
            return;
        }
        int start = this.getStart();
        int end = this.getEnd();
        String chr = this.getChr();
        if (this.readingFrame >= 0) {
            int readStart = this.codingStart > start ? this.codingStart : start + this.readingFrame;
            int readEnd = Math.min(end, this.codingEnd);
            if (readEnd > readStart + 3) {
                if (this.seqBytes == null) {
                    this.seqBytes = genome.getSequence(chr, readStart, readEnd);
                }
                if (this.seqBytes != null) {
                    this.aminoAcidSequence = AminoAcidManager.getInstance().getAminoAcidSequence(this.getStrand(), readStart, this.seqBytes);
                }
            }
        }
    }

    public Exon copy() {
        Exon copy = new Exon(this.getChr(), this.getStart(), this.getEnd(), this.getStrand());
        copy.seqBytes = this.seqBytes;
        copy.aminoAcidSequence = this.aminoAcidSequence;
        copy.codingEnd = this.codingEnd;
        copy.codingStart = this.codingStart;
        copy.name = this.name;
        copy.utr = this.utr;
        copy.mrnaBase = this.mrnaBase;
        return copy;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        String msg = this.number > 0 ? "Exon number: " + this.number : "";
        int aaNumber = this.getAminoAcidNumber((int)position);
        if (aaNumber > 0) {
            msg = msg + "<br>Amino acid number: " + aaNumber;
        }
        msg = msg + "<br>" + this.getLocusString();
        if (this.description != null) {
            msg = msg + "<br>" + this.description;
        }
        if (this.attributes != null) {
            msg = msg + this.getAttributeString();
        }
        return msg;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public String getURL() {
        return null;
    }

    public static IExon getExonProxy(IExon exon) {
        ExonLocHandler handler = new ExonLocHandler(exon);
        IExon eProx = (IExon)Proxy.newProxyInstance(IExon.class.getClassLoader(), new Class[]{IExon.class}, (InvocationHandler)handler);
        return eProx;
    }

    private static class ExonLocHandler
    implements InvocationHandler {
        private IExon parent;
        private int hashCode = 0;

        public ExonLocHandler(IExon parent) {
            this.parent = parent;
        }

        private boolean equals(IExon parent, Object inother) {
            if (inother == null || !(inother instanceof IExon)) {
                return false;
            }
            IExon other = (IExon)inother;
            boolean eq = parent.getChr().equals(other.getChr());
            eq &= parent.getStart() == other.getStart();
            eq &= parent.getEnd() == other.getEnd();
            eq &= parent.getCdStart() == other.getCdStart();
            eq &= parent.getCdEnd() == other.getCdEnd();
            return eq &= parent.getStrand() == other.getStrand();
        }

        private int hashCode(IExon parent) {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            String conc = parent.getChr() + parent.getStrand().toString() + parent.getStart();
            conc = conc + parent.getEnd();
            conc = conc + parent.getCdStart();
            int hc = (conc = conc + parent.getCdEnd()).hashCode();
            if (hc == 0) {
                hc = 1;
            }
            this.hashCode = hc;
            return hc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("hashCode")) {
                return this.hashCode(this.parent);
            }
            if (method.getName().equals("equals")) {
                return this.equals(this.parent, args[0]);
            }
            return method.invoke((Object)this.parent, args);
        }
    }
}

