/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="database")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={DBTable.class})
public class DBProfile {
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String description;
    @XmlAttribute
    private String version;
    @XmlAttribute
    private String subprotocol;
    @XmlAttribute
    private String host;
    @XmlAttribute
    private String path;
    @XmlAttribute
    private String port;
    @XmlAttribute
    private String username;
    @XmlAttribute
    private String password;
    @XmlElement(name="table")
    private List<DBTable> tableList;
    @XmlTransient
    private ResourceLocator dbLocator;
    private static JAXBContext jc = null;

    public List<DBTable> getTableList() {
        return this.tableList;
    }

    public ResourceLocator getDBLocator() {
        if (this.dbLocator == null) {
            this.dbLocator = new ResourceLocator(DBManager.createConnectionURL(this.subprotocol, this.host, this.path, this.port));
            this.dbLocator.setUsername(this.username);
            this.dbLocator.setPassword(this.password);
        }
        return this.dbLocator;
    }

    public static JAXBContext getJAXBContext() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{DBProfile.class});
        }
        return jc;
    }

    public static DBProfile parseProfile(String profilePath) {
        InputStream profileStream = null;
        try {
            profileStream = ParsingUtils.openInputStream(profilePath);
        }
        catch (IOException e) {
            try {
                if (profileStream != null) {
                    profileStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException("Unable to open DB profile", e);
        }
        Document doc = null;
        try {
            doc = Utilities.createDOMDocumentFromXmlStream(profileStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing DB Profile", e);
        }
        try {
            JAXBContext jc = DBProfile.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            return (DBProfile)u.unmarshal((Node)doc, DBProfile.class).getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error unmarshalling DB Profile, it may be misformed", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.dbLocator = this.getDBLocator();
        for (DBTable table : this.getTableList()) {
            table.setDbLocator(this.dbLocator);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    void addTable(DBTable newTable) {
        if (this.tableList == null) {
            this.tableList = new ArrayList<DBTable>();
        }
        this.tableList.add(newTable);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class DBTable {
        private static Logger log = Logger.getLogger(DBTable.class);
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String format;
        @XmlAttribute
        private String binColName;
        @XmlAttribute
        private String chromoColName;
        @XmlAttribute
        private String posStartColName;
        @XmlAttribute
        private String posEndColName;
        @XmlAttribute
        private int startColIndex = 1;
        @XmlAttribute
        private int endColIndex = Integer.MAX_VALUE;
        @XmlAttribute
        private String baseQuery;
        @XmlElement(name="column")
        private List<Column> columnList;
        @XmlElement(name="header")
        private List<String> headerLines;
        @XmlTransient
        private HashMap<Integer, String> columnLabelMap;
        @XmlTransient
        private ResourceLocator dbLocator;

        public static DBTable build(ResourceLocator dbLocator, String tableName) {
            return new DBTable(dbLocator, tableName, null, null, null, null, null, 1, 0x7FFFFFFE, null, null, null);
        }

        private DBTable() {
        }

        DBTable(ResourceLocator dbLocator, String name) {
            this.dbLocator = dbLocator;
            this.name = name;
        }

        public DBTable(ResourceLocator dbLocator, String name, String format, String binColName, String chromoColName, String posStartColName, String posEndColName, int startColIndex, int endColIndex, HashMap<Integer, String> columnLabelMap, String baseQuery, List<String> headerLines) {
            this.dbLocator = dbLocator;
            this.name = name;
            this.format = format;
            this.binColName = binColName;
            this.chromoColName = chromoColName;
            this.posStartColName = posStartColName;
            this.posEndColName = posEndColName;
            this.startColIndex = startColIndex;
            this.endColIndex = endColIndex;
            this.columnLabelMap = columnLabelMap;
            this.baseQuery = baseQuery;
            this.headerLines = headerLines;
        }

        public void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.columnList != null) {
                this.columnLabelMap = ColumnMapAdapter.unmarshal(this.columnList);
            }
        }

        public ResourceLocator getDbLocator() {
            return this.dbLocator;
        }

        public String getBinColName() {
            return this.binColName;
        }

        public String getChromoColName() {
            return this.chromoColName;
        }

        public int getEndColIndex() {
            return this.endColIndex;
        }

        public String getFormat() {
            return this.format;
        }

        public String getPosEndColName() {
            return this.posEndColName;
        }

        public String getPosStartColName() {
            return this.posStartColName;
        }

        public int getStartColIndex() {
            return this.startColIndex;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseQuery() {
            return this.baseQuery;
        }

        public Map<Integer, String> getColumnLabelMap() {
            return this.columnLabelMap;
        }

        public List<String> getHeaderLines() {
            return this.headerLines;
        }

        void setDbLocator(ResourceLocator dbLocator) {
            this.dbLocator = dbLocator;
        }

        public void setBinColName(String binColName) {
            this.binColName = binColName;
        }

        public void setChromoColName(String chromoColName) {
            this.chromoColName = chromoColName;
        }

        public void setEndColIndex(int endColIndex) {
            this.endColIndex = endColIndex;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setPosEndColName(String posEndColName) {
            this.posEndColName = posEndColName;
        }

        public void setPosStartColName(String posStartColName) {
            this.posStartColName = posStartColName;
        }

        public void setStartColIndex(int startColIndex) {
            this.startColIndex = startColIndex;
        }

        public static String[] columnMapToArray(Map<Integer, String> columnLabelMap) {
            ArrayList<Integer> arrayIndexes = new ArrayList<Integer>(columnLabelMap.keySet());
            Collections.sort(arrayIndexes);
            int minArrayIndex = (Integer)arrayIndexes.get(0);
            int maxArrayIndex = (Integer)arrayIndexes.get(arrayIndexes.size() - 1);
            int colCount = maxArrayIndex + 1;
            String[] tokens = new String[colCount];
            for (int cc = minArrayIndex; cc <= maxArrayIndex; ++cc) {
                tokens[cc] = columnLabelMap.get(cc);
            }
            return tokens;
        }

        private static class Column {
            @XmlAttribute
            private Integer fileIndex;
            @XmlAttribute
            private String colLabel;

            private Column() {
            }
        }

        private static class XmlMap {
            public List<Column> column = new ArrayList<Column>();

            private XmlMap() {
            }
        }

        private static class ColumnMapAdapter
        extends XmlAdapter<XmlMap, HashMap<Integer, String>> {
            private ColumnMapAdapter() {
            }

            public HashMap<Integer, String> unmarshal(XmlMap v) {
                return ColumnMapAdapter.unmarshal(v.column);
            }

            public static HashMap<Integer, String> unmarshal(List<Column> columnList) {
                HashMap<Integer, String> result = new HashMap<Integer, String>(columnList.size());
                for (Column entry : columnList) {
                    result.put(entry.fileIndex, entry.colLabel);
                }
                return result;
            }

            public XmlMap marshal(HashMap<Integer, String> v) {
                XmlMap result = new XmlMap();
                for (Map.Entry<Integer, String> entry : v.entrySet()) {
                    Column mapEntry = new Column();
                    mapEntry.fileIndex = entry.getKey();
                    mapEntry.colLabel = entry.getValue();
                    result.column.add(mapEntry);
                }
                return result;
            }
        }
    }
}

