/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.ContractCreation;
import com.google.java.contract.core.apt.ContractExpressionCreationTrait;
import com.google.java.contract.core.apt.ContractExpressionTransformer;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.MethodContractCreator;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.HelperTypeModel;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.util.ElementScanner;

@Invariant(value={"diagnosticManager != null", "transformer != null"})
public class ClassContractCreator
extends ElementScanner {
    protected DiagnosticManager diagnosticManager;
    protected TypeModel type;
    protected TypeModel helperType;
    protected ContractMethodModel invariant;
    protected ContractExpressionTransformer transformer;

    @Requires(value={"diagnosticManager != null"})
    public ClassContractCreator(DiagnosticManager diagnosticManager) {
        this.diagnosticManager = diagnosticManager;
        this.type = null;
        this.helperType = null;
        this.invariant = null;
        this.transformer = new ContractExpressionTransformer(diagnosticManager, false);
    }

    public TypeModel getHelperType() {
        return this.helperType;
    }

    @Override
    public void visitType(TypeModel typeModel) {
        if (this.type != null) {
            ClassContractCreator classContractCreator = new ClassContractCreator(this.diagnosticManager);
            typeModel.accept(classContractCreator);
            if (classContractCreator.getHelperType() != null) {
                this.type.addEnclosedElement(classContractCreator.getHelperType());
            }
            return;
        }
        this.type = typeModel;
        if (typeModel.getKind() == ElementKind.INTERFACE) {
            this.helperType = new HelperTypeModel(typeModel);
            super.visitType(this.helperType);
        } else {
            super.visitType(typeModel);
        }
    }

    @Override
    public void visitMethod(MethodModel methodModel) {
        methodModel.accept(new MethodContractCreator(this.diagnosticManager));
    }

    @Override
    public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
        if (!contractAnnotationModel.getKind().equals((Object)ElementKind.INVARIANT)) {
            throw new IllegalArgumentException();
        }
        ContractExpressionCreationTrait contractExpressionCreationTrait = new ContractExpressionCreationTrait(this.transformer){

            @Override
            public String getExceptionName() {
                return "com.google.java.contract.InvariantError";
            }
        };
        this.invariant = ContractCreation.createContractMethods(contractExpressionCreationTrait, this.invariant, contractAnnotationModel);
    }
}

