/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import java.util.TreeMap;

@Invariant(value={"root != null"})
public class PatternMap<R> {
    protected TernaryNode root = new TernaryNode(null, false);

    @Requires(value={"isValidPattern(pattern)"})
    public R get(String string) {
        TernaryNode ternaryNode;
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (!bl) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode2 = this.root;
        R r = null;
        for (int i = 0; i < stringArray.length && (ternaryNode = ternaryNode2.children.get(stringArray[i])) != null; ++i) {
            if (ternaryNode.rule != null) {
                if (ternaryNode.exact) {
                    if (bl && i == stringArray.length - 1) {
                        r = ternaryNode.rule;
                    }
                } else {
                    r = ternaryNode.rule;
                }
            }
            ternaryNode2 = ternaryNode;
        }
        return r;
    }

    @Requires(value={"isValidPattern(pattern)"})
    public boolean isOverriden(String string) {
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (bl) {
            return false;
        }
        string2 = string2.substring(0, string2.length() - 2);
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode = this.root;
        for (int i = 0; i < stringArray.length; ++i) {
            TernaryNode ternaryNode2 = ternaryNode.children.get(stringArray[i]);
            if (ternaryNode2 == null) {
                return false;
            }
            ternaryNode = ternaryNode2;
        }
        return !ternaryNode.children.isEmpty();
    }

    @Requires(value={"isValidPattern(pattern)", "rule != null"})
    @Ensures(value={"rule.equals(get(pattern))", "!isOverriden(pattern)"})
    public void put(String string, R r) {
        TernaryNode ternaryNode;
        int n;
        boolean bl;
        String string2 = string.replace('/', '.');
        boolean bl2 = bl = !string2.endsWith(".*");
        if (!bl) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        String[] stringArray = string2.split("\\.");
        TernaryNode ternaryNode2 = this.root;
        TernaryNode ternaryNode3 = this.root;
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            ternaryNode = ternaryNode2.children.get(stringArray[n]);
            if (ternaryNode == null) {
                ternaryNode = new TernaryNode(null, false);
                ternaryNode2.children.put(stringArray[n], ternaryNode);
            }
            if (ternaryNode.rule != null && !ternaryNode.exact) {
                ternaryNode3 = ternaryNode;
                n2 = n;
            }
            ternaryNode2 = ternaryNode;
        }
        if (!bl) {
            ternaryNode2.children.clear();
        }
        if (!r.equals(ternaryNode3.rule)) {
            ternaryNode2.rule = r;
            ternaryNode2.exact = bl;
        } else {
            ternaryNode2 = ternaryNode3;
            for (n = n2 + 1; n < stringArray.length; ++n) {
                ternaryNode = ternaryNode2.children.get(stringArray[n]);
                if (ternaryNode.rule != null) continue;
                ternaryNode2.children.remove(stringArray[n]);
                break;
            }
        }
    }

    public static boolean isValidPattern(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.replace('/', '.');
        return ClassName.isQualifiedName(string2) || ClassName.isStarQualifiedName(string2);
    }

    @Invariant(value={"children != null", "Iterables.all(children.keySet(), ClassName.isSimpleName())", "!children.values().contains(null)"})
    protected class TernaryNode {
        protected TreeMap<String, TernaryNode> children = new TreeMap();
        protected R rule;
        protected boolean exact;

        protected TernaryNode(R r, boolean bl) {
            this.rule = r;
            this.exact = bl;
        }
    }
}

