/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

@Invariant(value={"lineNumbers == null || ContractMethodSignatures.isLineNumberList(lineNumbers)"})
abstract class LineNumberingMethodAdapter
extends AdviceAdapter {
    protected List<Long> lineNumbers = null;

    @Requires(value={"mv != null", "name != null", "desc != null"})
    public LineNumberingMethodAdapter(MethodVisitor methodVisitor, int n, String string, String string2) {
        super(methodVisitor, n, string, string2);
    }

    @Override
    protected void onMethodEnter() {
        Long l;
        if (this.lineNumbers != null && !this.lineNumbers.isEmpty() && (l = this.lineNumbers.get(0)) != null) {
            Label label = new Label();
            this.mark(label);
            this.mv.visitLineNumber(l.intValue(), label);
        }
    }

    @Override
    protected void onMethodExit(int n) {
    }

    @Override
    public void visitLineNumber(int n, Label label) {
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        String string4;
        if (this.lineNumbers != null && string.startsWith(string4 = "com$google$java$contract$local$success$")) {
            try {
                Long l;
                int n2 = Integer.parseInt(string.substring(string4.length()));
                if (n2 < this.lineNumbers.size() && (l = this.lineNumbers.get(n2)) != null) {
                    this.mv.visitLineNumber(l.intValue(), label);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n);
    }
}

