/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Modifier;

public enum ElementModifier {
    PUBLIC,
    PROTECTED,
    PACKAGE_PRIVATE,
    PRIVATE,
    STATIC,
    FINAL,
    VOLATILE,
    TRANSIENT,
    ABSTRACT,
    SYNCHRONIZED,
    NATIVE;


    public boolean isVisibility() {
        switch (this) {
            case PUBLIC: 
            case PROTECTED: 
            case PACKAGE_PRIVATE: 
            case PRIVATE: {
                return true;
            }
        }
        return false;
    }

    @Requires(value={"modifiers != null"})
    public static ElementModifier visibilityIn(EnumSet<ElementModifier> enumSet) {
        for (ElementModifier elementModifier : enumSet) {
            if (!elementModifier.isVisibility()) continue;
            return elementModifier;
        }
        return null;
    }

    @Requires(value={"modifiers != null"})
    @Ensures(value={"result != null"})
    public static EnumSet<ElementModifier> forModifiers(Set<? extends Modifier> set) {
        EnumSet<ElementModifier> enumSet = EnumSet.noneOf(ElementModifier.class);
        if (!(set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PRIVATE))) {
            enumSet.add(PACKAGE_PRIVATE);
        }
        for (Modifier modifier : set) {
            switch (modifier) {
                case PUBLIC: {
                    enumSet.add(PUBLIC);
                    break;
                }
                case PROTECTED: {
                    enumSet.add(PROTECTED);
                    break;
                }
                case PRIVATE: {
                    enumSet.add(PRIVATE);
                    break;
                }
                case STATIC: {
                    enumSet.add(STATIC);
                    break;
                }
                case FINAL: {
                    enumSet.add(FINAL);
                    break;
                }
                case VOLATILE: {
                    enumSet.add(VOLATILE);
                    break;
                }
                case TRANSIENT: {
                    enumSet.add(TRANSIENT);
                    break;
                }
                case ABSTRACT: {
                    enumSet.add(ABSTRACT);
                    break;
                }
                case SYNCHRONIZED: {
                    enumSet.add(SYNCHRONIZED);
                    break;
                }
                case NATIVE: {
                    enumSet.add(NATIVE);
                    break;
                }
            }
        }
        return enumSet;
    }

    public String toString() {
        switch (this) {
            case PUBLIC: 
            case PROTECTED: 
            case PRIVATE: 
            case STATIC: 
            case FINAL: 
            case VOLATILE: 
            case ABSTRACT: 
            case SYNCHRONIZED: {
                return this.name().toLowerCase();
            }
        }
        return "";
    }
}

