/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.dev.affective.AffectiveLogParser;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.TDFBedTile;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFFixedTile;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.tdf.TDFVaryTile;
import org.broad.igv.tdf.TDFWriter;
import org.broad.igv.tools.CommandLineStatusMonitor;
import org.broad.igv.tools.ListAccumulator;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.tools.parsers.CNParser;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.tools.parsers.UnsortedException;
import org.broad.igv.tools.parsers.WiggleParser;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class Preprocessor
implements DataConsumer {
    private static Logger log = Logger.getLogger(Preprocessor.class);
    boolean compressed = true;
    private boolean skipZeroes = false;
    private int nZoom = 7;
    int maxExtFactor = 0;
    Zoom[] zoomLevels;
    int nTracks;
    Genome genome;
    Collection<WindowFunction> windowFunctions;
    private String currentChr = "";
    int currentChrLength;
    private int sizeEstimate;
    int nPtsProcessed = 0;
    StatusMonitor statusMonitor;
    double percentComplete = 0.0;
    int lastStartPosition = 0;
    HashSet<String> skippedChromosomes = new HashSet();
    TDFWriter writer;
    Raw rawData;
    Zoom genomeZoom;
    File outputFile;
    ListAccumulator allDataStats;
    List<String> chromosomes = new ArrayList<String>();
    Set<String> visitedChromosomes = new HashSet<String>();
    Map<String, String> attributes = new HashMap<String, String>();
    PrintStream out = System.out;
    List<WindowFunction> allDataFunctions = Arrays.asList(WindowFunction.mean, WindowFunction.median, WindowFunction.min, WindowFunction.max, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.percentile90, WindowFunction.percentile98);

    public Preprocessor(File outputFile, Genome genome, Collection<WindowFunction> windowFunctions, int sizeEstimate, StatusMonitor monitor) {
        this.statusMonitor = monitor;
        this.outputFile = outputFile;
        this.genome = genome;
        this.windowFunctions = windowFunctions;
        this.sizeEstimate = sizeEstimate;
        this.genome = genome;
        this.allDataStats = new ListAccumulator(this.allDataFunctions);
        if (this.statusMonitor == null) {
            this.statusMonitor = new CommandLineStatusMonitor();
        }
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames) {
        this.setTrackParameters(trackType, trackLine, trackNames, true);
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames, boolean computeWholeGenome) {
        if (trackLine != null) {
            System.out.println(trackLine);
        }
        if (this.outputFile != null && this.writer == null) {
            this.writer = new TDFWriter(this.outputFile, this.genome.getId(), trackType, trackLine, trackNames, this.windowFunctions, this.compressed);
            this.nTracks = trackNames.length;
            if (computeWholeGenome) {
                int genomeLength = (int)(this.genome.getLength() / 1000L);
                this.genomeZoom = new Zoom("All", 0, genomeLength);
            }
            TDFGroup rootGroup = this.writer.getRootGroup();
            rootGroup.setAttribute("genome", this.genome.getId());
            rootGroup.setAttribute("maxZoom", String.valueOf(this.nZoom));
        }
    }

    @Override
    public void addData(String chr, int start, int end, float[] data, String name) {
        if (this.writer == null) {
            return;
        }
        if (this.skipZeroes) {
            boolean allZeroes = true;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == 0.0f) continue;
                allZeroes = false;
                break;
            }
            if (allZeroes) {
                return;
            }
        }
        if (this.statusMonitor != null && this.statusMonitor.isInterrupted()) {
            throw new PreprocessingException("Preprocessing Halted.");
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        if (this.currentChr != null && chr.equals(this.currentChr)) {
            if (start < this.lastStartPosition - this.maxExtFactor) {
                String msg = "Error: Data is not sorted @ " + chr + " " + start + "  (last position = " + this.lastStartPosition + "   max ext factor = " + this.maxExtFactor + ")";
                this.out.println(msg);
                throw new UnsortedException(msg);
            }
        } else {
            this.newChromosome(chr);
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        int chrLength = this.genome.getChromosome(chr).getLength();
        if (start > chrLength) {
            log.debug("Ignoring data from non-existent locus.  Probe = " + name + "  Locus = " + chr + ":" + start + "-" + end + ". " + chr + " length = " + chrLength);
            return;
        }
        this.rawData.addData(start, end, data, name);
        for (Zoom zl : this.zoomLevels) {
            zl.addData(start, end, data);
        }
        long offset = this.genome.getCumulativeOffset(chr);
        int gStart = (int)((offset + (long)start) / 1000L);
        int gEnd = Math.max(gStart + 1, (int)((offset + (long)end) / 1000L));
        if (!(this.genomeZoom == null || chr.equals("chrM") || chr.equals("M") || chr.equals("MT"))) {
            this.genomeZoom.addData(gStart, gEnd, data);
            for (int i = 0; i < data.length; ++i) {
                this.allDataStats.add(gEnd - gStart, data[i]);
            }
        }
        this.lastStartPosition = start;
    }

    public void newChromosome(String chr) {
        if (this.visitedChromosomes.contains(chr)) {
            String msg = "Error: Data is not ordered by start position. Chromosome " + chr + " appears in multiple blocks";
            this.out.println(msg);
            throw new PreprocessingException(msg);
        }
        this.visitedChromosomes.add(chr);
        Chromosome c = this.genome.getChromosome(chr);
        if (c == null) {
            this.out.println("Chromosome: " + chr + " not found in .genome file.  Skipping.");
            this.skippedChromosomes.add(chr);
        } else {
            this.chromosomes.add(chr);
            this.out.println();
            this.out.println("Processing chromosome " + chr);
            if (this.zoomLevels != null) {
                for (Zoom zl : this.zoomLevels) {
                    zl.close();
                }
            }
            if (this.rawData != null) {
                this.rawData.close();
            }
            this.currentChr = chr;
            this.currentChrLength = c.getLength();
            this.zoomLevels = new Zoom[this.getNZoom() + 1];
            for (int z = 0; z <= this.getNZoom(); ++z) {
                this.zoomLevels[z] = new Zoom(chr, z, this.currentChrLength);
            }
            this.rawData = new Raw(chr, this.currentChrLength, 100000);
        }
        this.lastStartPosition = 0;
    }

    @Override
    public void parsingComplete() {
    }

    public void finish() {
        if (this.writer == null) {
            return;
        }
        StringBuffer chrString = new StringBuffer();
        Iterator<String> iter = this.genome.getChromosomeNames().iterator();
        while (iter.hasNext()) {
            String chromoName = iter.next();
            if (!this.chromosomes.contains(chromoName)) continue;
            chrString.append(chromoName);
            if (!iter.hasNext()) continue;
            chrString.append(",");
        }
        this.writer.getRootGroup().setAttribute("chromosomes", chrString.toString());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.writer.getRootGroup().setAttribute(entry.getKey(), entry.getValue());
        }
        if (this.zoomLevels != null) {
            for (Zoom zl : this.zoomLevels) {
                zl.close();
            }
        }
        if (this.genomeZoom != null) {
            this.genomeZoom.close();
        }
        if (this.rawData == null) {
            this.out.println("No features were found that matched chromosomes in genome: " + this.genome.getId());
        } else {
            this.rawData.close();
            this.allDataStats.finish();
            TDFGroup group = this.writer.getGroup("/");
            group.setAttribute("userPercentileAutoscaling", "true");
            for (WindowFunction wf : this.allDataFunctions) {
                group.setAttribute(wf.getValue(), String.valueOf(this.allDataStats.getValue(wf)));
            }
            this.writer.closeFile();
        }
        if (this.statusMonitor != null) {
            this.statusMonitor.setPercentComplete(100.0);
        } else {
            this.out.println("Done");
        }
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void setSortTolerance(int tolerance) {
        this.maxExtFactor = tolerance;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void setSizeEstimate(int sizeEstimate) {
        this.sizeEstimate = sizeEstimate;
    }

    public void setSkipZeroes(boolean skipZeroes) {
        this.skipZeroes = skipZeroes;
    }

    public int getNZoom() {
        return this.nZoom;
    }

    public void setNZoom(int nZoom) {
        this.nZoom = nZoom;
    }

    public static boolean isAlignmentFile(String ext) {
        return ext.equalsIgnoreCase(".bam") || ext.equalsIgnoreCase(".sam") || ext.equalsIgnoreCase(".aligned") || ext.equalsIgnoreCase(".sorted.txt") || ext.equalsIgnoreCase(".bedz") || ext.equalsIgnoreCase(".bed");
    }

    public void preprocess(File iFile, int maxZoomValue, String typeString) throws IOException {
        this.setNZoom(maxZoomValue);
        String tmp = (typeString == null ? iFile.getAbsolutePath() : typeString).toLowerCase();
        if (tmp.endsWith(".txt")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        if (tmp.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        if (tmp.endsWith("wig") || tmp.endsWith("bedgraph") || tmp.endsWith("cpg") || tmp.endsWith("map")) {
            WiggleParser wg = new WiggleParser(iFile.getAbsolutePath(), this, this.genome);
            wg.parse();
        } else if (tmp.endsWith("cn") || tmp.endsWith("xcn") || tmp.endsWith("igv") || tmp.endsWith("snp")) {
            CNParser cnParser = new CNParser(iFile.getAbsolutePath(), (DataConsumer)this, this.genome);
            cnParser.parse();
        } else {
            boolean affective = PreferenceManager.getInstance().getAsBoolean("AFFECTIVE_ENABLE");
            if (affective && (iFile.isDirectory() || tmp.endsWith(".csv"))) {
                AffectiveLogParser parser = new AffectiveLogParser(iFile.getAbsolutePath(), this);
                parser.parse();
            } else {
                this.out.println("Error: cannot convert files of type '" + tmp + "' to TDF format.");
                this.out.println("Try specifying the file type with the --fileType parameter.");
            }
        }
    }

    public static String getExtension(String filename) {
        int idx;
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        if (filename.toLowerCase().endsWith(".sorted.txt")) {
            return ".sorted.txt";
        }
        if (filename.toLowerCase().endsWith(".txt")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if ((idx = filename.lastIndexOf(46)) < 0) {
            return "";
        }
        return filename.substring(idx).toLowerCase();
    }

    class Tile {
        int totalCount = 0;
        int zoomLevel;
        int tileNumber;
        int tileStart;
        int lastFinishedBin = 0;
        double binWidth;
        int nBins;
        int nonEmptyBins;
        ListAccumulator[][] accumulators;
        Map<WindowFunction, TDFDataset> datasets;

        Tile(Map<WindowFunction, TDFDataset> datasets, int zoomLevel, int tileNumber, int nBins, int tileWidth) {
            this.datasets = datasets;
            this.zoomLevel = zoomLevel;
            this.tileNumber = tileNumber;
            this.tileStart = tileNumber * tileWidth;
            this.nBins = nBins;
            this.binWidth = (double)tileWidth / (double)nBins;
            this.accumulators = new ListAccumulator[Preprocessor.this.nTracks][nBins];
        }

        void addData(int start, int end, float[] data) {
            ++this.totalCount;
            int startBin = Math.max(0, (int)((double)(start - this.tileStart) / this.binWidth));
            int endBin = Math.min(this.nBins - 1, (int)((double)(end - this.tileStart) / this.binWidth));
            int tmp = (int)((double)(start - this.tileStart - Preprocessor.this.maxExtFactor) / this.binWidth);
            for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                int b;
                for (b = this.lastFinishedBin; b < tmp; ++b) {
                    if (this.accumulators[t][b] == null) continue;
                    this.accumulators[t][b].finish();
                }
                this.lastFinishedBin = Math.max(0, tmp - 1);
                for (b = startBin; b <= endBin; ++b) {
                    if (this.accumulators[t][b] == null) {
                        this.accumulators[t][b] = new ListAccumulator(this.datasets.keySet());
                    }
                    this.accumulators[t][b].add(end - start, data[t]);
                }
            }
        }

        void close() {
            this.nonEmptyBins = 0;
            for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                for (int i = 0; i < this.nBins; ++i) {
                    if (this.accumulators[t][i] == null) continue;
                    this.accumulators[t][i].finish();
                    if (t != 0) continue;
                    ++this.nonEmptyBins;
                }
            }
            TDFTile tile = null;
            for (WindowFunction wf : this.datasets.keySet()) {
                if ((double)this.nonEmptyBins < 0.5 * (double)this.nBins) {
                    int[] starts = new int[this.nonEmptyBins];
                    float[][] data = new float[Preprocessor.this.nTracks][this.nonEmptyBins];
                    int n = 0;
                    for (int i = 0; i < this.nBins; ++i) {
                        for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                            ListAccumulator acc = this.accumulators[t][i];
                            if (acc == null) continue;
                            data[t][n] = acc.getValue(wf);
                            if (t != Preprocessor.this.nTracks - 1) continue;
                            starts[n] = (int)((double)this.tileStart + (double)i * this.binWidth);
                            ++n;
                        }
                    }
                    tile = new TDFVaryTile(this.tileStart, this.binWidth, starts, data);
                } else {
                    float[][] data = new float[Preprocessor.this.nTracks][this.nBins];
                    for (int t = 0; t < Preprocessor.this.nTracks; ++t) {
                        for (int i = 0; i < this.nBins; ++i) {
                            data[t][i] = this.accumulators[t][i] == null ? Float.NaN : this.accumulators[t][i].getValue(wf);
                        }
                    }
                    tile = new TDFFixedTile(this.tileStart, this.tileStart, this.binWidth, data);
                }
                String dsName = this.datasets.get(wf).getName();
                try {
                    Preprocessor.this.writer.writeTile(dsName, this.tileNumber, tile);
                }
                catch (IOException iOException) {
                    log.error("Error writing tile: " + dsName + " [" + this.tileNumber + "]", iOException);
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    class Zoom {
        int level;
        int tileWidth;
        LinkedHashMap<Integer, Tile> activeTiles = new LinkedHashMap();
        Map<WindowFunction, TDFDataset> datasets = new HashMap<WindowFunction, TDFDataset>();

        Zoom(String chr, int level, int chrLength) {
            int nTiles = (int)Math.pow(2.0, level);
            this.tileWidth = chrLength / nTiles + 1;
            this.level = level;
            for (WindowFunction wf : Preprocessor.this.windowFunctions) {
                String dsName = "/" + chr + "/z" + level + "/" + wf.toString();
                this.datasets.put(wf, Preprocessor.this.writer.createDataset(dsName, TDFDataset.DataType.FLOAT, this.tileWidth, nTiles));
            }
        }

        public void addData(int start, int end, float[] data) {
            Tile t;
            Integer tileNumber;
            int startTile = start / this.tileWidth;
            int endTile = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int i = startTile; i <= endTile; ++i) {
                t = this.activeTiles.get(i);
                if (t == null) {
                    t = new Tile(this.datasets, this.level, i, 700, this.tileWidth);
                    this.activeTiles.put(i, t);
                }
                t.addData(start, end, data);
            }
        }

        public void close() {
            for (Tile t : this.activeTiles.values()) {
                t.close();
            }
        }
    }

    class Raw {
        String chr;
        String dsName;
        TDFDataset dataset;
        int tileWidth;
        Map<Integer, RawTile> activeTiles = new HashMap<Integer, RawTile>();

        Raw(String chr, int chrLength, int tileWidth) {
            this.tileWidth = tileWidth;
            int nTiles = chrLength / tileWidth + 1;
            this.dsName = "/" + chr + "/raw";
            this.dataset = Preprocessor.this.writer.createDataset(this.dsName, TDFDataset.DataType.FLOAT, tileWidth, nTiles);
        }

        public void addData(int start, int end, float[] data, String name) {
            int p;
            Integer tileNumber;
            int startTileNumber = start / this.tileWidth;
            int endTileNumber = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                RawTile t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int t = startTileNumber; t <= endTileNumber; ++t) {
                RawTile tile = this.activeTiles.get(t);
                if (tile == null) {
                    tile = new RawTile(this.dsName, t, t * this.tileWidth, (t + 1) * this.tileWidth);
                    this.activeTiles.put(t, tile);
                }
                tile.addData(start, end, data, name);
            }
            if (Preprocessor.this.statusMonitor != null && Preprocessor.this.sizeEstimate > 0 && (double)(p = (int)(100.0 * (double)Preprocessor.this.nPtsProcessed / (1.5 * (double)Preprocessor.this.sizeEstimate))) > Preprocessor.this.percentComplete) {
                Preprocessor.this.percentComplete = p;
                Preprocessor.this.statusMonitor.setPercentComplete(Preprocessor.this.percentComplete);
            }
            ++Preprocessor.this.nPtsProcessed;
        }

        void close() {
            for (RawTile t : this.activeTiles.values()) {
                t.close();
            }
            this.activeTiles = null;
        }
    }

    class RawTile {
        String dsName;
        int tileNumber;
        int tileStart;
        int tileEnd;
        IntArrayList startArray;
        IntArrayList endArray;
        ArrayList<String> nameList;
        FloatArrayList[] dataArray;

        RawTile(String dsName, int tileNumber, int start, int end) {
            this.dsName = dsName;
            this.tileNumber = tileNumber;
            this.tileStart = start;
            this.tileEnd = end;
            this.startArray = new IntArrayList();
            this.endArray = new IntArrayList();
            this.dataArray = new FloatArrayList[Preprocessor.this.nTracks];
            for (int i = 0; i < Preprocessor.this.nTracks; ++i) {
                this.dataArray[i] = new FloatArrayList();
            }
        }

        void addData(int start, int end, float[] data, String name) {
            if (start > this.tileEnd) {
                log.info("Warning: start position > tile end");
            }
            if (end < this.tileStart) {
                log.info("Warning: end position > tile end");
            }
            if (name != null && this.nameList == null) {
                this.nameList = new ArrayList();
            }
            int dataStart = Math.max(this.tileStart, start);
            int dataEnd = Math.min(this.tileEnd, end);
            this.startArray.add(dataStart);
            this.endArray.add(dataEnd);
            for (int i = 0; i < data.length; ++i) {
                this.dataArray[i].add(data[i]);
            }
            if (name != null) {
                this.nameList.add(name);
            }
        }

        void close() {
            try {
                if (this.startArray.size() > 0) {
                    int[] s = this.startArray.toArray();
                    int[] e = this.endArray.toArray();
                    float[][] d = new float[this.dataArray.length][this.dataArray[0].size()];
                    for (int i = 0; i < this.dataArray.length; ++i) {
                        d[i] = this.dataArray[i].toArray();
                    }
                    String[] n = this.nameList == null ? null : this.nameList.toArray(new String[0]);
                    TDFBedTile tile = new TDFBedTile(this.tileStart, s, e, d, n);
                    Preprocessor.this.writer.writeTile(this.dsName, this.tileNumber, tile);
                    this.startArray.clear();
                    this.endArray.clear();
                    for (int i = 0; i < this.dataArray.length; ++i) {
                        this.dataArray[i].clear();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

