/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFEntity;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.LRUCache;

public class TDFDataset
extends TDFEntity {
    DataType dataType;
    int tileWidth;
    long[] tilePositions;
    int[] tileSizes;
    int nTiles;
    LRUCache<String, TDFTile> cache = new LRUCache(this, 20);
    TDFReader reader;

    public TDFDataset(String name, DataType dataType, int tileWidth, int nTiles) {
        super(name);
        this.dataType = dataType;
        this.tileWidth = tileWidth;
        this.nTiles = nTiles;
        this.tilePositions = new long[nTiles];
        this.tileSizes = new int[nTiles];
        Arrays.fill(this.tilePositions, -1L);
    }

    public TDFDataset(String name, ByteBuffer byteBuffer, TDFReader reader) throws IOException {
        super(name);
        this.reader = reader;
        this.fill(byteBuffer);
    }

    public void write(BufferedByteWriter dos) throws IOException {
        this.writeAttributes(dos);
        this.writeString(dos, this.dataType.toString());
        dos.putFloat(this.tileWidth);
        dos.putInt(this.tilePositions.length);
        for (int i = 0; i < this.tilePositions.length; ++i) {
            dos.putLong(this.tilePositions[i]);
            dos.putInt(this.tileSizes[i]);
        }
    }

    private void fill(ByteBuffer byteBuffer) throws IOException {
        this.readAttributes(byteBuffer);
        String typeString = StringUtils.readString(byteBuffer);
        this.dataType = DataType.valueOf(typeString);
        this.tileWidth = (int)byteBuffer.getFloat();
        this.nTiles = byteBuffer.getInt();
        this.tilePositions = new long[this.nTiles];
        this.tileSizes = new int[this.nTiles];
        for (int i = 0; i < this.nTiles; ++i) {
            this.tilePositions[i] = byteBuffer.getLong();
            this.tileSizes[i] = byteBuffer.getInt();
        }
    }

    public List<TDFTile> getTiles(int startLocation, int endLocation) {
        ArrayList<TDFTile> tiles = new ArrayList<TDFTile>();
        int startTile = startLocation / this.tileWidth;
        int endTile = endLocation / this.tileWidth;
        for (int t = startTile; t <= endTile; ++t) {
            TDFTile tile = this.getTile(t);
            if (tile == null || tile.getSize() <= 0) continue;
            tiles.add(tile);
        }
        return tiles;
    }

    public List<TDFTile> getTiles() {
        ArrayList<TDFTile> tiles = new ArrayList<TDFTile>();
        for (int t = 0; t < this.nTiles; ++t) {
            TDFTile tile = this.getTile(t);
            if (tile == null) continue;
            tiles.add(tile);
        }
        return tiles;
    }

    synchronized TDFTile getTile(int t) {
        String key = this.getName() + "_" + t;
        TDFTile tile = null;
        if (!this.cache.containsKey(key)) {
            tile = this.reader.readTile(this, t);
            this.cache.put(key, tile);
        } else {
            tile = this.cache.get(key);
        }
        return tile;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public static enum DataType {
        BYTE,
        SHORT,
        INT,
        FLOAT,
        DOUBLE,
        STRING;

    }
}

