/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Map;
import org.broad.igv.PreferenceManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.legend.ColorMapEditor;
import org.broad.igv.ui.legend.LegendPanel;

public class MutationLegendPanel
extends LegendPanel {
    PaletteColorTable colorTable;

    public MutationLegendPanel() {
        this.init();
    }

    private void init() {
        PaletteColorTable prefTable = PreferenceManager.getInstance().getMutationColorScheme();
        this.colorTable = new PaletteColorTable();
        for (String key : prefTable.getKeys()) {
            this.colorTable.put(key, prefTable.get(key));
        }
    }

    @Override
    protected void persistResetPreferences() {
        PreferenceManager.getInstance().resetMutationColorScheme();
        this.reloadPreferences();
    }

    @Override
    protected void reloadPreferences() {
        this.init();
        this.repaint();
    }

    protected ColorScale getColorScale() {
        return null;
    }

    @Override
    protected void resetPreferencesToDefault() {
        this.persistResetPreferences();
        this.showResetDisplay();
    }

    @Override
    public void edit() {
        PaletteColorTable ct = PreferenceManager.getInstance().getMutationColorScheme();
        ColorMapEditor editor = new ColorMapEditor(IGV.getMainFrame(), ct.getColorMap());
        editor.setVisible(true);
        Map<String, Color> changedColors = editor.getChangedColors();
        if (!changedColors.isEmpty()) {
            for (Map.Entry<String, Color> entry : changedColors.entrySet()) {
                ct.put(entry.getKey(), entry.getValue());
            }
            String colorTableString = ct.getMapAsString();
            PreferenceManager.getInstance().put("MUTATION_COLOR_TABLE", colorTableString);
            this.reloadPreferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintLegend(Graphics g) {
        if (this.colorTable == null) {
            return;
        }
        Graphics2D g2D = null;
        try {
            int lineHeight;
            g2D = (Graphics2D)g.create();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setFont(FontManager.getFont(10));
            FontMetrics fm = g2D.getFontMetrics();
            int dh = fm.getHeight() / 2 + 3;
            int x = 0;
            int y = lineHeight = 12;
            int colCount = 0;
            for (Map.Entry<String, Color> entry : this.colorTable.entrySet()) {
                String mutType = entry.getKey();
                String label = mutType.replace("_", " ");
                int labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
                g2D.setColor(entry.getValue());
                g2D.fillRect(x, y, 10, 10);
                g2D.setColor(Color.BLACK);
                g2D.drawRect(x, y, 10, 10);
                g2D.drawString(label, x + 20, y + dh);
                x += labelWidth + 40;
                if (++colCount % 5 != 0) continue;
                y += lineHeight + 5;
                x = 0;
            }
        }
        finally {
            g2D.dispose();
        }
    }
}

