/*
 * Decompiled with CFR 0.152.
 */
package com.iontorrent.utils;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    String description;
    String[] extensions;

    public ExtensionFileFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this.description = description == null ? extensions[0] : description;
        this.extensions = (String[])extensions.clone();
        this.toLower(this.extensions);
    }

    private void toLower(String[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = array[i].toLowerCase();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String path = file.getAbsolutePath().toLowerCase();
        for (String extension : this.extensions) {
            if (extension.startsWith("*")) {
                extension = extension.substring(1);
            }
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private void err(String msg, Exception ex) {
        Logger.getLogger(ExtensionFileFilter.class.getName()).log(Level.SEVERE, msg, ex);
    }

    private void err(String msg) {
        Logger.getLogger(ExtensionFileFilter.class.getName()).log(Level.SEVERE, msg);
    }

    private void warn(String msg) {
        Logger.getLogger(ExtensionFileFilter.class.getName()).log(Level.WARNING, msg);
    }

    private void p(String msg) {
        System.out.println("ExtensionFileFilter: " + msg);
    }
}

