/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.text.NumberFormat;
import java.util.Locale;
import org.broad.igv.feature.NamedFeature;

public class Locus
implements NamedFeature {
    protected String chr = null;
    protected int start = -1;
    protected int end = -1;
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);

    public Locus(String chr, int start, int end) {
        this.chr = chr;
        this.start = start;
        this.end = end;
    }

    public static Locus fromString(String locusString) {
        Locus l = new Locus(locusString);
        return l.isValid() ? l : null;
    }

    public Locus(String locusString) {
        this.parseLocusString(locusString);
    }

    public boolean isValid() {
        return this.getChr() != null && this.getStart() >= 0 && this.getEnd() >= this.getStart();
    }

    private void parseLocusString(String locusString) {
        int colonIndex = locusString.indexOf(":");
        int dashIndex = locusString.indexOf("-");
        if (colonIndex > 0 && dashIndex > 0) {
            this.chr = locusString.substring(0, colonIndex);
            String posString = locusString.substring(colonIndex).replace(":", "");
            this.setStartEnd(posString);
        }
    }

    private void setStartEnd(String posString) {
        String[] posTokens = posString.split("-");
        if (posTokens.length >= 2) {
            try {
                String startString = posTokens[0].replaceAll(",", "");
                String endString = posTokens[1].replaceAll(",", "");
                this.start = Math.max(0, Integer.parseInt(startString));
                this.end = Integer.parseInt(endString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return this.chr + ":" + this.start + "-" + this.end;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public static String getFormattedLocusString(String chr, int start, int end) {
        String startStr = NUMBER_FORMAT.format(start);
        String endStr = NUMBER_FORMAT.format(end);
        String position = chr + ":" + startStr + "-" + endStr;
        return position;
    }

    public boolean contains(String chr, int start, int end) {
        return this.chr.equals(chr) && this.start <= start && this.end >= end;
    }

    public boolean overlaps(String chr, int start, int end) {
        return this.chr.equals(chr) && this.start <= end && this.end >= start;
    }
}

