/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.Paintable;

public class AttributeHeaderPanel
extends JPanel
implements Paintable {
    static final int MAXIMUM_FONT_SIZE = 10;
    public static final int ATTRIBUTE_COLUMN_WIDTH = 10;
    public static final int COLUMN_BORDER_WIDTH = 1;
    Map<String, Boolean> sortOrder = new HashMap<String, Boolean>();

    public AttributeHeaderPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener();
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    private String getAttributeHeading(int x) {
        int idx = x / 11;
        List<String> keys = AttributeManager.getInstance().getVisibleAttributes();
        if (idx < keys.size()) {
            return keys.get(idx);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        List<String> keys = AttributeManager.getInstance().getVisibleAttributes();
        if (keys != null && keys.size() > 0) {
            Graphics2D graphics2 = (Graphics2D)graphics.create();
            graphics2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int columnWidth = this.getAttributeColumnWidth();
            int fontSize = (int)(0.9 * (double)columnWidth);
            if (fontSize > 10) {
                fontSize = 10;
            }
            Font font = FontManager.getFont(fontSize);
            AffineTransform transform = AffineTransform.getTranslateInstance(0.0, this.getHeight() - 1);
            graphics2.transform(transform);
            transform = AffineTransform.getQuadrantRotateInstance(-1);
            graphics2.transform(transform);
            graphics2.setFont(font);
            graphics2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = graphics2.getFontMetrics();
            int fontAscent = fm.getHeight();
            int i = 1;
            for (String key : keys) {
                int columnLeftEdge = 11 * i++;
                int x = columnLeftEdge + (11 - fontAscent) / 2;
                String toDraw = key;
                int stringOffset = 2;
                graphics2.drawString(toDraw, stringOffset, x);
            }
        }
    }

    private void addMouseListener() {
        this.setToolTipText("Click attribute heading to sort");
        MouseInputAdapter listener = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String attKey = AttributeHeaderPanel.this.getAttributeHeading(e.getX());
                if (attKey != null) {
                    Boolean tmp = AttributeHeaderPanel.this.sortOrder.get(attKey);
                    boolean sortAscending = tmp == null ? true : tmp;
                    AttributeHeaderPanel.this.sortTrackByAttribute(attKey, sortAscending);
                    AttributeHeaderPanel.this.sortOrder.put(attKey, !sortAscending);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String attKey = AttributeHeaderPanel.this.getAttributeHeading(e.getX());
                if (attKey != null) {
                    AttributeManager.ColumnMetaData md = AttributeManager.getInstance().getColumnMetaData(attKey);
                    if (md != null) {
                        StringBuffer buf = new StringBuffer("<html>" + attKey + "<br>Click to sort");
                        AttributeHeaderPanel.this.setToolTipText(buf.toString());
                        return;
                    }
                    AttributeHeaderPanel.this.setToolTipText("Click attribute heading to sort");
                }
            }
        };
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public final void sortTrackByAttribute(String sortKey, boolean isSortAscending) {
        if (sortKey != null) {
            IGV.getInstance().sortAllTracksByAttributes(new String[]{sortKey}, new boolean[]{isSortAscending});
            IGV.getMainFrame().repaint();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        this.paintComponent(g);
        Color c = g.getColor();
        g.setColor(Color.darkGray);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(c);
    }
}

