/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.exome;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.exome.ExomeBlock;
import org.broad.igv.feature.exome.ExomeReferenceFrame;
import org.broad.tribble.Feature;

public class ExomeUtils {
    public static List<ExomeReferenceFrame.Gene> collapseToGenes(List<Feature> features) {
        HashMap<String, ExomeReferenceFrame.Gene> genes = new HashMap<String, ExomeReferenceFrame.Gene>(10000);
        for (Feature f : features) {
            if (!(f instanceof BasicFeature)) continue;
            String geneName = ((BasicFeature)f).getName();
            ExomeReferenceFrame.Gene gene = (ExomeReferenceFrame.Gene)genes.get(geneName);
            if (gene == null) {
                gene = new ExomeReferenceFrame.Gene((BasicFeature)f);
                genes.put(geneName, gene);
                continue;
            }
            gene.expand(f);
        }
        ArrayList<ExomeReferenceFrame.Gene> geneList = new ArrayList<ExomeReferenceFrame.Gene>(genes.values());
        FeatureUtils.sortFeatureList(geneList);
        return geneList;
    }

    static List<ExomeBlock> collapseTranscripts(List<Feature> features) {
        ArrayList<Feature> exons = new ArrayList<Feature>(features.size() * 10);
        for (Feature f : features) {
            List<Exon> tmp;
            if (!(f instanceof BasicFeature) || (tmp = ((BasicFeature)f).getExons()) == null) continue;
            exons.addAll(tmp);
        }
        FeatureUtils.sortFeatureList(exons);
        List<ExomeBlock> blocks = ExomeUtils.collapseFeatures(exons);
        return blocks;
    }

    private static List<ExomeBlock> collapseFeatures(List<Feature> features) {
        ArrayList<ExomeBlock> blocks = new ArrayList<ExomeBlock>();
        if (features.isEmpty()) {
            return blocks;
        }
        Iterator<Feature> iter = features.iterator();
        Feature f = iter.next();
        int blockIndex = 0;
        int exomeStart = 0;
        ExomeBlock block = new ExomeBlock(blockIndex, f.getStart(), exomeStart, f.getEnd() - f.getStart());
        while (iter.hasNext()) {
            f = iter.next();
            if (f.getStart() > block.getGenomeEnd()) {
                blocks.add(block);
                int blockLength = block.getLength();
                int startingLength = f.getEnd() - f.getStart();
                block = new ExomeBlock(++blockIndex, f.getStart(), exomeStart += blockLength, startingLength);
                continue;
            }
            block.extend(f.getEnd());
        }
        return blocks;
    }
}

