/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeBuilder;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public final class VCFAlleleClipper {
    private VCFAlleleClipper() {
    }

    @Requires(value={"unclippedAlleles != null"})
    public static boolean shouldClipFirstBaseP(List<Allele> unclippedAlleles, byte ref0) {
        boolean allSymbolicAlt = true;
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic()) continue;
            if (!a.isReference()) {
                allSymbolicAlt = false;
            }
            if (a.length() >= 1 && a.getBases()[0] == ref0) continue;
            return false;
        }
        return !allSymbolicAlt;
    }

    public static int computeReverseClipping(List<Allele> unclippedAlleles, byte[] ref, int forwardClipping, boolean allowFullClip) {
        int clipping = 0;
        boolean stillClipping = true;
        while (stillClipping) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) continue;
                if (a.length() - clipping == 0) {
                    return clipping - (allowFullClip ? 0 : 1);
                }
                if (a.length() - clipping <= forwardClipping || a.length() - forwardClipping == 0) {
                    stillClipping = false;
                    continue;
                }
                if (ref.length == clipping) {
                    if (allowFullClip) {
                        stillClipping = false;
                        continue;
                    }
                    return -1;
                }
                if (a.getBases()[a.length() - clipping - 1] == ref[ref.length - clipping - 1]) continue;
                stillClipping = false;
            }
            if (!stillClipping) continue;
            ++clipping;
        }
        return clipping;
    }

    @Requires(value={"!alleles.isEmpty()"})
    private static boolean isSingleNucleotideEvent(List<Allele> alleles) {
        for (Allele a : alleles) {
            if (a.length() == 1) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"start > 0", "ref != null && ref.length() > 0", "!unclippedAlleles.isEmpty()"})
    @Ensures(value={"result != null"})
    public static ClippedAlleles clipAlleles(int start, String ref, List<Allele> unclippedAlleles, int endForSymbolicAllele) {
        List<Allele> clippedAlleles;
        boolean needsClipping;
        if (unclippedAlleles.size() == 1 || VCFAlleleClipper.isSingleNucleotideEvent(unclippedAlleles)) {
            return new ClippedAlleles(start, unclippedAlleles, null);
        }
        byte firstRefBase = (byte)ref.charAt(0);
        boolean firstBaseIsClipped = VCFAlleleClipper.shouldClipFirstBaseP(unclippedAlleles, firstRefBase);
        int forwardClipping = firstBaseIsClipped ? 1 : 0;
        int reverseClipping = VCFAlleleClipper.computeReverseClipping(unclippedAlleles, ref.getBytes(), forwardClipping, false);
        boolean bl = needsClipping = forwardClipping > 0 || reverseClipping > 0;
        if (reverseClipping == -1) {
            return new ClippedAlleles("computeReverseClipping failed due to bad alleles");
        }
        boolean sawSymbolic = false;
        if (!needsClipping) {
            clippedAlleles = unclippedAlleles;
        } else {
            clippedAlleles = new ArrayList<Allele>(unclippedAlleles.size());
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) {
                    sawSymbolic = true;
                    clippedAlleles.add(a);
                    continue;
                }
                byte[] allele = Arrays.copyOfRange(a.getBases(), forwardClipping, a.getBases().length - reverseClipping);
                if (!Allele.acceptableAlleleBases(allele)) {
                    return new ClippedAlleles("Unparsable vcf record with bad allele [" + allele + "]");
                }
                clippedAlleles.add(Allele.create(allele, a.isReference()));
            }
        }
        int stop = VariantContextUtils.computeEndFromAlleles(clippedAlleles, start, endForSymbolicAllele);
        if (needsClipping && !sawSymbolic && !clippedAlleles.get(0).isNull()) {
            ++stop;
        }
        Byte refBaseForIndel = firstBaseIsClipped ? Byte.valueOf(firstRefBase) : null;
        return new ClippedAlleles(stop, clippedAlleles, refBaseForIndel);
    }

    public static boolean needsPadding(VariantContext inputVC) {
        if (inputVC.isBiallelic() && inputVC.getAlternateAllele(0).isSymbolic()) {
            return false;
        }
        int recordLength = inputVC.getEnd() - inputVC.getStart() + 1;
        int referenceLength = inputVC.getReference().length();
        if (referenceLength == recordLength) {
            return false;
        }
        if (referenceLength == recordLength - 1) {
            return true;
        }
        if (!inputVC.hasSymbolicAlleles()) {
            throw new IllegalArgumentException("Badly formed variant context at location " + String.valueOf(inputVC.getStart()) + " in contig " + inputVC.getChr() + ". Reference length must be at most one base shorter than location size");
        }
        if (inputVC.isMixed() && inputVC.hasSymbolicAlleles()) {
            throw new IllegalArgumentException("GATK infrastructure limitation prevents needsPadding from working properly with VariantContexts containing a mixture of symbolic and concrete alleles at " + inputVC);
        }
        return false;
    }

    public static Allele padAllele(VariantContext vc, Allele allele) {
        assert (VCFAlleleClipper.needsPadding(vc));
        if (allele.isSymbolic()) {
            return allele;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)vc.getReferenceBaseForIndel().byteValue());
        sb.append(allele.getDisplayString());
        String newBases = sb.toString();
        return Allele.create(newBases, allele.isReference());
    }

    public static VariantContext createVariantContextWithPaddedAlleles(VariantContext inputVC) {
        boolean padVC = VCFAlleleClipper.needsPadding(inputVC);
        if (padVC) {
            if (!inputVC.hasReferenceBaseForIndel()) {
                throw new ReviewedStingException("Badly formed variant context at location " + inputVC.getChr() + ":" + inputVC.getStart() + "; no padded reference base is available.");
            }
            ArrayList<Allele> alleles = new ArrayList<Allele>(inputVC.getNAlleles());
            HashMap<Allele, Allele> unpaddedToPadded = inputVC.hasGenotypes() ? new HashMap<Allele, Allele>(inputVC.getNAlleles()) : null;
            boolean paddedAtLeastOne = false;
            for (Allele a : inputVC.getAlleles()) {
                Allele padded = VCFAlleleClipper.padAllele(inputVC, a);
                paddedAtLeastOne = paddedAtLeastOne || padded != a;
                alleles.add(padded);
                if (unpaddedToPadded == null) continue;
                unpaddedToPadded.put(a, padded);
            }
            if (!paddedAtLeastOne) {
                throw new ReviewedStingException("VC was supposed to need padding but no allele was actually changed at location " + inputVC.getChr() + ":" + inputVC.getStart() + " with allele " + inputVC.getAlleles());
            }
            VariantContextBuilder vcb = new VariantContextBuilder(inputVC);
            vcb.alleles((Collection<Allele>)alleles);
            vcb.computeEndFromAlleles(alleles, inputVC.getStart(), inputVC.getEnd());
            if (inputVC.hasGenotypes()) {
                assert (unpaddedToPadded != null);
                GenotypesContext genotypes = GenotypesContext.create(inputVC.getNSamples());
                for (Genotype g : inputVC.getGenotypes()) {
                    ArrayList<Allele> newGenotypeAlleles = new ArrayList<Allele>(g.getAlleles().size());
                    for (Allele a : g.getAlleles()) {
                        newGenotypeAlleles.add(a.isCalled() ? (Allele)unpaddedToPadded.get(a) : Allele.NO_CALL);
                    }
                    genotypes.add(new GenotypeBuilder(g).alleles(newGenotypeAlleles).make());
                }
                vcb.genotypes(genotypes);
            }
            return vcb.make();
        }
        return inputVC;
    }

    public static VariantContext reverseTrimAlleles(VariantContext inputVC) {
        int trimExtent = VCFAlleleClipper.computeReverseClipping(inputVC.getAlleles(), inputVC.getReference().getDisplayString().getBytes(), 0, true);
        if (trimExtent <= 0 || inputVC.getAlleles().size() <= 1) {
            return inputVC;
        }
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        GenotypesContext genotypes = GenotypesContext.create();
        HashMap<Allele, Allele> originalToTrimmedAlleleMap = new HashMap<Allele, Allele>();
        for (Allele a : inputVC.getAlleles()) {
            if (a.isSymbolic()) {
                alleles.add(a);
                originalToTrimmedAlleleMap.put(a, a);
                continue;
            }
            byte[] newBases = Arrays.copyOfRange(a.getBases(), 0, a.length() - trimExtent);
            Allele trimmedAllele = Allele.create(newBases, a.isReference());
            alleles.add(trimmedAllele);
            originalToTrimmedAlleleMap.put(a, trimmedAllele);
        }
        for (Genotype genotype : inputVC.getGenotypes()) {
            List<Allele> originalAlleles = genotype.getAlleles();
            ArrayList<Allele> trimmedAlleles = new ArrayList<Allele>();
            for (Allele a : originalAlleles) {
                if (a.isCalled()) {
                    trimmedAlleles.add((Allele)originalToTrimmedAlleleMap.get(a));
                    continue;
                }
                trimmedAlleles.add(Allele.NO_CALL);
            }
            genotypes.add(new GenotypeBuilder(genotype).alleles(trimmedAlleles).make());
        }
        return new VariantContextBuilder(inputVC).stop(inputVC.getStart() + ((Allele)alleles.get(0)).length() + (inputVC.isMixed() ? -1 : 0)).alleles((Collection<Allele>)alleles).genotypes(genotypes).make();
    }

    @Invariant(value={"stop != -1 || error != null"})
    public static class ClippedAlleles {
        private final int stop;
        private final List<Allele> clippedAlleles;
        private final Byte refBaseForIndel;
        private final String error;

        @Requires(value={"stop > 0", "clippedAlleles != null"})
        private ClippedAlleles(int stop, List<Allele> clippedAlleles, Byte refBaseForIndel) {
            this.stop = stop;
            this.clippedAlleles = clippedAlleles;
            this.error = null;
            this.refBaseForIndel = refBaseForIndel;
        }

        @Requires(value={"error != null"})
        private ClippedAlleles(String error) {
            this.stop = -1;
            this.clippedAlleles = null;
            this.refBaseForIndel = null;
            this.error = error;
        }

        public String getError() {
            return this.error;
        }

        public int getStop() {
            return this.stop;
        }

        public List<Allele> getClippedAlleles() {
            return this.clippedAlleles;
        }

        public Byte getRefBaseForIndel() {
            return this.refBaseForIndel;
        }
    }
}

