/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.RadioButtonSelectionList;
import org.broad.igv.ui.panel.TrackWrapper;

public class FeatureTrackSelectionDialog
extends JDialog {
    boolean isCanceled = false;
    private JPanel dialogPane;
    private JPanel vSpacer1;
    private JPanel contentPanel;
    private JScrollPane featureTrackPanel;
    private RadioButtonSelectionList featureTrackList;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public FeatureTrackSelectionDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.setModal(true);
        List<FeatureTrack> tracks = IGV.getInstance().getFeatureTracks();
        List<TrackWrapper> wrappers = TrackWrapper.wrapTracks(tracks);
        this.featureTrackList.setListData(wrappers.toArray());
    }

    public FeatureTrackSelectionDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public FeatureTrack getSelectedTrack() {
        if (this.isCanceled) {
            return null;
        }
        Object selection = this.featureTrackList.getCheckBoxListSelectedValue();
        if (selection == null) {
            return null;
        }
        return ((TrackWrapper)selection).getTrack();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.contentPanel = new JPanel();
        this.featureTrackPanel = new JScrollPane();
        this.featureTrackList = new RadioButtonSelectionList();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setMinimumSize(new Dimension(220, 220));
        this.dialogPane.setLayout(new BorderLayout());
        this.vSpacer1.setPreferredSize(new Dimension(10, 30));
        this.dialogPane.add((Component)this.vSpacer1, "North");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.featureTrackList.setClickInCheckBoxOnly(false);
        this.featureTrackList.setSelectionMode(0);
        this.featureTrackPanel.setViewportView(this.featureTrackList);
        this.contentPanel.add(this.featureTrackPanel);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureTrackSelectionDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureTrackSelectionDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

