/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.PluginSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.tribble.Feature;

public class PluginFeatureSource
extends PluginSource
implements FeatureSource<Feature> {
    private static Logger log = Logger.getLogger(PluginFeatureSource.class);

    public PluginFeatureSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, Map<String, String> parsingAttrs, String specPath) {
        super(commands, arguments, parsingAttrs, specPath);
    }

    @Override
    protected String createTempFile(Track track, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        FeatureTrack fTrack = (FeatureTrack)track;
        List<Feature> features = fTrack.getFeatures(chr, start, end);
        return super.createTempFile(features, argument);
    }

    @Override
    public final Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        return super.getFeatures(chr, start, end, -1);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public final int getFeatureWindowSize() {
        int featureWindowSize = this.getMinSizeFromTracks(this.arguments.values());
        return featureWindowSize;
    }

    private int getMinSizeFromTracks(Iterable tracks) {
        int featureWindowSize = Integer.MAX_VALUE;
        for (Object val : tracks) {
            int tmpSize = Integer.MAX_VALUE;
            if (val instanceof FeatureTrack) {
                FeatureTrack track = (FeatureTrack)val;
                tmpSize = track.getFeatureWindowSize();
            } else if (val instanceof List) {
                featureWindowSize = this.getMinSizeFromTracks((List)val);
            }
            featureWindowSize = Math.min(featureWindowSize, tmpSize);
        }
        return featureWindowSize;
    }

    @Override
    public final void setFeatureWindowSize(int size) {
    }
}

