/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.LineFeatureEncoder;
import org.broad.igv.feature.LocusScore;
import org.broad.tribble.Feature;

public class BEDGraphEncoder
implements LineFeatureEncoder {
    protected final Pattern splitter = Pattern.compile("\\s+");
    protected String delimiter = "\t";

    public String encode(Feature feature) {
        if (feature instanceof LocusScore) {
            return this.encode((LocusScore)feature);
        }
        return null;
    }

    public String encode(LocusScore score) {
        Object[] tokens = new String[]{score.getChr(), "" + score.getStart(), "" + score.getEnd(), "" + score.getScore()};
        String out = StringUtils.join(tokens, this.delimiter);
        return out;
    }

    @Override
    public int getNumCols(String line) {
        return this.splitter.split(line).length;
    }

    @Override
    public String getHeader() {
        return "track type=bedGraph";
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
    }
}

