/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectionModelGroup<T, V>
implements Serializable {
    private static final long serialVersionUID = 2434517670879999353L;
    protected List<T> _models = new Vector<T>();
    protected V _selectionListener = this.createSelectionListener();

    protected abstract V createSelectionListener();

    protected abstract void addSelectionListener(T var1, V var2);

    protected abstract void removeSelectionListener(T var1, V var2);

    public void add(T model) {
        if (model == null) {
            return;
        }
        if (!this._models.contains(model)) {
            this._models.add(model);
            this.addSelectionListener(model, this._selectionListener);
        }
    }

    public void add(int index, T model) {
        if (model == null) {
            return;
        }
        if (!this._models.contains(model)) {
            if (index < 0 || index > this._models.size()) {
                this._models.add(model);
            } else {
                this._models.add(index, model);
            }
            this.addSelectionListener(model, this._selectionListener);
        }
    }

    public void remove(T model) {
        if (model == null) {
            return;
        }
        if (this._models.remove(model)) {
            this.removeSelectionListener(model, this._selectionListener);
        }
    }

    public void removeAll() {
        if (this._models == null) {
            return;
        }
        for (T model : this._models) {
            this.removeSelectionListener(model, this._selectionListener);
        }
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(this._models);
    }

    public List<T> getModels() {
        return this._models;
    }

    public int getModelCount() {
        if (this._models == null) {
            return 0;
        }
        return this._models.size();
    }
}

