/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Strand;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;

public class GenbankParser {
    private String accession;
    private byte[] sequence;
    private List<Feature> features;
    private String locusName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GenbankParser(String path) throws IOException {
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(path);
            this.readLocus(reader);
            this.readAccession(reader);
            this.readFeatures(reader);
            this.readOriginSequence(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public byte[] getSequence(String chr, int qstart, int qend) {
        if (this.sequence == null) {
            return null;
        }
        int start = Math.max(0, qstart);
        int end = Math.min(this.sequence.length, qend);
        int len = end - start;
        byte[] bytes = new byte[len];
        Arrays.fill(bytes, (byte)0);
        int s = Math.max(start, 0);
        System.arraycopy(this.sequence, s, bytes, 0, len);
        return bytes;
    }

    public int getSequenceLenth() {
        return this.sequence == null ? 0 : this.sequence.length;
    }

    private void readLocus(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        String[] tokens = Globals.whitespacePattern.split(line);
        if (!tokens[0].equalsIgnoreCase("LOCUS")) {
            // empty if block
        }
        this.locusName = tokens[1].trim();
    }

    private void readAccession(BufferedReader reader) throws IOException {
        String line = null;
        while (!(line = reader.readLine()).startsWith("ACCESSION")) {
        }
        if (line == null) {
            // empty if block
        }
        String[] tokens = Globals.whitespacePattern.split(line);
        this.accession = tokens[1].trim();
    }

    private void readOriginSequence(BufferedReader reader) throws IOException {
        String nextLine;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100000);
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("//")) {
            nextLine = nextLine.trim();
            String[] tokens = Globals.whitespacePattern.split(nextLine);
            for (int i = 1; i < tokens.length; ++i) {
                buffer.write(tokens[i].getBytes());
            }
        }
        this.sequence = buffer.toByteArray();
    }

    private void readFeatures(BufferedReader reader) throws IOException {
        String nextLine;
        while (!(nextLine = reader.readLine()).startsWith("FEATURES")) {
        }
        this.features = new ArrayList<Feature>();
        BasicFeature f = null;
        String currentLocQualifier = null;
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("ORIGIN")) {
            if (nextLine.charAt(5) != ' ') {
                String featureType = nextLine.substring(5, 21).trim();
                f = new BasicFeature();
                f.setChr(this.accession);
                f.setType(featureType);
                currentLocQualifier = nextLine.substring(21);
                if (featureType.toLowerCase().equals("source")) continue;
                this.features.add(f);
                continue;
            }
            String tmp = nextLine.substring(21).trim();
            if (tmp.length() <= 0) continue;
            if (tmp.charAt(0) == '/') {
                if (currentLocQualifier.charAt(0) == '/') {
                    String[] tokens = Globals.equalPattern.split(currentLocQualifier, 2);
                    if (tokens.length > 1) {
                        String keyName = tokens[0].length() > 1 ? tokens[0].substring(1) : "";
                        f.setAttribute(keyName, tokens[1]);
                    }
                } else {
                    Strand strand = currentLocQualifier.contains("complement") ? Strand.NEGATIVE : Strand.POSITIVE;
                    f.setStrand(strand);
                    String joinString = currentLocQualifier.replace("join", "");
                    joinString = joinString.replace("complement", "");
                    joinString = joinString.replace("(", "");
                    joinString = joinString.replace(")", "");
                    if (joinString.contains("..")) {
                        joinString = joinString.replace("<", "");
                        joinString = joinString.replace(">", "");
                        List<Exon> exons = this.createExons(joinString, strand);
                        FeatureUtils.sortFeatureList(exons);
                        Exon firstExon = exons.get(0);
                        f.setStart(firstExon.getStart());
                        Exon lastExon = exons.get(exons.size() - 1);
                        f.setEnd(lastExon.getEnd());
                        if (exons.size() > 1) {
                            for (Exon exon : exons) {
                                f.addExon(exon);
                            }
                        }
                    } else {
                        int start = Integer.parseInt(joinString) - 1;
                        int end = start + 1;
                        f.setStart(start);
                        f.setEnd(end);
                    }
                }
                currentLocQualifier = tmp;
                continue;
            }
            currentLocQualifier = currentLocQualifier == null ? tmp : currentLocQualifier + tmp;
        }
    }

    List<Exon> createExons(String joinString, Strand strand) {
        String[] lociArray = joinString.split(",");
        ArrayList<Exon> exons = new ArrayList<Exon>(lociArray.length);
        boolean isNegative = joinString.contains("complement");
        for (String loci : lociArray) {
            String[] tmp = loci.split("\\.\\.");
            int exonStart = Integer.parseInt(tmp[0]) - 1;
            int exonEnd = exonStart + 1;
            if (tmp.length > 1) {
                exonEnd = Integer.parseInt(tmp[1]);
            }
            Exon r = new Exon(this.accession, exonStart, exonEnd, strand);
            exons.add(r);
        }
        return exons;
    }

    public String getAccession() {
        return this.accession;
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public String getLocusName() {
        return this.locusName;
    }
}

