/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeSet;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypeType;

@Invariant(value={"getAlleles() != null", "getSampleName() != null", "getPloidy() >= 0", "! hasForbiddenKey(getExtendedAttributes())"})
public abstract class Genotype
implements Comparable<Genotype> {
    public static final Collection<String> PRIMARY_KEYS = Arrays.asList("FT", "GT", "GQ", "DP", "AD", "PL");
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    private final String sampleName;
    private GenotypeType type = null;
    private final String filters;

    protected Genotype(String sampleName, String filters) {
        this.sampleName = sampleName;
        this.filters = filters;
    }

    @Ensures(value={"result != null"})
    public abstract List<Allele> getAlleles();

    @Requires(value={"allele != null"})
    @Ensures(value={"result >= 0"})
    public int countAllele(Allele allele) {
        int c = 0;
        for (Allele a : this.getAlleles()) {
            if (!a.equals(allele)) continue;
            ++c;
        }
        return c;
    }

    @Requires(value={"i >=0 && i < getPloidy()", "getType() != GenotypeType.UNAVAILABLE"})
    @Ensures(value={"result != null"})
    public abstract Allele getAllele(int var1);

    public abstract boolean isPhased();

    @Ensures(value={"result >= 0"})
    public int getPloidy() {
        return this.getAlleles().size();
    }

    @Ensures(value={"result >= -1"})
    public abstract int getDP();

    public abstract int[] getAD();

    @Ensures(value={"result != null"})
    public String getSampleName() {
        return this.sampleName;
    }

    @Ensures(value={"result >= -1"})
    public abstract int getGQ();

    @Ensures(value={"(result == false && getPL() == null) || (result == true && getPL() != null)"})
    public boolean hasPL() {
        return this.getPL() != null;
    }

    @Ensures(value={"(result == false && getAD() == null) || (result == true && getAD() != null)"})
    public boolean hasAD() {
        return this.getAD() != null;
    }

    @Ensures(value={"(result == false && getGQ() == -1) || (result == true && getGQ() >= 0)"})
    public boolean hasGQ() {
        return this.getGQ() != -1;
    }

    @Ensures(value={"(result == false && getDP() == -1) || (result == true && getDP() >= 0)"})
    public boolean hasDP() {
        return this.getDP() != -1;
    }

    @Ensures(value={"type != null", "result != null"})
    public GenotypeType getType() {
        if (this.type == null) {
            this.type = this.determineType();
        }
        return this.type;
    }

    @Requires(value={"type == null"})
    protected GenotypeType determineType() {
        List<Allele> alleles = this.getAlleles();
        if (alleles.isEmpty()) {
            return GenotypeType.UNAVAILABLE;
        }
        boolean sawNoCall = false;
        boolean sawMultipleAlleles = false;
        Allele observedAllele = null;
        for (Allele allele : alleles) {
            if (allele.isNoCall()) {
                sawNoCall = true;
                continue;
            }
            if (observedAllele == null) {
                observedAllele = allele;
                continue;
            }
            if (allele.equals(observedAllele)) continue;
            sawMultipleAlleles = true;
        }
        if (sawNoCall) {
            if (observedAllele == null) {
                return GenotypeType.NO_CALL;
            }
            return GenotypeType.MIXED;
        }
        if (observedAllele == null) {
            throw new ReviewedStingException("BUG: there are no alleles present in this genotype but the alleles list is not null");
        }
        return sawMultipleAlleles ? GenotypeType.HET : (observedAllele.isReference() ? GenotypeType.HOM_REF : GenotypeType.HOM_VAR);
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == GenotypeType.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == GenotypeType.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == GenotypeType.HET;
    }

    public boolean isNoCall() {
        return this.getType() == GenotypeType.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != GenotypeType.NO_CALL && this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean isMixed() {
        return this.getType() == GenotypeType.MIXED;
    }

    public boolean isAvailable() {
        return this.getType() != GenotypeType.UNAVAILABLE;
    }

    @Ensures(value={"(result && getLikelihoods() != null) || (! result && getLikelihoods() == null)"})
    public boolean hasLikelihoods() {
        return this.getPL() != null;
    }

    @Ensures(value={"result != null"})
    public String getLikelihoodsString() {
        return this.hasLikelihoods() ? this.getLikelihoods().toString() : ".";
    }

    @Ensures(value={"(hasLikelihoods() && result != null) || (! hasLikelihoods() && result == null)"})
    public GenotypeLikelihoods getLikelihoods() {
        return this.hasLikelihoods() ? GenotypeLikelihoods.fromPLs(this.getPL()) : null;
    }

    public abstract int[] getPL();

    @Ensures(value={"result != null || ! isAvailable()"})
    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    @Ensures(value={"result != null || ! isAvailable()"})
    public String getGenotypeString(boolean ignoreRefState) {
        if (this.getPloidy() == 0) {
            return "NA";
        }
        return ParsingUtils.join(this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR, ignoreRefState ? this.getAlleleStrings() : (this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles())));
    }

    protected List<String> getAlleleStrings() {
        ArrayList<String> al = new ArrayList<String>(this.getPloidy());
        for (Allele a : this.getAlleles()) {
            al.add(a.getBaseString());
        }
        return al;
    }

    public String toString() {
        return String.format("[%s %s%s%s%s%s%s%s]", this.getSampleName(), this.getGenotypeString(false), Genotype.toStringIfExists("GQ", this.getGQ()), Genotype.toStringIfExists("DP", this.getDP()), Genotype.toStringIfExists("AD", this.getAD()), Genotype.toStringIfExists("PL", this.getPL()), Genotype.toStringIfExists("FT", this.getFilters()), Genotype.sortedString(this.getExtendedAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%d", this.getGenotypeString(false), this.getGQ());
    }

    @Override
    public int compareTo(Genotype genotype) {
        return this.getSampleName().compareTo(genotype.getSampleName());
    }

    public boolean sameGenotype(Genotype other) {
        return this.sameGenotype(other, true);
    }

    public boolean sameGenotype(Genotype other, boolean ignorePhase) {
        if (this.getPloidy() != other.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> thisAlleles = this.getAlleles();
        SequencedCollection<Allele> otherAlleles = other.getAlleles();
        if (ignorePhase) {
            thisAlleles = new TreeSet<Allele>(thisAlleles);
            otherAlleles = new TreeSet<Allele>(otherAlleles);
        }
        return thisAlleles.equals(otherAlleles);
    }

    @Ensures(value={"result != null", "! hasForbiddenKey(result)"})
    public abstract Map<String, Object> getExtendedAttributes();

    @Requires(value={"key != null", "! isForbiddenKey(key)"})
    public boolean hasExtendedAttribute(String key) {
        return this.getExtendedAttributes().containsKey(key);
    }

    @Requires(value={"key != null", "! isForbiddenKey(key)"})
    @Ensures(value={"hasExtendedAttribute(key) || result == defaultValue"})
    public Object getExtendedAttribute(String key, Object defaultValue) {
        return this.hasExtendedAttribute(key) ? this.getExtendedAttributes().get(key) : defaultValue;
    }

    public Object getExtendedAttribute(String key) {
        return this.getExtendedAttribute(key, null);
    }

    public final String getFilters() {
        return this.filters;
    }

    @Ensures(value={"result != (getFilters() == null)"})
    public final boolean isFiltered() {
        return this.getFilters() != null;
    }

    @Deprecated
    public boolean hasLog10PError() {
        return this.hasGQ();
    }

    @Deprecated
    public double getLog10PError() {
        return (double)this.getGQ() / -10.0;
    }

    @Deprecated
    public int getPhredScaledQual() {
        return this.getGQ();
    }

    @Deprecated
    public String getAttributeAsString(String key, String defaultValue) {
        Object x = this.getExtendedAttribute(key);
        if (x == null) {
            return defaultValue;
        }
        if (x instanceof String) {
            return (String)x;
        }
        return String.valueOf(x);
    }

    @Deprecated
    public int getAttributeAsInt(String key, int defaultValue) {
        Object x = this.getExtendedAttribute(key);
        if (x == null || x == ".") {
            return defaultValue;
        }
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return Integer.valueOf((String)x);
    }

    @Deprecated
    public double getAttributeAsDouble(String key, double defaultValue) {
        Object x = this.getExtendedAttribute(key);
        if (x == null) {
            return defaultValue;
        }
        if (x instanceof Double) {
            return (Double)x;
        }
        return Double.valueOf((String)x);
    }

    public Object getAnyAttribute(String key) {
        if (key.equals("GT")) {
            return this.getAlleles();
        }
        if (key.equals("GQ")) {
            return this.getGQ();
        }
        if (key.equals("AD")) {
            return Arrays.asList(new int[][]{this.getAD()});
        }
        if (key.equals("PL")) {
            return Arrays.asList(new int[][]{this.getPL()});
        }
        if (key.equals("DP")) {
            return this.getDP();
        }
        return this.getExtendedAttribute(key);
    }

    public boolean hasAnyAttribute(String key) {
        if (key.equals("GT")) {
            return this.isAvailable();
        }
        if (key.equals("GQ")) {
            return this.hasGQ();
        }
        if (key.equals("AD")) {
            return this.hasAD();
        }
        if (key.equals("PL")) {
            return this.hasPL();
        }
        if (key.equals("DP")) {
            return this.hasDP();
        }
        return this.hasExtendedAttribute(key);
    }

    @Requires(value={"c != null"})
    protected static <T extends Comparable<T>, V> String sortedString(Map<T, V> c) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k : t) {
            pairs.add(k + "=" + c.get(k));
        }
        return pairs.isEmpty() ? "" : " {" + ParsingUtils.join(", ", pairs.toArray(new String[pairs.size()])) + "}";
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null"})
    protected static final String toStringIfExists(String name, int v) {
        return v == -1 ? "" : " " + name + " " + v;
    }

    protected static final String toStringIfExists(String name, String v) {
        return v == null ? "" : " " + name + " " + v;
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null"})
    protected static final String toStringIfExists(String name, int[] vs) {
        if (vs == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(" ").append(name).append(" ");
        for (int i = 0; i < vs.length; ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(vs[i]);
        }
        return b.toString();
    }

    protected static final boolean hasForbiddenKey(Map<String, Object> attributes) {
        for (String forbidden : PRIMARY_KEYS) {
            if (!attributes.containsKey(forbidden)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isForbiddenKey(String key) {
        return PRIMARY_KEYS.contains(key);
    }
}

