/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.CompressionUtils;

public class TDFWriter {
    private static Logger log = Logger.getLogger(TDFWriter.class);
    private static int version = 4;
    static final String ROOT_GROUP = "/";
    public static final String CHROMOSOMES = "chromosomes";
    OutputStream fos = null;
    long bytesWritten = 0L;
    File file;
    Map<String, TDFGroup> groupCache = new LinkedHashMap<String, TDFGroup>();
    Map<String, TDFDataset> datasetCache = new LinkedHashMap<String, TDFDataset>();
    Map<String, IndexEntry> datasetIndex = new LinkedHashMap<String, IndexEntry>();
    Map<String, IndexEntry> groupIndex = new LinkedHashMap<String, IndexEntry>();
    long indexPositionPosition;
    boolean compressed;
    private final CompressionUtils compressionUtils;

    public TDFWriter(File f, String genomeId, TrackType trackType, String trackLine, String[] trackNames, Collection<WindowFunction> windowFunctions, boolean compressed) {
        this.file = f.getName().endsWith(".tdf") ? f : new File(f.getAbsolutePath() + ".tdf");
        this.compressed = compressed;
        try {
            this.fos = new BufferedOutputStream(new FileOutputStream(this.file));
            this.writeHeader(genomeId, trackType, trackLine, trackNames, windowFunctions);
            TDFGroup rootGroup = new TDFGroup(ROOT_GROUP);
            this.groupCache.put(rootGroup.getName(), rootGroup);
        }
        catch (IOException ex) {
            log.error("Error creating file: " + this.file.getAbsolutePath(), ex);
            throw new DataLoadException("Error creating file", this.file.getAbsolutePath());
        }
        this.compressionUtils = new CompressionUtils();
    }

    private void writeHeader(String genomeId, TrackType trackType, String trackLine, String[] trackNames, Collection<WindowFunction> windowFunctions) throws IOException {
        byte[] magicNumber = new byte[]{84, 68, 70, 52};
        BufferedByteWriter buffer = new BufferedByteWriter(24);
        buffer.put(magicNumber);
        buffer.putInt(version);
        this.indexPositionPosition = buffer.bytesWritten();
        buffer.putLong(0L);
        buffer.putInt(0);
        this.write(buffer.getBytes());
        buffer = new BufferedByteWriter(24);
        buffer.putInt(windowFunctions.size());
        for (WindowFunction wf : windowFunctions) {
            buffer.putNullTerminatedString(wf.toString());
        }
        buffer.putNullTerminatedString(trackType.toString());
        byte[] trackLineBuffer = this.bufferString(trackLine, 1024);
        buffer.put(trackLineBuffer);
        buffer.putInt(trackNames.length);
        for (String nm : trackNames) {
            buffer.putNullTerminatedString(nm);
        }
        buffer.putNullTerminatedString(genomeId);
        int flags = 0;
        flags = this.compressed ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        buffer.putInt(flags);
        byte[] bytes = buffer.getBytes();
        this.writeInt(bytes.length);
        this.write(buffer.getBytes());
    }

    public void closeFile() {
        try {
            this.writeDatasets();
            this.writeGroups();
            long indexPosition = this.bytesWritten;
            this.writeIndex();
            int nbytes = (int)(this.bytesWritten - indexPosition);
            this.fos.close();
            this.writeIndexPosition(indexPosition, nbytes);
        }
        catch (IOException ex) {
            log.error("Error closing file");
        }
    }

    private void writeIndexPosition(long indexPosition, int nbytes) {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
            raf.getChannel().position(this.indexPositionPosition);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(indexPosition);
            buffer.putInt(nbytes);
            raf.write(buffer.getBytes());
            raf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public TDFGroup getGroup(String name) {
        return this.groupCache.get(name);
    }

    public TDFGroup getRootGroup() {
        if (!this.groupCache.containsKey(ROOT_GROUP)) {
            this.groupCache.put(ROOT_GROUP, new TDFGroup(ROOT_GROUP));
        }
        return this.groupCache.get(ROOT_GROUP);
    }

    public TDFGroup createGroup(String name) {
        if (this.groupCache.containsKey(name)) {
            throw new RuntimeException("Group: " + name + " already exists");
        }
        TDFGroup group = new TDFGroup(name);
        this.groupCache.put(name, group);
        return group;
    }

    public TDFDataset createDataset(String name, TDFDataset.DataType dataType, int tileWidth, int nTiles) {
        if (this.datasetCache.containsKey(name)) {
            throw new RuntimeException("Dataset: " + name + " already exists");
        }
        TDFDataset ds = new TDFDataset(name, dataType, tileWidth, nTiles);
        this.datasetCache.put(name, ds);
        return ds;
    }

    public void writeTile(String dsId, int tileNumber, TDFTile tile) throws IOException {
        TDFDataset dataset = this.datasetCache.get(dsId);
        if (dataset == null) {
            throw new NoSuchFieldError("Dataset: " + dsId + " doese not exist.  " + "Call createDataset first");
        }
        long pos = this.bytesWritten;
        if (tileNumber < dataset.tilePositions.length) {
            int nBytes;
            dataset.tilePositions[tileNumber] = pos;
            BufferedByteWriter buffer = new BufferedByteWriter();
            tile.writeTo(buffer);
            byte[] bytes = buffer.getBytes();
            if (this.compressed) {
                bytes = this.compressionUtils.compress(bytes);
            }
            this.write(bytes);
            dataset.tileSizes[tileNumber] = nBytes = bytes.length;
        } else if (tileNumber > dataset.tilePositions.length) {
            System.out.println("Unexpected tile number: " + tileNumber + " (max of " + dataset.tilePositions.length + " expected).");
        }
    }

    private void writeGroups() throws IOException {
        for (TDFGroup group : this.groupCache.values()) {
            long position = this.bytesWritten;
            BufferedByteWriter buffer = new BufferedByteWriter();
            group.write(buffer);
            this.write(buffer.getBytes());
            int nBytes = (int)(this.bytesWritten - position);
            this.groupIndex.put(group.getName(), new IndexEntry(position, nBytes));
        }
    }

    private void writeDatasets() throws IOException {
        for (TDFDataset dataset : this.datasetCache.values()) {
            long position = this.bytesWritten;
            BufferedByteWriter buffer = new BufferedByteWriter();
            dataset.write(buffer);
            this.write(buffer.getBytes());
            int nBytes = (int)(this.bytesWritten - position);
            this.datasetIndex.put(dataset.getName(), new IndexEntry(position, nBytes));
        }
    }

    private void writeIndex() throws IOException {
        BufferedByteWriter buffer = new BufferedByteWriter();
        buffer.putInt(this.datasetIndex.size());
        for (Map.Entry<String, IndexEntry> entry : this.datasetIndex.entrySet()) {
            buffer.putNullTerminatedString(entry.getKey());
            buffer.putLong(entry.getValue().position);
            buffer.putInt(entry.getValue().nBytes);
        }
        System.out.println("Group idx: " + this.groupIndex.size());
        buffer.putInt(this.groupIndex.size());
        for (Map.Entry<String, IndexEntry> entry : this.groupIndex.entrySet()) {
            buffer.putNullTerminatedString(entry.getKey());
            buffer.putLong(entry.getValue().position);
            buffer.putInt(entry.getValue().nBytes);
        }
        byte[] bytes = buffer.getBytes();
        this.write(bytes);
    }

    private byte[] bufferString(String str, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        Arrays.fill(buffer, (byte)32);
        buffer[bufferSize - 1] = 0;
        if (str != null) {
            int len = Math.min(bufferSize, str.length());
            System.arraycopy(str.getBytes(), 0, buffer, 0, len);
        }
        return buffer;
    }

    private void writeInt(int v) throws IOException {
        this.fos.write(v >>> 0 & 0xFF);
        this.fos.write(v >>> 8 & 0xFF);
        this.fos.write(v >>> 16 & 0xFF);
        this.fos.write(v >>> 24 & 0xFF);
        this.bytesWritten += 4L;
    }

    private void write(byte[] bytes) throws IOException {
        this.fos.write(bytes);
        this.bytesWritten += (long)bytes.length;
    }

    class IndexEntry {
        long position;
        int nBytes;

        public IndexEntry(long position, int nBytes) {
            this.position = position;
            this.nBytes = nBytes;
        }
    }
}

