/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.ChromosomeImpl;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.ChromosomeComparator;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.util.MessageUtils;

public class GenomeImpl
implements Genome {
    private static Logger log = Logger.getLogger(GenomeImpl.class);
    public static final int MAX_WHOLE_GENOME = 10000;
    private String id;
    private String displayName;
    private List<String> chromosomeNames;
    private ArrayList longChromosomeNames;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private long totalLength = -1L;
    private long nominalLength = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    private Map<String, String> chrAliasTable;
    private Sequence sequence;
    private FeatureTrack geneTrack;

    public GenomeImpl(String id, String displayName, Sequence sequence) {
        this(id, displayName, sequence, false);
    }

    public GenomeImpl(String id, String displayName, Sequence sequence, boolean chromosOrdered) {
        this.id = id;
        this.displayName = displayName;
        this.chrAliasTable = new HashMap<String, String>();
        this.sequence = sequence;
        this.chromosomeNames = sequence.getChromosomeNames();
        ArrayList<Chromosome> tmpChromos = new ArrayList<Chromosome>(this.chromosomeNames.size());
        int maxLength = -1;
        this.chromosomeMap = new LinkedHashMap(tmpChromos.size());
        for (int i = 0; i < this.chromosomeNames.size(); ++i) {
            String chr = this.chromosomeNames.get(i);
            int length = sequence.getChromosomeLength(chr);
            maxLength = Math.max(maxLength, length);
            ChromosomeImpl chromo = new ChromosomeImpl(i, chr, length);
            tmpChromos.add(chromo);
            if (!chromosOrdered) continue;
            this.chromosomeMap.put(chr, chromo);
        }
        if (!chromosOrdered) {
            ChromosomeComparator.sortChromosomeList(tmpChromos, maxLength / 10, this.chromosomeMap);
            this.chromosomeNames = new ArrayList<String>(this.chromosomeMap.keySet());
        }
        this.initializeChromosomeAliases();
    }

    @Override
    public String getChromosomeAlias(String str) {
        if (str == null) {
            return str;
        }
        if (!this.chrAliasTable.containsKey(str)) {
            this.chrAliasTable.put(str, str);
        }
        return this.chrAliasTable.get(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserDefinedAliases() {
        File aliasFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.id + "_alias.tab");
        if (aliasFile.exists()) {
            if (this.chrAliasTable == null) {
                this.chrAliasTable = new HashMap<String, String>();
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                this.addChrAliases(GenomeManager.loadChrAliases(br));
            }
            catch (IOException e) {
                log.error("Error loading chr alias table", e);
                if (!Globals.isHeadless()) {
                    MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e.toString());
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void addChrAliases(Collection<Collection<String>> synonymsList) {
        HashSet<String> chrNameSet = new HashSet<String>(this.chromosomeNames);
        for (Collection<String> synonyms : synonymsList) {
            String chr = null;
            for (String syn : synonyms) {
                if (!chrNameSet.contains(syn)) continue;
                chr = syn;
                break;
            }
            if (chr == null) continue;
            for (String syn : synonyms) {
                this.chrAliasTable.put(syn, chr);
            }
        }
    }

    void initializeChromosomeAliases() {
        for (String name : this.chromosomeNames) {
            if (!name.startsWith("gi|")) continue;
            String string = GenomeImpl.getNCBIName(name);
            this.chrAliasTable.put(string, name);
        }
        if (this.chromosomeNames.size() < 10000) {
            for (String name : this.chromosomeNames) {
                if (name.toLowerCase().startsWith("chr")) {
                    this.chrAliasTable.put(name.substring(3), name);
                    continue;
                }
                this.chrAliasTable.put("chr" + name, name);
            }
            if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
                this.chrAliasTable.put("23", "chrX");
                this.chrAliasTable.put("24", "chrY");
                this.chrAliasTable.put("MT", "chrM");
            } else if (this.id.startsWith("mm")) {
                this.chrAliasTable.put("21", "chrX");
                this.chrAliasTable.put("22", "chrY");
                this.chrAliasTable.put("MT", "chrM");
            } else if (this.id.equals("b37")) {
                this.chrAliasTable.put("chrM", "MT");
                this.chrAliasTable.put("chrX", "23");
                this.chrAliasTable.put("chrY", "24");
            }
            ArrayList<Map.Entry<String, String>> aliasEntries = new ArrayList<Map.Entry<String, String>>(this.chrAliasTable.entrySet());
            for (Map.Entry entry : aliasEntries) {
                String illuminaName;
                String alias = (String)entry.getKey();
                String chr = (String)entry.getValue();
                if (!alias.endsWith(".fa")) {
                    illuminaName = alias + ".fa";
                    this.chrAliasTable.put(illuminaName, chr);
                }
                if (chr.endsWith(".fa")) continue;
                illuminaName = chr + ".fa";
                this.chrAliasTable.put(illuminaName, chr);
            }
        }
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    @Override
    public String getHomeChromosome() {
        if (this.getLongChromosomeNames().size() == 1 || this.chromosomeNames.size() > 10000) {
            return this.getLongChromosomeNames().get(0);
        }
        return "All";
    }

    @Override
    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(this.getChromosomeAlias(chrName));
    }

    @Override
    public List<String> getAllChromosomeNames() {
        return this.chromosomeNames;
    }

    @Override
    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    @Override
    public long getTotalLength() {
        if (this.totalLength < 0L) {
            this.totalLength = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.totalLength += (long)chr.getLength();
            }
        }
        return this.totalLength;
    }

    @Override
    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getLongChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    @Override
    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    @Override
    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        List<String> wgChrNames = this.getLongChromosomeNames();
        for (String c : wgChrNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = wgChrNames.get(wgChrNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNextChrName(String chr) {
        List<String> chrList = this.getLongChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    @Override
    public String getPrevChrName(String chr) {
        List<String> chrList = this.getLongChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    @Override
    public byte[] getSequence(String chr, int start, int end) {
        if (this.sequence == null) {
            return null;
        }
        Chromosome c = this.getChromosome(chr);
        if (c == null) {
            return null;
        }
        if ((end = Math.min(end, c.getLength())) <= start) {
            return null;
        }
        return this.sequence.getSequence(chr, start, end);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public byte getReference(String chr, int pos) {
        return this.sequence.getBase(chr, pos);
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> chrCytoMap) {
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            List<Cytoband> cytobands = entry.getValue();
            Chromosome chromosome = this.chromosomeMap.get(chr);
            if (chromosome == null) continue;
            ((ChromosomeImpl)chromosome).setCytobands(cytobands);
        }
    }

    public void setGeneTrack(FeatureTrack geneFeatureTrack) {
        this.geneTrack = geneFeatureTrack;
    }

    @Override
    public FeatureTrack getGeneTrack() {
        return this.geneTrack;
    }

    @Override
    public List<String> getLongChromosomeNames() {
        if (this.longChromosomeNames == null) {
            this.longChromosomeNames = new ArrayList(this.getAllChromosomeNames().size());
            long genomeLength = this.getTotalLength();
            for (String chrName : this.getAllChromosomeNames()) {
                Chromosome chr = this.getChromosome(chrName);
                if ((long)chr.getLength() <= genomeLength / 1000L) continue;
                this.longChromosomeNames.add(chrName);
            }
        }
        return this.longChromosomeNames;
    }

    @Override
    public long getNominalLength() {
        if (this.nominalLength < 0L) {
            this.nominalLength = 0L;
            for (String chrName : this.getLongChromosomeNames()) {
                Chromosome chr = this.getChromosome(chrName);
                this.nominalLength += (long)chr.getLength();
            }
        }
        return this.nominalLength;
    }
}

