/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.PluginFeatureSource;
import org.broad.igv.dev.plugin.PluginSpecReader;
import org.broad.igv.dev.plugin.ui.ArgumentPanel;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.w3c.dom.Element;

public class RunPlugin
extends JDialog {
    private List<Argument> argumentList;
    private List<String> cmd = new ArrayList<String>();
    private Map<Argument, ArgumentPanel> argumentComponents;
    private Map<String, String> parsingAttrs;
    private String specPath;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JLabel label1;
    private JTextField outputName;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public RunPlugin(Frame owner, PluginSpecReader pluginSpecReader, Element tool, Element command) {
        super(owner);
        this.initComponents();
        String toolPath = pluginSpecReader.getToolPath(tool);
        String toolName = tool.getAttribute("name");
        String cmdName = command.getAttribute("name");
        String cmdVal = command.getAttribute("cmd");
        this.specPath = pluginSpecReader.getSpecPath();
        this.argumentList = pluginSpecReader.getArguments(tool, command);
        this.parsingAttrs = pluginSpecReader.getParsingAttributes(tool, command);
        this.initArgumentComponents(toolName, toolPath, cmdName, cmdVal);
    }

    private void initArgumentComponents(String toolName, String toolPath, String cmdName, String cmdVal) {
        if (toolPath.length() > 0) {
            this.cmd.add(toolPath);
        }
        if (cmdVal != null && cmdVal.trim().length() > 0) {
            this.cmd.add(cmdVal);
        }
        this.argumentComponents = new LinkedHashMap<Argument, ArgumentPanel>(this.argumentList.size());
        String titleText = toolName;
        if (cmdName.length() > 0) {
            titleText = titleText + ": " + cmdName;
        }
        this.setTitle(titleText);
        Dimension minSize = this.getMinimumSize();
        for (Argument argument : this.argumentList) {
            ArgumentPanel panel = ArgumentPanel.create(argument);
            if (panel == null) continue;
            this.contentPanel.add(panel);
            this.argumentComponents.put(argument, panel);
        }
        this.validate();
        double minWidth = minSize.getWidth();
        for (ArgumentPanel panel : this.argumentComponents.values()) {
            minWidth = Math.max(minWidth, panel.getMinimumSize().getWidth());
            minSize.setSize(minWidth, minSize.getHeight() + (double)panel.getHeight());
            this.setMinimumSize(minSize);
        }
        this.validate();
        this.outputName.setText(toolName + " " + cmdName);
    }

    private Track genNewTrack() {
        LinkedHashMap<Argument, Object> argumentValues = new LinkedHashMap<Argument, Object>(this.argumentComponents.size());
        for (Map.Entry<Argument, ArgumentPanel> argComp : this.argumentComponents.entrySet()) {
            Object value = argComp.getValue().getValue();
            argumentValues.put(argComp.getKey(), value);
        }
        String name = this.outputName.getText();
        PluginFeatureSource source = new PluginFeatureSource(this.cmd, argumentValues, this.parsingAttrs, this.specPath);
        FeatureTrack newTrack = new FeatureTrack(name, name, (FeatureSource)source);
        return newTrack;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void okButtonActionPerformed(ActionEvent e) {
        Track newTrack = this.genNewTrack();
        IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
        this.setVisible(false);
        IGV.getInstance().repaint();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.outputName = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(300, 100));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setMaximumSize(new Dimension(2000000, 16));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.dialogPane.add((Component)this.contentPanel, "North");
        this.panel1.setMaximumSize(new Dimension(2000, 28));
        this.panel1.setMinimumSize(new Dimension(200, 28));
        this.panel1.setPreferredSize(new Dimension(200, 28));
        this.panel1.setLayout(new BoxLayout(this.panel1, 0));
        this.label1.setText("Output Track Name:");
        this.panel1.add(this.label1);
        this.outputName.setText("result");
        this.outputName.setMaximumSize(new Dimension(500, 28));
        this.panel1.add(this.outputName);
        this.dialogPane.add((Component)this.panel1, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunPlugin.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunPlugin.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

