/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.data.BasicScore;
import org.broad.igv.dev.affective.AffectiveGenome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;

public class AffectiveDataSource
extends TDFDataSource {
    static Pattern colonPattern = Pattern.compile(":");
    Map<String, Integer> startTimeMap = new HashMap<String, Integer>();
    Map<String, Integer> samplingRateMap = new HashMap<String, Integer>();
    AffectiveGenome affectiveGenome;
    List<LocusScore> wholeGenomeScores = null;

    public AffectiveDataSource(TDFReader reader, int trackNumber, String trackName, Genome genome) {
        super(reader, trackNumber, trackName, genome);
        this.affectiveGenome = (AffectiveGenome)genome;
        if (genome instanceof AffectiveGenome) {
            for (String chrName : reader.getChromosomeNames()) {
                if (chrName.equals("All")) continue;
                ((AffectiveGenome)genome).createChromosome(chrName);
            }
        }
        TDFGroup rootGroup = reader.getGroup("/");
        String prefix = "ATTR:";
        for (String attrKey : rootGroup.getAttributeNames()) {
            String value;
            String chr;
            String[] tokens;
            if (attrKey.startsWith(prefix) && attrKey.endsWith("startTime")) {
                tokens = colonPattern.split(attrKey);
                if (tokens.length != 3) continue;
                chr = tokens[1];
                value = rootGroup.getAttribute(attrKey);
                Integer startTime = new Integer(value);
                this.startTimeMap.put(chr, startTime);
                continue;
            }
            if (!attrKey.startsWith(prefix) || !attrKey.endsWith("samplingRate") || (tokens = colonPattern.split(attrKey)).length != 3) continue;
            chr = tokens[1];
            value = rootGroup.getAttribute(attrKey);
            Integer samplingRate = new Integer(value);
            this.samplingRateMap.put(chr, samplingRate);
        }
    }

    @Override
    protected List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        if (chr.equals("All")) {
            return this.getWholeGenomeScores();
        }
        return super.getSummaryScores(chr, startLocation, endLocation, zoom);
    }

    @Override
    public List<LocusScore> getWholeGenomeScores() {
        if (this.wholeGenomeScores == null && this.affectiveGenome.getLongChromosomeNames().size() > 1) {
            this.wholeGenomeScores = new ArrayList<LocusScore>(1000);
            for (String chr : this.affectiveGenome.getLongChromosomeNames()) {
                this.wholeGenomeScores.addAll(this.getWholeGenomeScoresForChromosome(chr));
            }
        }
        return this.wholeGenomeScores;
    }

    List<LocusScore> getWholeGenomeScoresForChromosome(String chr) {
        long offset = this.affectiveGenome.getCumulativeOffset(chr);
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
        List<LocusScore> tmp = this.getSummaryScores(chr, 0, Integer.MAX_VALUE, 0);
        if (tmp != null) {
            float value = 0.0f;
            int lastWGStart = (int)(((long)tmp.get(0).getStart() + offset) / 1000L);
            int lastWGEnd = (int)(((long)tmp.get(0).getEnd() + offset) / 1000L);
            int numPoints = 0;
            for (LocusScore s : tmp) {
                int wgStart = (int)(((long)s.getStart() + offset) / 1000L);
                int wgEnd = (int)(((long)s.getEnd() + offset) / 1000L);
                if (Float.isNaN(s.getScore())) {
                    // empty if block
                }
                if (wgEnd > lastWGEnd) {
                    scores.add(new BasicScore(lastWGStart, lastWGEnd, value / (float)numPoints));
                    lastWGStart = wgStart;
                    lastWGEnd = wgEnd;
                    value = 0.0f;
                    numPoints = 0;
                }
                value += s.getScore();
                ++numPoints;
            }
        }
        return scores;
    }
}

