/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMTextWriter;
import org.apache.commons.lang.StringUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SamAlignment;

public class SAMWriter {
    private static final String SAM_FIELD_SEPARATOR = "\t";
    private SAMFileHeader header;

    public SAMWriter(SAMFileHeader header) {
        this.header = header;
    }

    public void writeToFile(File outFile, Iterable<SamAlignment> alignments) {
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, true, outFile);
        this.writeAlignments(writer, alignments);
    }

    public void writeToStream(OutputStream stream, Iterable<SamAlignment> alignments, boolean bam) {
        SAMFileWriterImpl writer = bam ? new BAMFileWriter(stream, null) : new SAMTextWriter(stream);
        writer.setHeader(this.header);
        this.writeAlignments(writer, alignments);
    }

    private void writeAlignments(SAMFileWriter writer, Iterable<SamAlignment> alignments) {
        for (SamAlignment alignment : alignments) {
            writer.addAlignment(alignment.getRecord());
        }
        writer.close();
    }

    private static int getFlags(Alignment alignment) {
        int result = alignment.isPaired() ? 1 : 0;
        ReadMate mate = alignment.getMate();
        if (mate != null) {
            result += !mate.isMapped() ? 8 : 0;
            result += mate.isNegativeStrand() ? 32 : 0;
        }
        result += alignment.isProperPair() ? 2 : 0;
        result += !alignment.isMapped() ? 4 : 0;
        result += alignment.isNegativeStrand() ? 16 : 0;
        result += alignment.isFirstOfPair() ? 64 : 0;
        result += alignment.isSecondOfPair() ? 128 : 0;
        result += alignment.isVendorFailedRead() ? 512 : 0;
        return result += alignment.isDuplicate() ? 1024 : 0;
    }

    public static String getSAMString(Alignment alignment) {
        String mateRefName;
        String refName = alignment.getChr();
        ArrayList<String> tokens = new ArrayList<String>(11);
        tokens.add(alignment.getReadName());
        tokens.add(Integer.toString(SAMWriter.getFlags(alignment)));
        tokens.add(refName);
        tokens.add(Integer.toString(alignment.getAlignmentStart()));
        tokens.add(Integer.toString(alignment.getMappingQuality()));
        tokens.add(alignment.getCigarString());
        ReadMate mate = alignment.getMate();
        String string = mateRefName = mate != null ? mate.getChr() : null;
        if (refName.equals(mateRefName) && !"*".equals(mateRefName)) {
            tokens.add("=");
        } else {
            tokens.add(mateRefName);
        }
        int mateStart = mate != null ? mate.getStart() : 0;
        tokens.add(Integer.toString(mateStart));
        tokens.add(Integer.toString(alignment.getInferredInsertSize()));
        tokens.add(alignment.getReadSequence());
        tokens.add("*");
        String out = StringUtils.join(tokens, SAM_FIELD_SEPARATOR) + "\n";
        return out;
    }

    public static class SamAlignmentIterable
    implements Iterable<SamAlignment>,
    Iterator<SamAlignment> {
        private Iterator<Alignment> alignments;
        private SamAlignment nextAlignment;

        public SamAlignmentIterable(Iterable<Alignment> alignments) {
            this.alignments = alignments.iterator();
            this.advance();
        }

        private void advance() {
            this.nextAlignment = null;
            while (this.alignments.hasNext() && this.nextAlignment == null) {
                Alignment next = this.alignments.next();
                if (!(next instanceof SamAlignment)) continue;
                this.nextAlignment = (SamAlignment)next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public SamAlignment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more SamAlignments");
            }
            SamAlignment next = this.nextAlignment;
            this.advance();
            return next;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }
    }
}

