/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bigwig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.Globals;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BBZoomLevelHeader;
import org.broad.igv.bbfile.BBZoomLevels;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;
import org.broad.igv.bbfile.ZoomDataRecord;
import org.broad.igv.bbfile.ZoomLevelIterator;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;
import org.broad.tribble.Feature;

public class BigWigDataSource
extends AbstractDataSource
implements FeatureSource {
    final int screenWidth = 1000;
    Collection<WindowFunction> availableWindowFunctions = Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max);
    WindowFunction windowFunction = WindowFunction.mean;
    BBFileReader reader;
    private BBZoomLevels levels;
    private int featureVisiblityWindow = -1;
    private List<LocusScore> wholeGenomeScores;
    private Map<String, String> chrNameMap = new HashMap<String, String>();
    private RawDataInterval currentInterval = null;
    private double dataMin = 0.0;
    private double dataMax = 100.0;

    public BigWigDataSource(BBFileReader reader, Genome genome) throws IOException {
        super(genome);
        this.reader = reader;
        this.levels = reader.getZoomLevels();
        this.initMinMax();
        if (this.levels.getZoomHeaderCount() > 0) {
            BBZoomLevelHeader firstLevel = this.levels.getZoomLevelHeaders().get(0);
            this.featureVisiblityWindow = firstLevel.getReductionLevel() * 2000;
        }
        if (genome != null) {
            ArrayList<String> chrNames = reader.getChromosomeNames();
            for (String chr : chrNames) {
                String igvChr = genome.getChromosomeAlias(chr);
                if (igvChr == null || igvChr.equals(chr)) continue;
                this.chrNameMap.put(igvChr, chr);
            }
        }
    }

    private void initMinMax() {
        int oneMB = 1000000;
        int z = this.getZoomLevelForScale(1000000.0).getZoomLevel();
        ZoomLevelIterator zlIter = this.reader.getZoomLevelIterator(z);
        int n = 0;
        double[] values = new double[10000];
        if (zlIter.hasNext()) {
            while (zlIter.hasNext()) {
                ZoomDataRecord rec = zlIter.next();
                values[n] = rec.getMeanVal();
                if (++n < 10000) continue;
                break;
            }
            this.dataMin = StatUtils.percentile(values, 0, n, 10.0);
            this.dataMax = Math.min(100.0, StatUtils.percentile(values, 0, n, 90.0));
        } else {
            this.dataMin = 0.0;
            this.dataMax = 100.0;
        }
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.OTHER;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.wholeGenomeScores = null;
        this.windowFunction = statType;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public void refreshData(long timestamp) {
    }

    @Override
    public int getLongestFeature(String chr) {
        return 0;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableWindowFunctions;
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int start, int end, int zoom) {
        if (chr.equals("All")) {
            return this.getWholeGenomeScores();
        }
        return this.getZoomSummaryScores(chr, start, end, zoom);
    }

    private BBZoomLevelHeader getZoomLevelForScale(double resolution) {
        ArrayList<BBZoomLevelHeader> headers = this.levels.getZoomLevelHeaders();
        BBZoomLevelHeader lastLevel = null;
        for (BBZoomLevelHeader zlHeader : headers) {
            int reductionLevel = zlHeader.getReductionLevel();
            if ((double)reductionLevel > resolution) {
                return lastLevel == null ? zlHeader : lastLevel;
            }
            lastLevel = zlHeader;
        }
        return headers.get(headers.size() - 1);
    }

    private BBZoomLevelHeader getLowestResolutionLevel() {
        ArrayList<BBZoomLevelHeader> headers = this.levels.getZoomLevelHeaders();
        return headers.get(headers.size() - 1);
    }

    protected List<LocusScore> getZoomSummaryScores(String chr, int start, int end, int zoom) {
        String querySeq;
        Chromosome c = this.genome.getChromosome(chr);
        if (c == null) {
            return null;
        }
        double nBins = Math.pow(2.0, zoom);
        double scale = (double)c.getLength() / (nBins * 700.0);
        BBZoomLevelHeader zlHeader = this.getZoomLevelForScale(scale);
        int bbLevel = zlHeader.getZoomLevel();
        int reductionLevel = zlHeader.getReductionLevel();
        String tmp = this.chrNameMap.get(chr);
        String string = querySeq = tmp == null ? chr : tmp;
        if (this.reader.isBigBedFile() || bbLevel > 1 || bbLevel == 1 && (double)reductionLevel / scale < 2.0) {
            ArrayList<LocusScore> scores = new ArrayList<LocusScore>(1000);
            ZoomLevelIterator zlIter = this.reader.getZoomLevelIterator(bbLevel, querySeq, start, querySeq, end, false);
            while (zlIter.hasNext()) {
                ZoomDataRecord rec = zlIter.next();
                float v = this.getValue(rec);
                BasicScore bs = new BasicScore(rec.getChromStart(), rec.getChromEnd(), v);
                scores.add(bs);
            }
            return scores;
        }
        return null;
    }

    private float getValue(ZoomDataRecord rec) {
        float v;
        switch (this.windowFunction) {
            case min: {
                v = rec.getMinVal();
                break;
            }
            case max: {
                v = rec.getMaxVal();
                break;
            }
            default: {
                v = rec.getMeanVal();
            }
        }
        return v;
    }

    @Override
    protected synchronized DataTile getRawData(String chr, int start, int end) {
        if (chr.equals("All")) {
            return null;
        }
        if (this.currentInterval != null && this.currentInterval.contains(chr, start, end)) {
            return this.currentInterval.tile;
        }
        IntArrayList startsList = new IntArrayList(100000);
        IntArrayList endsList = new IntArrayList(100000);
        FloatArrayList valuesList = new FloatArrayList(100000);
        String chrAlias = this.chrNameMap.containsKey(chr) ? this.chrNameMap.get(chr) : chr;
        BigWigIterator iter = this.reader.getBigWigIterator(chrAlias, start, chrAlias, end, false);
        while (iter.hasNext()) {
            WigItem wi = (WigItem)iter.next();
            startsList.add(wi.getStartBase());
            endsList.add(wi.getEndBase());
            valuesList.add(wi.getWigValue());
        }
        DataTile tile = new DataTile(startsList.toArray(), endsList.toArray(), valuesList.toArray(), null);
        this.currentInterval = new RawDataInterval(chr, start, end, tile);
        return tile;
    }

    private List<LocusScore> getWholeGenomeScores() {
        if (this.genome.getHomeChromosome().equals("All")) {
            if (this.wholeGenomeScores == null) {
                double scale = this.genome.getNominalLength() / 1000L;
                this.wholeGenomeScores = new ArrayList<LocusScore>();
                for (String chrName : this.genome.getLongChromosomeNames()) {
                    Chromosome chr = this.genome.getChromosome(chrName);
                    BBZoomLevelHeader lowestResHeader = this.getZoomLevelForScale(scale);
                    int lastGenomeEnd = -1;
                    int end = chr.getLength();
                    String tmp = this.chrNameMap.get(chrName);
                    String querySeq = tmp == null ? chrName : tmp;
                    ZoomLevelIterator zlIter = this.reader.getZoomLevelIterator(lowestResHeader.getZoomLevel(), querySeq, 0, querySeq, end, false);
                    while (zlIter.hasNext()) {
                        ZoomDataRecord rec = zlIter.next();
                        float value = this.getValue(rec);
                        int genomeStart = this.genome.getGenomeCoordinate(chrName, rec.getChromStart());
                        if (genomeStart < lastGenomeEnd) continue;
                        int genomeEnd = this.genome.getGenomeCoordinate(chrName, rec.getChromEnd());
                        this.wholeGenomeScores.add(new BasicScore(genomeStart, genomeEnd, value));
                        lastGenomeEnd = genomeEnd;
                    }
                }
            }
            return this.wholeGenomeScores;
        }
        return null;
    }

    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        String tmp = this.chrNameMap.get(chr);
        String querySeq = tmp == null ? chr : tmp;
        BigBedIterator bedIterator = this.reader.getBigBedIterator(querySeq, start, chr, end, false);
        return new WrappedIterator(bedIterator);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        String tmp = this.chrNameMap.get(chr);
        String querySeq = tmp == null ? chr : tmp;
        return this.getSummaryScoresForRange(querySeq, start, end, zoom);
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureVisiblityWindow;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureVisiblityWindow = size;
    }

    public Class getFeatureClass() {
        return null;
    }

    private static void decode(BasicFeature feature, String[] restOfFields) {
        int tokenCount = restOfFields.length;
        if (tokenCount > 0) {
            String name = restOfFields[0].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        if (tokenCount > 1) {
            try {
                float score = Float.parseFloat(restOfFields[1]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (tokenCount > 2) {
            int strand;
            String strandString = restOfFields[2].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 5) {
            String colorString = restOfFields[5];
            feature.setColor(ColorUtilities.stringToColor(colorString));
        }
        if (tokenCount > 8) {
            Strand strand = feature.getStrand();
            int cdStart = Integer.parseInt(restOfFields[3]);
            int cdEnd = Integer.parseInt(restOfFields[4]);
            int exonCount = Integer.parseInt(restOfFields[6]);
            String[] exonSizes = Globals.commaPattern.split(restOfFields[7]);
            String[] startsBuffer = Globals.commaPattern.split(restOfFields[8]);
            int exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
            int start = feature.getStart();
            String chr = feature.getChr();
            if (startsBuffer.length == exonSizes.length) {
                for (int i = 0; i < startsBuffer.length; ++i) {
                    int exonStart = start + Integer.parseInt(startsBuffer[i]);
                    int exonEnd = exonStart + Integer.parseInt(exonSizes[i]);
                    Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                    exon.setCodingStart(cdStart);
                    exon.setCodingEnd(cdEnd);
                    exon.setNumber(exonNumber);
                    feature.addExon(exon);
                    if (strand == Strand.NEGATIVE) {
                        --exonNumber;
                        continue;
                    }
                    ++exonNumber;
                }
            }
        }
    }

    static class RawDataInterval {
        String chr;
        int start;
        int end;
        DataTile tile;

        RawDataInterval(String chr, int start, int end, DataTile tile) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.tile = tile;
        }

        public boolean contains(String chr, int start, int end) {
            return chr.equals(this.chr) && start >= this.start && end <= this.end;
        }
    }

    public static class WrappedIterator
    implements Iterator<Feature> {
        BigBedIterator bedIterator;

        public WrappedIterator(BigBedIterator bedIterator) {
            this.bedIterator = bedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.bedIterator.hasNext();
        }

        @Override
        public Feature next() {
            BedFeature feat = this.bedIterator.next();
            BasicFeature feature = new BasicFeature(feat.getChromosome(), feat.getStartBase(), feat.getEndBase());
            String[] restOfFields = feat.getRestOfFields();
            if (restOfFields != null && restOfFields.length > 0) {
                BigWigDataSource.decode(feature, restOfFields);
            }
            return feature;
        }

        @Override
        public void remove() {
        }
    }
}

