/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.broad.tribble.util.popgen.HardyWeinbergCalculation;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFAlleleClipper;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.CommonInfo;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeBuilder;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.JEXLMap;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class VariantContextUtils {
    private static Logger logger = Logger.getLogger(VariantContextUtils.class);
    public static final String MERGE_INTERSECTION = "Intersection";
    public static final String MERGE_FILTER_IN_ALL = "FilteredInAll";
    public static final String MERGE_REF_IN_ALL = "ReferenceInAll";
    public static final String MERGE_FILTER_PREFIX = "filterIn";
    private static final List<Allele> DIPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private static Set<String> MISSING_KEYS_WARNED_ABOUT = new HashSet<String>();
    public static final JexlEngine engine = new JexlEngine();
    public static final int DEFAULT_PLOIDY = 2;
    private static final boolean ASSUME_MISSING_FIELDS_ARE_STRINGS = false;
    private static final List<Allele> NO_CALL_ALLELES;
    public static final double SUM_GL_THRESH_NOCALL = -0.1;

    public static VariantContext addMissingSamples(VariantContext vc, Set<String> allSamples) {
        HashSet<String> missingSamples = new HashSet<String>(allSamples);
        missingSamples.removeAll(vc.getSampleNames());
        if (missingSamples.isEmpty()) {
            return vc;
        }
        GenotypesContext gc = GenotypesContext.copy(vc.getGenotypes());
        for (String missing : missingSamples) {
            gc.add(new GenotypeBuilder(missing).alleles(DIPLOID_NO_CALL).make());
        }
        return new VariantContextBuilder(vc).genotypes(gc).make();
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues) {
        return VariantContextUtils.calculateChromosomeCounts(vc, attributes, removeStaleValues, new HashSet<String>(0));
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues, Set<String> founderIds) {
        int AN = vc.getCalledChrCount();
        if (AN == 0 && removeStaleValues) {
            if (attributes.containsKey("AC")) {
                attributes.remove("AC");
            }
            if (attributes.containsKey("AF")) {
                attributes.remove("AF");
            }
            if (attributes.containsKey("AN")) {
                attributes.remove("AN");
            }
            return attributes;
        }
        if (vc.hasGenotypes()) {
            attributes.put("AN", AN);
            if (vc.getAlternateAlleles().size() > 0) {
                ArrayList<Double> alleleFreqs = new ArrayList<Double>();
                ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
                ArrayList<Integer> foundersAlleleCounts = new ArrayList<Integer>();
                double totalFoundersChromosomes = vc.getCalledChrCount(founderIds);
                for (Allele allele : vc.getAlternateAlleles()) {
                    int foundersAltChromosomes = vc.getCalledChrCount(allele, founderIds);
                    alleleCounts.add(vc.getCalledChrCount(allele));
                    foundersAlleleCounts.add(foundersAltChromosomes);
                    if (AN == 0) {
                        alleleFreqs.add(0.0);
                        continue;
                    }
                    Double freq = (double)foundersAltChromosomes / totalFoundersChromosomes;
                    alleleFreqs.add(freq);
                }
                attributes.put("AC", alleleCounts.size() == 1 ? (Serializable)alleleCounts.get(0) : alleleCounts);
                attributes.put("AF", alleleFreqs.size() == 1 ? (Serializable)alleleFreqs.get(0) : alleleFreqs);
            } else {
                attributes.remove("AC");
                attributes.remove("AF");
            }
        }
        return attributes;
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, new HashSet<String>(0)));
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues, Set<String> founderIds) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, founderIds));
    }

    public static Genotype removePLs(Genotype g) {
        if (g.hasLikelihoods()) {
            return new GenotypeBuilder(g).noPL().make();
        }
        return g;
    }

    public static final VCFCompoundHeaderLine getMetaDataForField(VCFHeader header, String field) {
        VCFCompoundHeaderLine metaData = header.getFormatHeaderLine(field);
        if (metaData == null) {
            metaData = header.getInfoHeaderLine(field);
        }
        if (metaData == null) {
            throw new UserException.MalformedVCF("Fully decoding VariantContext requires header line for all fields, but none was found for " + field);
        }
        return metaData;
    }

    public static List<JexlVCMatchExp> initializeMatchExps(String[] names, String[] exps) {
        if (names == null || exps == null) {
            throw new ReviewedStingException("BUG: neither names nor exps can be null: names " + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        if (names.length != exps.length) {
            throw new UserException("Inconsistent number of provided filter names and expressions: names=" + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], exps[i]);
        }
        return VariantContextUtils.initializeMatchExps(map);
    }

    public static List<JexlVCMatchExp> initializeMatchExps(ArrayList<String> names, ArrayList<String> exps) {
        String[] nameArray = new String[names.size()];
        String[] expArray = new String[exps.size()];
        return VariantContextUtils.initializeMatchExps(names.toArray(nameArray), exps.toArray(expArray));
    }

    public static List<JexlVCMatchExp> initializeMatchExps(Map<String, String> names_and_exps) {
        ArrayList<JexlVCMatchExp> exps = new ArrayList<JexlVCMatchExp>();
        for (Map.Entry<String, String> elt : names_and_exps.entrySet()) {
            String name = elt.getKey();
            String expStr = elt.getValue();
            if (name == null || expStr == null) {
                throw new IllegalArgumentException("Cannot create null expressions : " + name + " " + expStr);
            }
            try {
                Expression exp = engine.createExpression(expStr);
                exps.add(new JexlVCMatchExp(name, exp));
            }
            catch (Exception e) {
                throw new UserException.BadArgumentValue(name, "Invalid expression used (" + expStr + "). Please see the JEXL docs for correct syntax.");
            }
        }
        return exps;
    }

    public static boolean match(VariantContext vc, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc);
    }

    public static boolean match(VariantContext vc, Genotype g, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, g, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Genotype g, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc, g);
    }

    public static double computeHardyWeinbergPvalue(VariantContext vc) {
        if (vc.getCalledChrCount() == 0) {
            return 0.0;
        }
        return HardyWeinbergCalculation.hwCalculate((int)vc.getHomRefCount(), (int)vc.getHetCount(), (int)vc.getHomVarCount());
    }

    @Requires(value={"vc != null"})
    @Ensures(value={"result != null"})
    public static VariantContext sitesOnlyVariantContext(VariantContext vc) {
        return new VariantContextBuilder(vc).noGenotypes().make();
    }

    @Requires(value={"vcs != null"})
    @Ensures(value={"result != null"})
    public static Collection<VariantContext> sitesOnlyVariantContexts(Collection<VariantContext> vcs) {
        ArrayList<VariantContext> r = new ArrayList<VariantContext>();
        for (VariantContext vc : vcs) {
            r.add(VariantContextUtils.sitesOnlyVariantContext(vc));
        }
        return r;
    }

    private static final Map<String, Object> subsetAttributes(CommonInfo igc, Collection<String> keysToPreserve) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(keysToPreserve.size());
        for (String key : keysToPreserve) {
            if (!igc.hasAttribute(key)) continue;
            attributes.put(key, igc.getAttribute(key));
        }
        return attributes;
    }

    @Deprecated
    public static VariantContext pruneVariantContext(VariantContext vc, Collection<String> keysToPreserve) {
        return VariantContextUtils.pruneVariantContext(new VariantContextBuilder(vc), keysToPreserve).make();
    }

    public static VariantContextBuilder pruneVariantContext(VariantContextBuilder builder, Collection<String> keysToPreserve) {
        VariantContext vc = builder.make();
        if (keysToPreserve == null) {
            keysToPreserve = Collections.emptyList();
        }
        Map<String, Object> attributes = VariantContextUtils.subsetAttributes(vc.commonInfo, keysToPreserve);
        GenotypesContext genotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype g : vc.getGenotypes()) {
            GenotypeBuilder gb = new GenotypeBuilder(g);
            gb.noAD().noDP().noPL().noAttributes();
            genotypes.add(gb.make());
        }
        return builder.genotypes(genotypes).attributes(attributes);
    }

    public static VariantContext simpleMerge(GenomeLocParser genomeLocParser, Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean annotateOrigin, boolean printMessages, String setKey, boolean filteredAreUncalled, boolean mergeInfoWithMaxAC) {
        if (unsortedVCs == null || unsortedVCs.size() == 0) {
            return null;
        }
        if (annotateOrigin && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls and annotate their origins without a complete priority list of VariantContexts");
        }
        if (genotypeMergeOptions == GenotypeMergeType.REQUIRE_UNIQUE) {
            VariantContextUtils.verifyUniqueSampleNames(unsortedVCs);
        }
        List<VariantContext> prepaddedVCs = VariantContextUtils.sortVariantContextsByPriority(unsortedVCs, priorityListOfVCs, genotypeMergeOptions);
        ArrayList<VariantContext> VCs = new ArrayList<VariantContext>();
        for (VariantContext vc : prepaddedVCs) {
            if (filteredAreUncalled && !vc.isNotFiltered()) continue;
            VCs.add(VCFAlleleClipper.createVariantContextWithPaddedAlleles(vc));
        }
        if (VCs.size() == 0) {
            return null;
        }
        VariantContext first = (VariantContext)VCs.get(0);
        String name = first.getSource();
        Allele refAllele = VariantContextUtils.determineReferenceAllele(VCs);
        Byte referenceBaseForIndel = null;
        LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>();
        TreeSet<String> filters = new TreeSet<String>();
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        HashSet<String> inconsistentAttributes = new HashSet<String>();
        HashSet<String> variantSources = new HashSet<String>();
        LinkedHashSet<String> rsIDs = new LinkedHashSet<String>(1);
        GenomeLoc loc = VariantContextUtils.getLocation(genomeLocParser, first);
        int depth = 0;
        int maxAC = -1;
        TreeMap<String, Object> attributesWithMaxAC = new TreeMap<String, Object>();
        double log10PError = 1.0;
        VariantContext vcWithMaxAC = null;
        GenotypesContext genotypes = GenotypesContext.create();
        int nFiltered = 0;
        boolean remapped = false;
        for (VariantContext vc : VCs) {
            if (loc.getStart() != vc.getStart()) {
                throw new ReviewedStingException("BUG: attempting to merge VariantContexts with different start sites: first=" + first.toString() + " second=" + vc.toString());
            }
            if (VariantContextUtils.getLocation(genomeLocParser, vc).size() > loc.size()) {
                loc = VariantContextUtils.getLocation(genomeLocParser, vc);
            }
            nFiltered += vc.isFiltered() ? 1 : 0;
            if (vc.isVariant()) {
                variantSources.add(vc.getSource());
            }
            AlleleMapper alleleMapping = VariantContextUtils.resolveIncompatibleAlleles(refAllele, vc, alleles);
            remapped = remapped || alleleMapping.needsRemapping();
            alleles.addAll(alleleMapping.values());
            VariantContextUtils.mergeGenotypes(genotypes, vc, alleleMapping, genotypeMergeOptions == GenotypeMergeType.UNIQUIFY);
            log10PError = Math.min(log10PError, vc.isVariant() ? vc.getLog10PError() : 1.0);
            filters.addAll(vc.getFilters());
            if (referenceBaseForIndel == null) {
                referenceBaseForIndel = vc.getReferenceBaseForIndel();
            }
            if (vc.hasAttribute("DP")) {
                depth += vc.getAttributeAsInt("DP", 0);
            }
            if (vc.hasID()) {
                rsIDs.add(vc.getID());
            }
            if (mergeInfoWithMaxAC && vc.hasAttribute("AC")) {
                String rawAlleleCounts = vc.getAttributeAsString("AC", null);
                if (rawAlleleCounts.contains(",")) {
                    List<String> alleleCountArray = Arrays.asList(rawAlleleCounts.substring(1, rawAlleleCounts.length() - 1).split(","));
                    for (String alleleCount : alleleCountArray) {
                        int ac = Integer.valueOf(alleleCount.trim());
                        if (ac <= maxAC) continue;
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                } else {
                    int ac = Integer.valueOf(rawAlleleCounts);
                    if (ac > maxAC) {
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                }
            }
            for (Map.Entry<String, Object> p : vc.getAttributes().entrySet()) {
                boolean boundIsMissingValue;
                String key = p.getKey();
                if (inconsistentAttributes.contains(key)) continue;
                boolean alreadyFound = attributes.containsKey(key);
                Object boundValue = attributes.get(key);
                boolean bl = boundIsMissingValue = alreadyFound && boundValue.equals(".");
                if (alreadyFound && !boundValue.equals(p.getValue()) && !boundIsMissingValue) {
                    inconsistentAttributes.add(key);
                    attributes.remove(key);
                    continue;
                }
                if (alreadyFound && !boundIsMissingValue) continue;
                attributes.put(key, p.getValue());
            }
        }
        for (VariantContext vc : VCs) {
            if (vc.alleles.size() == 1 || !VariantContextUtils.hasPLIncompatibleAlleles(alleles, vc.alleles)) continue;
            if (!genotypes.isEmpty()) {
                logger.debug((Object)String.format("Stripping PLs at %s due incompatible alleles merged=%s vs. single=%s", genomeLocParser.createGenomeLoc(vc), alleles, vc.alleles));
            }
            genotypes = VariantContextUtils.stripPLs(genotypes);
            VariantContextUtils.calculateChromosomeCounts(vc, attributes, true);
            break;
        }
        if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
            attributesWithMaxAC.putAll(vcWithMaxAC.getAttributes());
        }
        if (filteredRecordMergeType == FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED && nFiltered != VCs.size() || filteredRecordMergeType == FilteredRecordMergeType.KEEP_UNCONDITIONAL) {
            filters.clear();
        }
        if (annotateOrigin) {
            String setValue;
            if (nFiltered == 0 && variantSources.size() == priorityListOfVCs.size()) {
                setValue = MERGE_INTERSECTION;
            } else if (nFiltered == VCs.size()) {
                setValue = MERGE_FILTER_IN_ALL;
            } else if (variantSources.isEmpty()) {
                setValue = MERGE_REF_IN_ALL;
            } else {
                LinkedHashSet<String> s = new LinkedHashSet<String>();
                for (VariantContext vc : VCs) {
                    if (!vc.isVariant()) continue;
                    s.add(vc.isFiltered() ? MERGE_FILTER_PREFIX + vc.getSource() : vc.getSource());
                }
                setValue = Utils.join((String)"-", s);
            }
            if (setKey != null) {
                attributes.put(setKey, setValue);
                if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
                    attributesWithMaxAC.put(setKey, setValue);
                }
            }
        }
        if (depth > 0) {
            attributes.put("DP", String.valueOf(depth));
        }
        String ID = rsIDs.isEmpty() ? "." : Utils.join((String)",", rsIDs);
        VariantContextBuilder builder = new VariantContextBuilder().source(name).id(ID);
        builder.loc(loc.getContig(), loc.getStart(), loc.getStop());
        builder.alleles(alleles);
        builder.genotypes(genotypes);
        builder.log10PError(log10PError);
        builder.filters(filters).attributes(mergeInfoWithMaxAC ? attributesWithMaxAC : attributes);
        builder.referenceBaseForIndel(referenceBaseForIndel);
        VariantContext merged = VariantContextUtils.createVariantContextWithTrimmedAlleles(builder.make());
        if (printMessages && remapped) {
            System.out.printf("Remapped => %s%n", merged);
        }
        return merged;
    }

    private static final boolean hasPLIncompatibleAlleles(Collection<Allele> alleleSet1, Collection<Allele> alleleSet2) {
        Iterator<Allele> it1 = alleleSet1.iterator();
        Iterator<Allele> it2 = alleleSet2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Allele a2;
            Allele a1 = it1.next();
            if (a1.equals(a2 = it2.next())) continue;
            return true;
        }
        return it1.hasNext() || it2.hasNext();
    }

    public static boolean allelesAreSubset(VariantContext vc1, VariantContext vc2) {
        if (!vc1.getReference().equals(vc2.getReference())) {
            return false;
        }
        for (Allele a : vc1.getAlternateAlleles()) {
            if (vc2.getAlternateAlleles().contains(a)) continue;
            return false;
        }
        return true;
    }

    private static VariantContext createVariantContextWithTrimmedAlleles(VariantContext inputVC) {
        Allele refAllele = inputVC.getReference();
        boolean trimVC = !inputVC.isVariant() ? false : (refAllele.isNull() ? false : VCFAlleleClipper.shouldClipFirstBaseP(inputVC.getAlternateAlleles(), (byte)inputVC.getReference().getDisplayString().charAt(0)));
        if (trimVC) {
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            GenotypesContext genotypes = GenotypesContext.create();
            HashMap<Allele, Allele> originalToTrimmedAlleleMap = new HashMap<Allele, Allele>();
            for (Allele a : inputVC.getAlleles()) {
                if (a.isSymbolic()) {
                    alleles.add(a);
                    originalToTrimmedAlleleMap.put(a, a);
                    continue;
                }
                byte[] newBases = Arrays.copyOfRange(a.getBases(), 1, a.length());
                Allele trimmedAllele = Allele.create(newBases, a.isReference());
                alleles.add(trimmedAllele);
                originalToTrimmedAlleleMap.put(a, trimmedAllele);
            }
            boolean hasNullAlleles = false;
            for (Allele a : originalToTrimmedAlleleMap.values()) {
                if (!a.isNull()) continue;
                hasNullAlleles = true;
            }
            if (!hasNullAlleles) {
                return inputVC;
            }
            for (Genotype genotype : inputVC.getGenotypes()) {
                List<Allele> originalAlleles = genotype.getAlleles();
                ArrayList<Allele> trimmedAlleles = new ArrayList<Allele>();
                for (Allele a : originalAlleles) {
                    if (a.isCalled()) {
                        trimmedAlleles.add((Allele)originalToTrimmedAlleleMap.get(a));
                        continue;
                    }
                    trimmedAlleles.add(Allele.NO_CALL);
                }
                genotypes.add(new GenotypeBuilder(genotype).alleles(trimmedAlleles).make());
            }
            VariantContextBuilder builder = new VariantContextBuilder(inputVC);
            return builder.alleles((Collection<Allele>)alleles).genotypes(genotypes).referenceBaseForIndel(new Byte(inputVC.getReference().getBases()[0])).make();
        }
        return inputVC;
    }

    public static GenotypesContext stripPLs(GenotypesContext genotypes) {
        GenotypesContext newGs = GenotypesContext.create(genotypes.size());
        for (Genotype g : genotypes) {
            newGs.add(g.hasLikelihoods() ? VariantContextUtils.removePLs(g) : g);
        }
        return newGs;
    }

    public static Map<VariantContext.Type, List<VariantContext>> separateVariantContextsByType(Collection<VariantContext> VCs) {
        HashMap<VariantContext.Type, List<VariantContext>> mappedVCs = new HashMap<VariantContext.Type, List<VariantContext>>();
        for (VariantContext vc : VCs) {
            boolean addtoOwnList = true;
            block1: for (VariantContext.Type type : VariantContext.Type.values()) {
                if (type.equals((Object)vc.getType()) || !mappedVCs.containsKey((Object)type)) continue;
                List<VariantContext> vcList = mappedVCs.get((Object)type);
                for (int k = 0; k < vcList.size(); ++k) {
                    VariantContext otherVC = vcList.get(k);
                    if (VariantContextUtils.allelesAreSubset(otherVC, vc)) {
                        vcList.remove(k);
                        if (vcList.size() == 0) {
                            mappedVCs.remove(vcList);
                        }
                        if (!mappedVCs.containsKey((Object)vc.getType())) {
                            mappedVCs.put(vc.getType(), new ArrayList());
                        }
                        mappedVCs.get((Object)vc.getType()).add(otherVC);
                        continue block1;
                    }
                    if (!VariantContextUtils.allelesAreSubset(vc, otherVC)) continue;
                    mappedVCs.get((Object)type).add(vc);
                    addtoOwnList = false;
                    continue block1;
                }
            }
            if (!addtoOwnList) continue;
            if (!mappedVCs.containsKey((Object)vc.getType())) {
                mappedVCs.put(vc.getType(), new ArrayList());
            }
            mappedVCs.get((Object)vc.getType()).add(vc);
        }
        return mappedVCs;
    }

    private static void verifyUniqueSampleNames(Collection<VariantContext> unsortedVCs) {
        HashSet<String> names = new HashSet<String>();
        for (VariantContext vc : unsortedVCs) {
            for (String name : vc.getSampleNames()) {
                if (!names.contains(name)) continue;
                throw new UserException("REQUIRE_UNIQUE sample names is true but duplicate names were discovered " + name);
            }
            names.addAll(vc.getSampleNames());
        }
    }

    private static Allele determineReferenceAllele(List<VariantContext> VCs) {
        Allele ref = null;
        for (VariantContext vc : VCs) {
            Allele myRef = vc.getReference();
            if (ref == null || ref.length() < myRef.length()) {
                ref = myRef;
                continue;
            }
            if (ref.length() != myRef.length() || ref.equals(myRef)) continue;
            throw new UserException.BadInput(String.format("The provided variant file(s) have inconsistent references for the same position(s) at %s:%d, %s vs. %s", vc.getChr(), vc.getStart(), ref, myRef));
        }
        return ref;
    }

    private static AlleleMapper resolveIncompatibleAlleles(Allele refAllele, VariantContext vc, Set<Allele> allAlleles) {
        if (refAllele.equals(vc.getReference())) {
            return new AlleleMapper(vc);
        }
        Allele myRef = vc.getReference();
        if (refAllele.length() <= myRef.length()) {
            throw new ReviewedStingException("BUG: myRef=" + myRef + " is longer than refAllele=" + refAllele);
        }
        byte[] extraBases = Arrays.copyOfRange(refAllele.getBases(), myRef.length(), refAllele.length());
        HashMap<Allele, Allele> map = new HashMap<Allele, Allele>();
        for (Allele a : vc.getAlleles()) {
            if (a.isReference()) {
                map.put(a, refAllele);
                continue;
            }
            Allele extended = Allele.extend(a, extraBases);
            for (Allele b : allAlleles) {
                if (!extended.equals(b)) continue;
                extended = b;
            }
            map.put(a, extended);
        }
        return new AlleleMapper(map);
    }

    public static List<VariantContext> sortVariantContextsByPriority(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, GenotypeMergeType mergeOption) {
        if (mergeOption == GenotypeMergeType.PRIORITIZE && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls by priority with a null priority list");
        }
        if (priorityListOfVCs == null || mergeOption == GenotypeMergeType.UNSORTED) {
            return new ArrayList<VariantContext>(unsortedVCs);
        }
        ArrayList<VariantContext> sorted = new ArrayList<VariantContext>(unsortedVCs);
        Collections.sort(sorted, new CompareByPriority(priorityListOfVCs));
        return sorted;
    }

    private static void mergeGenotypes(GenotypesContext mergedGenotypes, VariantContext oneVC, AlleleMapper alleleMapping, boolean uniqifySamples) {
        for (Genotype g : oneVC.getGenotypes()) {
            String name = VariantContextUtils.mergedSampleName(oneVC.getSource(), g.getSampleName(), uniqifySamples);
            if (mergedGenotypes.containsSample(name)) continue;
            Genotype newG = g;
            if (uniqifySamples || alleleMapping.needsRemapping()) {
                List<Allele> alleles = alleleMapping.needsRemapping() ? alleleMapping.remap(g.getAlleles()) : g.getAlleles();
                newG = new GenotypeBuilder(g).name(name).alleles(alleles).make();
            }
            mergedGenotypes.add(newG);
        }
    }

    public static String mergedSampleName(String trackName, String sampleName, boolean uniqify) {
        return uniqify ? sampleName + "." + trackName : sampleName;
    }

    public static VariantContext reverseComplement(VariantContext vc) {
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>(vc.getAlleles().size());
        for (Allele originalAllele : vc.getAlleles()) {
            Allele newAllele = originalAllele.isNoCall() || originalAllele.isNull() ? originalAllele : Allele.create(BaseUtils.simpleReverseComplement((byte[])originalAllele.getBases()), originalAllele.isReference());
            alleleMap.put(originalAllele, newAllele);
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele newAllele = (Allele)alleleMap.get(allele);
                if (newAllele == null) {
                    newAllele = Allele.NO_CALL;
                }
                newAlleles.add(newAllele);
            }
            newGenotypes.add(new GenotypeBuilder(genotype).alleles(newAlleles).make());
        }
        return new VariantContextBuilder(vc).alleles(alleleMap.values()).genotypes(newGenotypes).make();
    }

    public static VariantContext purgeUnallowedGenotypeAttributes(VariantContext vc, Set<String> allowedAttributes) {
        if (allowedAttributes == null) {
            return vc;
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> attr : genotype.getExtendedAttributes().entrySet()) {
                if (!allowedAttributes.contains(attr.getKey())) continue;
                attrs.put(attr.getKey(), attr.getValue());
            }
            newGenotypes.add(new GenotypeBuilder(genotype).attributes(attrs).make());
        }
        return new VariantContextBuilder(vc).genotypes(newGenotypes).make();
    }

    public static BaseUtils.BaseSubstitutionType getSNPSubstitutionType(VariantContext context) {
        if (!context.isSNP() || !context.isBiallelic()) {
            throw new IllegalStateException("Requested SNP substitution type for bialleic non-SNP " + context);
        }
        return BaseUtils.SNPSubstitutionType((byte)context.getReference().getBases()[0], (byte)context.getAlternateAllele(0).getBases()[0]);
    }

    public static boolean isTransition(VariantContext context) {
        return VariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static boolean isTransversion(VariantContext context) {
        return VariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSVERSION;
    }

    public static boolean isTransition(Allele ref, Allele alt) {
        return BaseUtils.SNPSubstitutionType((byte)ref.getBases()[0], (byte)alt.getBases()[0]) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static boolean isTransversion(Allele ref, Allele alt) {
        return BaseUtils.SNPSubstitutionType((byte)ref.getBases()[0], (byte)alt.getBases()[0]) == BaseUtils.BaseSubstitutionType.TRANSVERSION;
    }

    public static final GenomeLoc getLocation(GenomeLocParser genomeLocParser, VariantContext vc) {
        return genomeLocParser.createGenomeLoc(vc.getChr(), vc.getStart(), vc.getEnd(), true);
    }

    public static final Set<String> genotypeNames(Collection<Genotype> genotypes) {
        HashSet<String> names = new HashSet<String>(genotypes.size());
        for (Genotype g : genotypes) {
            names.add(g.getSampleName());
        }
        return names;
    }

    public static GenotypesContext assignDiploidGenotypes(VariantContext vc) {
        return VariantContextUtils.subsetDiploidAlleles(vc, vc.getAlleles(), true);
    }

    public static GenotypesContext subsetDiploidAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes) {
        GenotypesContext oldGTs = vc.getGenotypes();
        List<String> sampleIndices = oldGTs.getSampleNamesOrderedByName();
        GenotypesContext newGTs = GenotypesContext.create();
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        int numNewAltAlleles = allelesToUse.size() - 1;
        ArrayList<Integer> likelihoodIndexesToUse = null;
        if (numNewAltAlleles != numOriginalAltAlleles && numNewAltAlleles > 0) {
            likelihoodIndexesToUse = new ArrayList<Integer>(30);
            boolean[] altAlleleIndexToUse = new boolean[numOriginalAltAlleles];
            for (int i = 0; i < numOriginalAltAlleles; ++i) {
                if (!allelesToUse.contains(vc.getAlternateAllele(i))) continue;
                altAlleleIndexToUse[i] = true;
            }
            int numLikelihoods = GenotypeLikelihoods.numLikelihoods(1 + numOriginalAltAlleles, 2);
            for (int PLindex = 0; PLindex < numLikelihoods; ++PLindex) {
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
                if (alleles.alleleIndex1 != 0 && !altAlleleIndexToUse[alleles.alleleIndex1 - 1] || alleles.alleleIndex2 != 0 && !altAlleleIndexToUse[alleles.alleleIndex2 - 1]) continue;
                likelihoodIndexesToUse.add(PLindex);
            }
        }
        for (int k = 0; k < oldGTs.size(); ++k) {
            double[] newLikelihoods;
            Genotype g = oldGTs.get(sampleIndices.get(k));
            if (!g.hasLikelihoods()) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            double[] originalLikelihoods = g.getLikelihoods().getAsVector();
            if (likelihoodIndexesToUse == null) {
                newLikelihoods = originalLikelihoods;
            } else {
                newLikelihoods = new double[likelihoodIndexesToUse.size()];
                int newIndex = 0;
                Iterator i$ = likelihoodIndexesToUse.iterator();
                while (i$.hasNext()) {
                    int oldIndex = (Integer)i$.next();
                    newLikelihoods[newIndex++] = originalLikelihoods[oldIndex];
                }
                newLikelihoods = MathUtils.normalizeFromLog10((double[])newLikelihoods, (boolean)false, (boolean)true);
            }
            if (MathUtils.sum((double[])newLikelihoods) > -0.1) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            GenotypeBuilder gb = new GenotypeBuilder(g);
            if (numNewAltAlleles == 0) {
                gb.noPL();
            } else {
                gb.PL(newLikelihoods);
            }
            if (!assignGenotypes || MathUtils.sum((double[])newLikelihoods) > -0.1) {
                gb.alleles(NO_CALL_ALLELES);
            } else {
                int PLindex = numNewAltAlleles == 0 ? 0 : MathUtils.maxElementIndex((double[])newLikelihoods);
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
                gb.alleles(Arrays.asList(allelesToUse.get(alleles.alleleIndex1), allelesToUse.get(alleles.alleleIndex2)));
                if (numNewAltAlleles != 0) {
                    gb.log10PError(GenotypeLikelihoods.getGQLog10FromLikelihoods(PLindex, newLikelihoods));
                }
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    @Requires(value={"vc != null", "refBasesStartingAtVCWithPad != null && refBasesStartingAtVCWithPad.length > 0"})
    public static boolean isTandemRepeat(VariantContext vc, byte[] refBasesStartingAtVCWithPad) {
        String refBasesStartingAtVCWithoutPad = new String(refBasesStartingAtVCWithPad).substring(1);
        if (!vc.isIndel()) {
            return false;
        }
        Allele ref = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (VariantContextUtils.isRepeatAllele(ref, allele, refBasesStartingAtVCWithoutPad)) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"vc != null", "refBasesStartingAtVCWithPad != null && refBasesStartingAtVCWithPad.length > 0"})
    public static Pair<List<Integer>, byte[]> getNumTandemRepeatUnits(VariantContext vc, byte[] refBasesStartingAtVCWithPad) {
        boolean VERBOSE = false;
        String refBasesStartingAtVCWithoutPad = new String(refBasesStartingAtVCWithPad).substring(1);
        if (!vc.isIndel()) {
            return null;
        }
        Allele ref = vc.getReference();
        byte[] repeatUnit = null;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele allele : vc.getAlternateAlleles()) {
            Pair<int[], byte[]> result = VariantContextUtils.getNumTandemRepeatUnits(ref.getBases(), allele.getBases(), refBasesStartingAtVCWithoutPad.getBytes());
            int[] repetitionCount = (int[])result.first;
            if (repetitionCount[0] == 0 || repetitionCount[1] == 0) {
                return null;
            }
            if (lengths.size() == 0) {
                lengths.add(repetitionCount[0]);
            }
            lengths.add(repetitionCount[1]);
            repeatUnit = (byte[])result.second;
        }
        return new Pair(lengths, repeatUnit);
    }

    protected static Pair<int[], byte[]> getNumTandemRepeatUnits(byte[] refBases, byte[] altBases, byte[] remainingRefContext) {
        byte[] longB = altBases.length > refBases.length ? altBases : refBases;
        int repeatUnitLength = VariantContextUtils.findRepeatedSubstring(longB);
        byte[] repeatUnit = Arrays.copyOf(longB, repeatUnitLength);
        int[] repetitionCount = new int[2];
        int repetitionsInRef = VariantContextUtils.findNumberofRepetitions(repeatUnit, refBases);
        repetitionCount[0] = VariantContextUtils.findNumberofRepetitions(repeatUnit, ArrayUtils.addAll((byte[])refBases, (byte[])remainingRefContext)) - repetitionsInRef;
        repetitionCount[1] = VariantContextUtils.findNumberofRepetitions(repeatUnit, ArrayUtils.addAll((byte[])altBases, (byte[])remainingRefContext)) - repetitionsInRef;
        return new Pair((Object)repetitionCount, (Object)repeatUnit);
    }

    protected static int findRepeatedSubstring(byte[] bases) {
        int repLength;
        for (repLength = 1; repLength <= bases.length; ++repLength) {
            byte[] candidateRepeatUnit = Arrays.copyOf(bases, repLength);
            boolean allBasesMatch = true;
            for (int start = repLength; start < bases.length; start += repLength) {
                byte[] basePiece = Arrays.copyOfRange(bases, start, start + candidateRepeatUnit.length);
                if (Arrays.equals(candidateRepeatUnit, basePiece)) continue;
                allBasesMatch = false;
                break;
            }
            if (!allBasesMatch) continue;
            return repLength;
        }
        return repLength;
    }

    protected static int findNumberofRepetitions(byte[] repeatUnit, byte[] testString) {
        int numRepeats = 0;
        for (int start = 0; start < testString.length; start += repeatUnit.length) {
            int end = start + repeatUnit.length;
            byte[] unit = Arrays.copyOfRange(testString, start, end);
            if (Arrays.equals(unit, repeatUnit)) {
                ++numRepeats;
                continue;
            }
            return numRepeats;
        }
        return numRepeats;
    }

    protected static boolean isRepeatAllele(Allele ref, Allele alt, String refBasesStartingAtVCWithoutPad) {
        if (!Allele.oneIsPrefixOfOther(ref, alt)) {
            return false;
        }
        if (ref.length() > alt.length()) {
            return VariantContextUtils.basesAreRepeated(ref.getBaseString(), alt.getBaseString(), refBasesStartingAtVCWithoutPad, 2);
        }
        return VariantContextUtils.basesAreRepeated(alt.getBaseString(), ref.getBaseString(), refBasesStartingAtVCWithoutPad, 1);
    }

    protected static boolean basesAreRepeated(String l, String s, String ref, int minNumberOfMatches) {
        String potentialRepeat = l.substring(s.length());
        for (int i = 0; i < minNumberOfMatches; ++i) {
            int start = i * potentialRepeat.length();
            int end = (i + 1) * potentialRepeat.length();
            if (ref.length() < end) {
                return false;
            }
            String refSub = ref.substring(start, end);
            if (refSub.equals(potentialRepeat)) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"! alleles.isEmpty()", "start > 0", "endForSymbolicAlleles == -1 || endForSymbolicAlleles > 0"})
    public static int computeEndFromAlleles(List<Allele> alleles, int start, int endForSymbolicAlleles) {
        Allele ref = alleles.get(0);
        if (ref.isNonReference()) {
            throw new ReviewedStingException("computeEndFromAlleles requires first allele to be reference");
        }
        if (VariantContext.hasSymbolicAlleles(alleles)) {
            if (endForSymbolicAlleles == -1) {
                throw new ReviewedStingException("computeEndFromAlleles found a symbolic allele but endForSymbolicAlleles was provided");
            }
            return endForSymbolicAlleles;
        }
        return start + Math.max(ref.length() - 1, 0);
    }

    static {
        engine.setSilent(false);
        engine.setLenient(false);
        engine.setDebug(false);
        NO_CALL_ALLELES = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    }

    static class CompareByPriority
    implements Comparator<VariantContext>,
    Serializable {
        List<String> priorityListOfVCs;

        public CompareByPriority(List<String> priorityListOfVCs) {
            this.priorityListOfVCs = priorityListOfVCs;
        }

        private int getIndex(VariantContext vc) {
            int i = this.priorityListOfVCs.indexOf(vc.getSource());
            if (i == -1) {
                throw new UserException.BadArgumentValue(Utils.join((String)",", this.priorityListOfVCs), "Priority list " + this.priorityListOfVCs + " doesn't contain variant context " + vc.getSource());
            }
            return i;
        }

        @Override
        public int compare(VariantContext vc1, VariantContext vc2) {
            return Integer.valueOf(this.getIndex(vc1)).compareTo(this.getIndex(vc2));
        }
    }

    private static class AlleleMapper {
        private VariantContext vc = null;
        private Map<Allele, Allele> map = null;

        public AlleleMapper(VariantContext vc) {
            this.vc = vc;
        }

        public AlleleMapper(Map<Allele, Allele> map) {
            this.map = map;
        }

        public boolean needsRemapping() {
            return this.map != null;
        }

        public Collection<Allele> values() {
            return this.map != null ? this.map.values() : this.vc.getAlleles();
        }

        public Allele remap(Allele a) {
            return this.map != null && this.map.containsKey(a) ? this.map.get(a) : a;
        }

        public List<Allele> remap(List<Allele> as) {
            ArrayList<Allele> newAs = new ArrayList<Allele>();
            for (Allele a : as) {
                newAs.add(this.remap(a));
            }
            return newAs;
        }
    }

    @Hidden
    public static enum MultipleAllelesMergeType {
        BY_TYPE,
        MIX_TYPES;

    }

    public static enum FilteredRecordMergeType {
        KEEP_IF_ANY_UNFILTERED,
        KEEP_IF_ALL_UNFILTERED,
        KEEP_UNCONDITIONAL;

    }

    public static enum GenotypeMergeType {
        UNIQUIFY,
        PRIORITIZE,
        UNSORTED,
        REQUIRE_UNIQUE;

    }

    public static class JexlVCMatchExp {
        public String name;
        public Expression exp;

        public JexlVCMatchExp(String name, Expression exp) {
            this.name = name;
            this.exp = exp;
        }
    }
}

