/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.charts.ScatterPlotData;
import org.broad.igv.charts.ScatterPlotFrame;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.collections.DoubleArrayList;

public class ScatterPlotUtils {
    static HashSet<TrackType> plottableTypes = new HashSet();
    public static final String MUTATION_COUNT = "Mutation Count";

    public static void openPlot(String chr, int start, int end, int zoom) {
        ScatterPlotData spData = ScatterPlotUtils.getScatterPlotData(chr, start, end, zoom);
        final ScatterPlotFrame igvPlotFrame = new ScatterPlotFrame(spData);
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                igvPlotFrame.setVisible(true);
            }
        });
    }

    public static boolean hasPlottableTracks() {
        List<Track> tracks = IGV.getInstance().getAllTracks();
        for (Track t : tracks) {
            if (!plottableTypes.contains((Object)t.getTrackType())) continue;
            return true;
        }
        return false;
    }

    private static ScatterPlotData getScatterPlotData(String chr, int start, int end, int zoom) {
        SampleData sd;
        List<Track> tracks = IGV.getInstance().getAllTracks();
        List<String> attributeNames = AttributeManager.getInstance().getAttributeNames();
        LinkedHashMap<String, SampleData> sampleDataMap = new LinkedHashMap<String, SampleData>();
        LinkedHashSet<TrackType> types = new LinkedHashSet<TrackType>();
        LinkedHashMap uniqueAttributeValues = new LinkedHashMap();
        for (String att : attributeNames) {
            uniqueAttributeValues.put(att, new HashSet());
        }
        uniqueAttributeValues.put(MUTATION_COUNT, new HashSet());
        HashSet<String> nonSharedAttributes = new HashSet<String>();
        for (Track t : tracks) {
            double regionScore;
            String sample = t.getSample();
            TrackType type = t.getTrackType();
            if (type == TrackType.MUTATION) {
                SampleData sampleData = (SampleData)sampleDataMap.get(sample);
                if (sampleData == null) continue;
                int mutCount = ScatterPlotUtils.getMutationCount(chr, start, end, zoom, t);
                String mutCountString = mutCount < 5 ? String.valueOf(mutCount) : "> 5";
                sampleData.addAttributeValue(MUTATION_COUNT, mutCountString);
                ((Set)uniqueAttributeValues.get(MUTATION_COUNT)).add(mutCountString);
                sampleData.setMutationCount(mutCount);
                continue;
            }
            if (!(t instanceof DataTrack)) continue;
            DataTrack dataTrack = (DataTrack)t;
            if (!plottableTypes.contains((Object)type) || Double.isNaN(regionScore = dataTrack.getAverageScore(chr, start, end, zoom))) continue;
            types.add(type);
            SampleData sampleData = (SampleData)sampleDataMap.get(sample);
            if (sampleData == null) {
                sampleData = new SampleData();
                sampleDataMap.put(sample, sampleData);
            }
            for (String att : attributeNames) {
                String attributeValue = dataTrack.getAttributeValue(att);
                sampleData.addAttributeValue(att, attributeValue);
                ((Set)uniqueAttributeValues.get(att)).add(attributeValue);
                String otherValue = sampleData.getAttributesMap().get(att);
                if (attributeValue == null) {
                    if (otherValue == null) continue;
                    nonSharedAttributes.add(att);
                    continue;
                }
                if (otherValue == null) {
                    if (attributeValue == null) continue;
                    nonSharedAttributes.add(att);
                    continue;
                }
                if (attributeValue.equals(otherValue)) continue;
                nonSharedAttributes.add(att);
            }
            sampleData.addDataValue(type, regionScore);
        }
        String[] sampleNames = sampleDataMap.keySet().toArray(new String[sampleDataMap.size()]);
        HashMap<String, double[]> dataMap = new HashMap<String, double[]>(types.size());
        HashMap<TrackType, Integer> typeCounts = new HashMap<TrackType, Integer>();
        for (TrackType type : types) {
            double[] data = new double[sampleNames.length];
            for (int i = 0; i < sampleNames.length; ++i) {
                int cnt;
                double value;
                sd = (SampleData)sampleDataMap.get(sampleNames[i]);
                DoubleArrayList valueList = sd.getData(type);
                if (valueList == null || valueList.isEmpty()) {
                    value = Double.NaN;
                } else if (valueList.size() == 1) {
                    cnt = typeCounts.get((Object)type) == null ? 1 : (Integer)typeCounts.get((Object)type) + 1;
                    typeCounts.put(type, cnt);
                    value = valueList.get(0);
                } else {
                    cnt = typeCounts.get((Object)type) == null ? valueList.size() : (Integer)typeCounts.get((Object)type) + valueList.size();
                    typeCounts.put(type, cnt);
                    double[] vs = valueList.toArray();
                    value = StatUtils.mean(vs);
                }
                data[i] = value;
            }
            dataMap.put(type.toString(), data);
        }
        ArrayList<String> seriesNames = new ArrayList<String>();
        for (Map.Entry entry : uniqueAttributeValues.entrySet()) {
            int cnt = ((Set)entry.getValue()).size();
            String att = (String)entry.getKey();
            if (cnt <= 1 || cnt >= 10 || nonSharedAttributes.contains(att) || att.equalsIgnoreCase("DATA FILE") || att.equalsIgnoreCase("DATA TYPE")) continue;
            seriesNames.add(att);
        }
        HashMap<String, String[]> attMap = new HashMap<String, String[]>(seriesNames.size());
        for (String att : seriesNames) {
            String[] attributes = new String[sampleNames.length];
            for (int i = 0; i < sampleNames.length; ++i) {
                String s;
                SampleData sd2 = (SampleData)sampleDataMap.get(sampleNames[i]);
                attributes[i] = s = sd2.getAttributesMap().get(att);
            }
            attMap.put(att, attributes);
        }
        int[] mutationCounts = new int[sampleNames.length];
        for (int i = 0; i < sampleNames.length; ++i) {
            sd = (SampleData)sampleDataMap.get(sampleNames[i]);
            mutationCounts[i] = sd.getMutationCount();
        }
        String title = chr + ":" + start + "-" + end;
        return new ScatterPlotData(title, sampleNames, attMap, dataMap, mutationCounts);
    }

    public static int getMutationCount(String chr, int start, int end, int zoom, Track track) {
        return (int)track.getRegionScore(chr, start, end, zoom, RegionScoreType.MUTATION_COUNT, FrameManager.getDefaultFrame().getName());
    }

    static {
        plottableTypes.add(TrackType.COPY_NUMBER);
        plottableTypes.add(TrackType.GENE_EXPRESSION);
        plottableTypes.add(TrackType.DNA_METHYLATION);
    }

    public static class SampleData {
        Map<TrackType, DoubleArrayList> valueMap = new HashMap<TrackType, DoubleArrayList>();
        Map<String, String> attributesMap = new HashMap<String, String>();
        int mutationCount;

        public void addDataValue(TrackType type, double value) {
            DoubleArrayList valueArray = this.valueMap.get((Object)type);
            if (valueArray == null) {
                valueArray = new DoubleArrayList();
                this.valueMap.put(type, valueArray);
            }
            valueArray.add(value);
        }

        public DoubleArrayList getData(TrackType type) {
            return this.valueMap.get((Object)type);
        }

        public void addAttributeValue(String att, String attributeValue) {
            this.attributesMap.put(att, attributeValue);
        }

        public Map<String, String> getAttributesMap() {
            return this.attributesMap;
        }

        public void setMutationCount(int mutationCount) {
            this.mutationCount = mutationCount;
        }

        public int getMutationCount() {
            return this.mutationCount;
        }
    }
}

