/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;

public class VCFCodec
extends AbstractVCFCodec {
    public static final String VCF4_MAGIC_HEADER = "##fileformat=VCFv4";
    private VCFHeader headerForRepairs = null;

    @Override
    public Object readHeader(LineReader reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        try {
            String line;
            boolean foundHeaderVersion = false;
            while ((line = reader.readLine()) != null) {
                ++this.lineNo;
                if (line.startsWith("##")) {
                    String[] lineFields = line.substring(2).split("=");
                    if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                        }
                        foundHeaderVersion = true;
                        this.version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                        if (this.version == VCFHeaderVersion.VCF3_3 || this.version == VCFHeaderVersion.VCF3_2) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + lineFields[1]);
                        }
                        if (this.version != VCFHeaderVersion.VCF4_0 && this.version != VCFHeaderVersion.VCF4_1) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + lineFields[1]);
                        }
                    }
                    headerStrings.add(line);
                    continue;
                }
                if (line.startsWith("#")) {
                    if (!foundHeaderVersion) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    headerStrings.add(line);
                    super.parseHeaderFromLines(headerStrings, this.version);
                    if (this.headerForRepairs != null) {
                        this.header = this.repairHeader(this.header, this.headerForRepairs);
                    }
                    return this.header;
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception ", e);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    private final VCFHeader repairHeader(VCFHeader readHeader, VCFHeader masterHeader) {
        Set<VCFHeaderLine> lines = VCFUtils.smartMergeHeaders(Arrays.asList(readHeader, masterHeader), log);
        return new VCFHeader(lines, readHeader.getGenotypeSamples());
    }

    public void setHeaderForRepairs(VCFHeader headerForRepairs) {
        if (headerForRepairs != null) {
            log.info("Using master VCF header to repair missing files from incoming VCFs");
        }
        this.headerForRepairs = headerForRepairs;
    }

    @Override
    protected List<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        if (filterString.equals("PASS")) {
            return Collections.emptyList();
        }
        if (filterString.equals("0")) {
            VCFCodec.generateException("0 is an invalid filter name in vcf4", this.lineNo);
        }
        if (filterString.length() == 0) {
            VCFCodec.generateException("The VCF specification requires a valid filter status: filter was " + filterString, this.lineNo);
        }
        if (this.filterHash.containsKey(filterString)) {
            return (List)this.filterHash.get(filterString);
        }
        LinkedList<String> fFields = new LinkedList<String>();
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, Collections.unmodifiableList(fFields));
        return fFields;
    }

    @Override
    public boolean canDecode(String potentialInput) {
        return VCFCodec.canDecodeFile(potentialInput, VCF4_MAGIC_HEADER);
    }
}

