/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.ParsingUtils;

public class MacroSnapshotAction {
    public static File OUTPUT_DIRECTORY = new File(".");
    private static Logger log = Logger.getLogger(MacroSnapshotAction.class);

    public static final void doScreenshots(File regionFile, File outputDirectory) {
        MacroSnapshotAction.doSnapshots(regionFile, outputDirectory);
    }

    public static final void doSnapshots(File regionFile, File outputDirectory) {
        List<String> loci = ParsingUtils.loadRegions(regionFile);
        for (String locus : loci) {
            IGV.getInstance().goToLocus(locus);
            MacroSnapshotAction.createSnapshot(outputDirectory, null);
        }
    }

    public static final synchronized void setOutputDirectory(String dir) {
        OUTPUT_DIRECTORY = new File(dir);
        if (!OUTPUT_DIRECTORY.exists()) {
            log.error("Warning: non existent directory: " + dir);
        }
    }

    public static final void doSnapshot(String filename) {
        MacroSnapshotAction.createSnapshot(OUTPUT_DIRECTORY, filename);
    }

    private static synchronized void createSnapshot(File outputDirectory, String filename) {
        IGV mainFrame = IGV.getInstance();
        if (filename == null) {
            String locus = FrameManager.getDefaultFrame().getFormattedLocusString();
            filename = locus.replaceAll(":", "_").replace("-", "_") + ".png";
        }
        IGV.getInstance().repaintDataAndHeaderPanels();
        IGV.getInstance().repaintStatusAndZoomSlider();
        File file = new File(outputDirectory, filename);
        log.info("Snapshot: " + filename);
        try {
            mainFrame.createSnapshotNonInteractive(file);
        }
        catch (IOException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }
}

