/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.data.cufflinks.ExpDiffValue;
import org.broad.igv.data.cufflinks.FPKMValue;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;

public class CufflinksParser {
    private static Logger log = Logger.getLogger(CufflinksParser.class);

    public static List<CufflinksValue> parse(String path) throws IOException {
        String s = path.toLowerCase();
        if (s.endsWith("fpkm_tracking")) {
            return CufflinksParser.parseFpkmTracking(path);
        }
        if (s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff")) {
            return CufflinksParser.parseExpDiff(path);
        }
        throw new RuntimeException("Unsupported file type: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CufflinksValue> parseFpkmTracking(String path) throws IOException {
        BufferedReader br = null;
        try {
            br = ParsingUtils.openBufferedReader(path);
            ArrayList<CufflinksValue> values = new ArrayList<CufflinksValue>();
            int geneColumn = 4;
            int locusColumn = 6;
            int fpkmColumn = 6;
            int confLoColumn = 7;
            int confHiColumn = 8;
            int sigColumn = 12;
            String nextLine = br.readLine();
            String[] tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
            for (int i = 0; i < tokens.length; ++i) {
                String tk = tokens[i];
                if (tk.equals("locus")) {
                    locusColumn = i;
                    continue;
                }
                if (tk.equals("gene_short_name")) {
                    geneColumn = i;
                    continue;
                }
                if (tk.equals("FPKM")) {
                    fpkmColumn = i;
                    continue;
                }
                if (tk.equals("FPKM_conf_lo")) {
                    confLoColumn = i;
                    continue;
                }
                if (!tk.startsWith("FPKM_conf_hi")) continue;
                confHiColumn = i;
            }
            while ((nextLine = br.readLine()) != null) {
                try {
                    tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
                    if (tokens.length >= 12) {
                        String locusString = tokens[locusColumn];
                        Locus locus = new Locus(locusString);
                        if (locus == null || locus.getChr() == null) continue;
                        float fpkm = Float.parseFloat(tokens[fpkmColumn]);
                        float confLo = Float.parseFloat(tokens[confLoColumn]);
                        float confHi = Float.parseFloat(tokens[confHiColumn]);
                        String gene = tokens[geneColumn];
                        values.add(new FPKMValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), fpkm, confLo, confHi));
                        continue;
                    }
                    log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
                }
                catch (NumberFormatException e) {
                    log.info("Skipping line: " + nextLine);
                }
            }
            ArrayList<CufflinksValue> arrayList = values;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CufflinksValue> parseExpDiff(String path) throws IOException {
        BufferedReader br = null;
        try {
            br = ParsingUtils.openBufferedReader(path);
            ArrayList<CufflinksValue> values = new ArrayList<CufflinksValue>();
            int geneColumn = 1;
            int locusColumn = 2;
            int xColumn = 6;
            int yColumn = 7;
            int logRatioColumn = 8;
            int sigColumn = 12;
            String nextLine = br.readLine();
            String[] tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
            for (int i = 0; i < tokens.length; ++i) {
                String tk = tokens[i];
                if (tk.equals("locus")) {
                    locusColumn = i;
                    continue;
                }
                if (tk.equals("gene")) {
                    geneColumn = i;
                    continue;
                }
                if (tk.equals("value_1")) {
                    xColumn = i;
                    continue;
                }
                if (tk.equals("value_2")) {
                    yColumn = i;
                    continue;
                }
                if (tk.startsWith("log2(")) {
                    logRatioColumn = i;
                    continue;
                }
                if (!tk.equals("significant")) continue;
                sigColumn = i;
            }
            while ((nextLine = br.readLine()) != null) {
                try {
                    tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
                    if (tokens.length >= sigColumn) {
                        float logRatio;
                        String locusString = tokens[locusColumn];
                        Locus locus = new Locus(locusString);
                        if (locus == null || locus.getChr() == null || Float.isInfinite(logRatio = Float.parseFloat(tokens[logRatioColumn])) || Float.isNaN(logRatio)) continue;
                        float fpkmX = Float.parseFloat(tokens[xColumn]);
                        float fpkmY = Float.parseFloat(tokens[yColumn]);
                        String gene = tokens[geneColumn];
                        String significant = tokens[sigColumn];
                        values.add(new ExpDiffValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), logRatio, fpkmX, fpkmY, significant){});
                        continue;
                    }
                    log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
                }
                catch (NumberFormatException e) {
                    log.info("Skipping line: " + nextLine);
                }
            }
            ArrayList<CufflinksValue> arrayList = values;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

