/*
 * Copyright (c) 2007-2013 by The Broad Institute of MIT and Harvard.  All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL),
 * Version 2.1 which is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR
 * WARRANTES OF ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING,
 * WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, WHETHER
 * OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR RESPECTIVE
 * TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES
 * OF ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES,
 * ECONOMIC DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER
 * THE BROAD OR MIT SHALL BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT
 * SHALL KNOW OF THE POSSIBILITY OF THE FOREGOING.
 */

package org.broad.igv.data.cufflinks;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

import java.awt.*;
import java.util.List;

/**
 * @author jrobinso
 *         Date: 3/8/13
 *         Time: 5:45 PM
 */
public class CufflinksTrack extends DataTrack {

    CufflinksDataSource dataSource;

    public CufflinksTrack(ResourceLocator locator, String id, String name, CufflinksDataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
        setTrackType(TrackType.FPKM);

        if(isExpDiff(locator.getPath())) {
            // Make +/- scale symmetic
            float range = (float) Math.min(5, Math.abs(Math.max(dataSource.getDataMin(), dataSource.getDataMax())));
            setDataRange(new DataRange(-range, 0, range));
            setColor(Color.RED);
            setAltColor(Color.BLUE);
            setColorScale(new ContinuousColorScale(-range, 0, range, Color.RED, Color.WHITE,  Color.BLUE));
        }

        else {
            setDataRange(new DataRange((float) dataSource.getDataMin(), 0, (float) dataSource.getDataMax()));
        }

    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
    }


    // Bit of a hack
    boolean isExpDiff(String path) {
        return path.toLowerCase().endsWith("_exp.diff");
    }



}
