/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.FileUtils;
import org.broad.tribble.util.LittleEndianOutputStream;

public class BedToPeaks {
    private static Map<String, String> colorMap;
    static int[] allTimes;
    private static CompressionUtils compressionUtils;

    public BedToPeaks() {
        compressionUtils = new CompressionUtils();
    }

    public static void main(String[] args) throws IOException {
        File inputDir = new File(args[0] + "bed/");
        File destDir = new File(args[0] + args[1]);
        String root = args[2];
        colorMap = BedToPeaks.loadColors(args[0] + "colors.txt");
        BedToPeaks.convertAll(inputDir, destDir, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBinaryPeakFile(String factor, List<Integer> times, List<File> bedFiles, File outputDir, String root) throws IOException {
        String c = colorMap.get(factor);
        if (c == null) {
            System.out.println("No color found for " + factor);
            c = "0,0,150";
        }
        String peeksFileName = factor + ".peak.bin";
        File peeksFile = new File(outputDir, peeksFileName);
        String tdf = root + "/tdf/compressed/" + factor + ".merged.bam.tdf";
        BufferedReader[] readers = new BufferedReader[bedFiles.size()];
        FilterOutputStream peakWriter = null;
        long indexPosition = 0L;
        try {
            for (int i = 0; i < bedFiles.size(); ++i) {
                readers[i] = new BufferedReader(new FileReader(bedFiles.get(i)));
            }
            peakWriter = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(peeksFile)));
            if (peakWriter != null) {
                LinkedHashMap<String, Long> chrIndex = new LinkedHashMap<String, Long>();
                String[] line = new String[readers.length];
                ((LittleEndianOutputStream)peakWriter).writeLong(0L);
                int nTimePoints = times.size();
                ((LittleEndianOutputStream)peakWriter).writeString("track name=" + factor + " sample=" + factor + " viewLimits=0:100 useScore=1 color=" + c);
                ((LittleEndianOutputStream)peakWriter).writeInt(nTimePoints);
                for (int i = 0; i < times.size(); ++i) {
                    ((LittleEndianOutputStream)peakWriter).writeInt(times.get(i));
                }
                ((LittleEndianOutputStream)peakWriter).writeString(tdf);
                for (int t : times) {
                    ((LittleEndianOutputStream)peakWriter).writeString(root + "/tdf/timecourses/" + factor + "_" + t + "/" + factor + "_" + t + ".merged.bam.tdf");
                }
                String lastChr = "";
                ArrayList<PeakRecord> records = new ArrayList<PeakRecord>(20000);
                while (true) {
                    String chr = null;
                    String[] tokens = null;
                    for (int i = 0; i < readers.length; ++i) {
                        line[i] = readers[i].readLine();
                        if (line[i] == null) break;
                    }
                    if (line[0] != null) {
                        if (line[0].startsWith("#") || line[0].startsWith("track")) continue;
                        tokens = line[0].split("\t");
                        chr = tokens[0];
                    }
                    if ((chr == null && lastChr != null || !chr.equals(lastChr)) && records.size() > 0) {
                        chrIndex.put(lastChr, ((LittleEndianOutputStream)peakWriter).getWrittenCount());
                        BufferedByteWriter buffer = new BufferedByteWriter(100000);
                        buffer.putNullTerminatedString(lastChr);
                        buffer.putInt(records.size());
                        for (PeakRecord record : records) {
                            buffer.putInt(record.start);
                            buffer.putInt(record.end);
                            buffer.putFloat(record.score);
                            for (int i = 0; i < record.timeScores.length; ++i) {
                                buffer.putFloat(record.timeScores[i]);
                            }
                        }
                        records.clear();
                        byte[] bytes = buffer.getBytes();
                        bytes = compressionUtils.compress(bytes);
                        ((LittleEndianOutputStream)peakWriter).writeInt(bytes.length);
                        peakWriter.write(bytes);
                    }
                    if (chr == null) break;
                    lastChr = chr;
                    int start = Integer.parseInt((String)tokens[1]);
                    int end = Integer.parseInt(tokens[2]);
                    float score = Float.parseFloat(tokens[4]);
                    float[] timeScores = new float[nTimePoints];
                    for (int i = 0; i < nTimePoints; ++i) {
                        tokens = line[i + 1].split("\t");
                        if (!tokens[0].equals(chr) || Integer.parseInt(tokens[1]) != start || Integer.parseInt(tokens[2]) != end) {
                            throw new RuntimeException("Unordered files");
                        }
                        timeScores[i] = Float.parseFloat(tokens[4]);
                    }
                    records.add(new PeakRecord(start, end, score, timeScores));
                }
                indexPosition = ((LittleEndianOutputStream)peakWriter).getWrittenCount();
                ((LittleEndianOutputStream)peakWriter).writeInt(chrIndex.size());
                for (Map.Entry entry : chrIndex.entrySet()) {
                    ((LittleEndianOutputStream)peakWriter).writeString((String)entry.getKey());
                    ((LittleEndianOutputStream)peakWriter).writeLong((Long)entry.getValue());
                }
            }
        }
        finally {
            if (peakWriter != null) {
                peakWriter.close();
                BedToPeaks.writeIndexPosition(peeksFile, indexPosition);
            }
            for (BufferedReader reader : readers) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeIndexPosition(File file, long indexPosition) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.getChannel().position(0L);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(indexPosition);
            raf.write(buffer.getBytes());
            raf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void createPeakFile(String factor, List<File> bedFiles, File outputDir) throws IOException {
        times = new int[]{0, 30, 60, 120};
        if (BedToPeaks.colorMap == null) {
            BedToPeaks.colorMap = BedToPeaks.loadColors("/Users/jrobinso/IGV/time_course/colors.txt");
        }
        if ((c = BedToPeaks.colorMap.get(factor)) == null) {
            System.out.println("No color found for " + factor);
            c = "0,0,150";
        }
        readers = new BufferedReader[bedFiles.size()];
        peakWriter = null;
        cfgWriter = null;
        try {
            for (i = 0; i < bedFiles.size(); ++i) {
                readers[i] = new BufferedReader(new FileReader(bedFiles.get(i)));
            }
            peeksFile = new File(outputDir, factor + ".peak");
            peakWriter = new PrintWriter(new BufferedWriter(new FileWriter(peeksFile)));
            peaks = "http://www.broadinstitute.org/igvdata/ichip/peaks/" + peeksFile.getName();
            tdf = "http://www.broadinstitute.org/igvdata/ichip/tdf/compressed/" + factor + ".merged.bam.tdf";
            bam = "http://www.broadinstitute.org/igvdata/ichip/compressed/" + factor + "/" + factor + ".merged.bam";
            if (peakWriter != null) {
                peakWriter.println("track name=" + factor + " sample=" + factor + " viewLimits=0:100 useScore=1 color=" + c);
                for (File f : bedFiles) {
                    peakWriter.print("\t" + f.getName().replace(".bed", ""));
                }
                peakWriter.println();
                line = new String[readers.length];
                while (true) {
                    for (i = 0; i < readers.length; ++i) {
                        line[i] = readers[i].readLine();
                        if (line[i] != null) continue;
                        return;
                    }
                    if (line[0].startsWith("#") || line[0].startsWith("track")) ** continue;
                    tokens = line[0].split("\t");
                    chr = tokens[0];
                    start = Integer.parseInt(tokens[1]);
                    end = Integer.parseInt(tokens[2]);
                    name = tokens[3];
                    score = Float.parseFloat(tokens[4]);
                    peakWriter.print(chr + "\t" + start + "\t" + end + "\t" + name + "\t" + score);
                    for (i = 1; i < line.length; ++i) {
                        tokens = line[i].split("\t");
                        if (!tokens[0].equals(chr) || Integer.parseInt(tokens[1]) != start || Integer.parseInt(tokens[2]) != end) {
                            throw new RuntimeException("Unordered files");
                        }
                        score = Float.parseFloat(tokens[4]);
                        peakWriter.print("\t" + score);
                    }
                    peakWriter.println();
                }
            }
        }
        finally {
            if (peakWriter != null) {
                peakWriter.close();
            }
            if (cfgWriter != null) {
                cfgWriter.close();
            }
            for (BufferedReader reader : readers) {
                reader.close();
            }
        }
    }

    public static void sortAll(String rootDir) throws IOException {
        for (File f : new File(rootDir).listFiles()) {
            File of;
            if (!f.getName().endsWith(".bed") || f.getName().endsWith(".sorted.bed") || (of = new File(f.getAbsolutePath().replace(".bed", ".sorted.bed"))).exists()) continue;
            System.out.println("Sorting " + f.getName());
            Sorter sorter = Sorter.getSorter(f, of);
            sorter.run();
        }
    }

    public static void convertAll(File rootDir, File destDir, String root) throws IOException {
        String factor;
        File factorFile = new File(rootDir, "factors.txt");
        BufferedReader reader = new BufferedReader(new FileReader(factorFile));
        while ((factor = reader.readLine()) != null) {
            factor = factor.trim();
            ArrayList<File> bedFiles = new ArrayList<File>();
            File bedFile = new File(rootDir, factor + ".peaks.filtered.by.fold.real.sorted.bed");
            if (bedFile.exists()) {
                bedFiles.add(bedFile);
            } else {
                System.out.println("Can't find " + bedFile.getName());
            }
            ArrayList<Integer> times = new ArrayList<Integer>();
            for (int i = 0; i < allTimes.length; ++i) {
                bedFile = new File(rootDir, factor + "_" + allTimes[i] + ".peaks.filtered.by.fold.real.sorted.bed");
                if (bedFile.exists()) {
                    bedFiles.add(bedFile);
                    times.add(allTimes[i]);
                    continue;
                }
                System.out.println("Can't find " + bedFile.getName());
            }
            BedToPeaks.createBinaryPeakFile(factor, times, bedFiles, destDir, root);
        }
        reader.close();
    }

    public static void downloadAll(String rootDir, File destDir) throws IOException {
        String factor;
        File factorFile = new File("/Users/jrobinso/IGV/time_course/factors.txt");
        int[] time = new int[]{0, 30, 60, 120};
        BufferedReader reader = new BufferedReader(new FileReader(factorFile));
        while ((factor = reader.readLine()) != null) {
            factor = factor.trim();
            ArrayList bedFiles = new ArrayList();
            String segments = factor.equals("K4me3") || factor.equals("K4me1") || factor.equals("K27Ac") ? "/segments_0.01/" : "/segments_0.05/";
            File bedFile = new File(rootDir + factor + segments + factor + ".peaks.filtered.by.fold.real.bed");
            if (bedFile.exists()) {
                System.out.println("Copying " + bedFile.getName());
                FileUtils.copyFile(bedFile, new File(destDir, bedFile.getName()));
            } else {
                System.out.println("File not found: " + bedFile);
            }
            for (int i = 0; i < time.length; ++i) {
                bedFile = new File(rootDir + "timecourses/" + factor + "_" + time[i] + segments + factor + "_" + time[i] + ".peaks.filtered.by.fold.real.bed");
                if (!bedFile.exists()) continue;
                System.out.println("Copying " + bedFile.getName());
                FileUtils.copyFile(bedFile, new File(destDir, bedFile.getName()));
            }
        }
        reader.close();
    }

    public static Map<String, String> loadColors(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split("\t");
            map.put(tokens[0], tokens[1]);
        }
        reader.close();
        return map;
    }

    static {
        allTimes = new int[]{0, 30, 60, 120};
    }

    static class PeakRecord {
        int start;
        int end;
        float score;
        float[] timeScores;

        PeakRecord(int start, int end, float score, float[] timeScores) {
            this.start = start;
            this.end = end;
            this.score = score;
            this.timeScores = timeScores;
        }
    }
}

