/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.broad.igv.graph.Edge;
import org.broad.igv.graph.Graph;
import org.broad.igv.graph.Node;
import org.broad.igv.graph.SubGraph;

public class GraphPanel2
extends JPanel {
    private Graph graph;
    int topMargin = 50;
    int leftMargin = 20;
    int nodeWidth = 5;
    int nodeHeight = 5;
    int ySpacing = 20;

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.graph != null) {
            float dx = this.graph.getMaxX() - this.graph.getMinX();
            float scale = (float)(this.getWidth() - 2 * this.leftMargin) / dx;
            for (Node node : this.graph.getNodes()) {
                int pixelX = this.getXPosition(scale, node.getCellX());
                int pixelY = this.getYPosition(node);
                g.setColor(Color.BLUE);
                g.fillRect(pixelX, pixelY, this.nodeWidth, this.nodeHeight);
            }
            for (SubGraph sg : this.graph.getSubGraphs()) {
                for (Edge edge : sg.getEdges()) {
                    Node parent = edge.getParent();
                    int px1 = this.getXPosition(scale, parent.getCellX()) + this.nodeWidth;
                    int py1 = this.getYPosition(parent) + this.nodeHeight / 2;
                    Node child = edge.getChild();
                    int px2 = this.getXPosition(scale, child.getCellX());
                    int py2 = this.getYPosition(child) + this.nodeHeight / 2;
                    g.setColor(edge.getColor());
                    g.drawLine(px1, py1, px2, py2);
                    g.setColor(Color.red);
                    g.fillRect(px2 - 1, py2 - 1, 2, 2);
                }
            }
        }
    }

    private int getYPosition(Node node) {
        return this.topMargin + node.getCellY() * this.ySpacing;
    }

    private int getXPosition(float scale, int x) {
        return this.leftMargin + (int)(scale * (float)(x - this.graph.getMinX()));
    }
}

