/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Comparator;

public class ChromosomeNameComparator
implements Comparator<String> {
    private static ChromosomeNameComparator instance;
    private Table<String, String, Integer> cache = HashBasedTable.create();

    private ChromosomeNameComparator() {
    }

    public static ChromosomeNameComparator get() {
        if (instance == null) {
            instance = new ChromosomeNameComparator();
        }
        return instance;
    }

    private boolean isMito(String chr) {
        return chr.equalsIgnoreCase("chrM") || chr.equalsIgnoreCase("MT");
    }

    @Override
    public int compare(String chr0, String chr1) {
        if (this.cache.contains(chr0, chr1)) {
            return this.cache.get(chr0, chr1);
        }
        int comparison = this.compareNonCache(chr0, chr1);
        if (this.cache.size() < 10000) {
            this.cache.put(chr0, chr1, comparison);
        }
        return comparison;
    }

    public void resetCache() {
        this.cache.clear();
    }

    public int compareNonCache(String chr0, String chr1) {
        int dig2;
        String alpha2;
        int[] range0 = this.findDigitRange(chr0);
        int[] range1 = this.findDigitRange(chr1);
        if (range0 == null || range1 == null || range0[0] != range1[0]) {
            boolean mito0 = this.isMito(chr0);
            boolean mito1 = this.isMito(chr1);
            if (mito0 && !mito1) {
                return 1;
            }
            if (!mito0 && mito1) {
                return -1;
            }
            if (mito0 && mito1) {
                return 0;
            }
            return chr0.compareToIgnoreCase(chr1);
        }
        String alpha1 = chr0.substring(0, range0[0]);
        int alphaCmp = alpha1.compareToIgnoreCase(alpha2 = chr1.substring(0, range1[0]));
        if (alphaCmp != 0) {
            return alphaCmp;
        }
        int dig1 = Integer.parseInt(chr0.substring(range0[0], range0[1]));
        int diff = dig1 - (dig2 = Integer.parseInt(chr1.substring(range1[0], range1[1])));
        if (diff != 0) {
            return diff;
        }
        return this.compare(chr0.substring(range0[1]), chr1.substring(range1[1]));
    }

    private int[] findDigitRange(String chr) {
        int[] locs = null;
        int loc = 0;
        for (char c : chr.toCharArray()) {
            if (Character.isDigit(c)) {
                if (locs == null) {
                    locs = new int[]{loc, chr.length()};
                }
            } else if (locs != null) {
                locs[1] = loc;
                break;
            }
            ++loc;
        }
        return locs;
    }
}

