/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginSpecReader {
    private static Logger log = Logger.getLogger(PluginSpecReader.class);
    protected String specPath;
    protected Document document;
    public static final String CUSTOM_PLUGINS_FILENAME = "custom_plugins.txt";
    public static final String BUILTIN_PLUGINS_FILENAME = "builtin_plugins.txt";
    public static final String TOOL_NAME_KEY = "name";
    private static List<PluginSpecReader> pluginList;

    private PluginSpecReader(String path) {
        this.specPath = path;
    }

    public static PluginSpecReader create(String path) {
        PluginSpecReader reader = new PluginSpecReader(path);
        if (!reader.parseDocument()) {
            return null;
        }
        return reader;
    }

    public static boolean isToolPathValid(String execPath) {
        File execFile = new File(execPath = FileUtils.findExecutableOnPath(execPath));
        boolean pathValid = execFile.isFile();
        if (pathValid && !execFile.canExecute()) {
            log.error(execPath + " exists but is not executable. ");
            pathValid = false;
        }
        return pathValid;
    }

    public String getSpecPath() {
        return this.specPath;
    }

    public String getId() {
        return this.document.getDocumentElement().getAttribute("id");
    }

    private boolean parseDocument() {
        boolean success = false;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            URL url = this.getClass().getResource(this.specPath);
            String uri = null;
            uri = url == null ? FileUtils.getAbsolutePath(this.specPath, new File(".").getAbsolutePath()) : url.toString();
            this.document = builder.parse(uri);
            success = this.document.getDocumentElement().getTagName().equals("igv_plugin");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    public List<Element> getTools() {
        return this.getElementsByTag(this.document.getDocumentElement(), "tool");
    }

    public List<Element> getCommands(Element tool) {
        return this.getElementsByTag(tool, "command");
    }

    public List<Argument> getArguments(Element tool, Element command) {
        List<Element> argEls = this.getElementsByTag(command, "arg");
        if (argEls.size() == 0) {
            argEls = this.getDefaultValues(tool, "arg");
        }
        return this.elementsToArguments(argEls);
    }

    private List<Element> getDefaultValues(Element tool, String tag) {
        NodeList defaults = tool.getElementsByTagName("default");
        assert (defaults.getLength() == 1);
        return this.getElementsByTag((Element)defaults.item(0), tag);
    }

    private List<Argument> elementsToArguments(List<Element> argEls) {
        ArrayList<Argument> argumentList = new ArrayList<Argument>();
        for (Element argEl : argEls) {
            argumentList.add(Argument.parseFromNode(argEl, this.getSpecPath()));
        }
        return argumentList;
    }

    private List<Element> getElementsByTag(Element topElement, String tag) {
        NodeList nodes = topElement.getElementsByTagName(tag);
        ArrayList<Element> outNodes = new ArrayList<Element>(nodes.getLength());
        for (int nn = 0; nn < nodes.getLength(); ++nn) {
            outNodes.add((Element)nodes.item(nn));
        }
        return outNodes;
    }

    public Map<String, String> getParsingAttributes(Element tool, Element command) {
        List<Element> parserEls = this.getElementsByTag(command, "parser");
        if (parserEls.size() == 0) {
            parserEls = this.getDefaultValues(tool, "parser");
        }
        if (parserEls.size() == 0) {
            return null;
        }
        assert (parserEls.size() == 1);
        return Utilities.getAttributes(parserEls.get(0));
    }

    public static List<PluginSpecReader> getPlugins() {
        if (pluginList == null) {
            pluginList = PluginSpecReader.generatePluginList();
        }
        return pluginList;
    }

    private static List<PluginSpecReader> generatePluginList() {
        ArrayList<PluginSpecReader> readers = new ArrayList<PluginSpecReader>();
        HashSet<String> pluginIds = new HashSet<String>();
        try {
            File[] checkDirs;
            for (File checkDir : checkDirs = new File[]{DirectoryManager.getIgvDirectory(), new File(FileUtils.getInstallDirectory()), new File(".")}) {
                File plugDir = new File(checkDir, "plugins");
                File[] possPlugins = plugDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                });
                if (possPlugins == null) {
                    possPlugins = new File[]{};
                }
                ArrayList<String> possPluginsList = new ArrayList<String>(possPlugins.length);
                for (File fi : possPlugins) {
                    possPluginsList.add(fi.getAbsolutePath());
                }
                File customFile = new File(checkDir, CUSTOM_PLUGINS_FILENAME);
                if (customFile.canRead()) {
                    BufferedReader br = new BufferedReader(new FileReader(customFile));
                    possPluginsList.addAll(PluginSpecReader.getPluginPaths(br));
                }
                for (String pluginName : PluginSpecReader.getBuiltinPlugins()) {
                    possPluginsList.add("resources/" + pluginName);
                }
                for (String possPlugin : possPluginsList) {
                    PluginSpecReader reader = PluginSpecReader.create(possPlugin);
                    if (reader == null || pluginIds.contains(reader.getId())) continue;
                    readers.add(reader);
                    pluginIds.add(reader.getId());
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return readers;
    }

    static List<String> getBuiltinPlugins() throws IOException {
        InputStream contentsStream = PluginSpecReader.class.getResourceAsStream("resources/builtin_plugins.txt");
        BufferedReader inReader = new BufferedReader(new InputStreamReader(contentsStream));
        return PluginSpecReader.getPluginPaths(inReader);
    }

    private static List<String> getPluginPaths(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> pluginPaths = new ArrayList<String>(3);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            pluginPaths.add(line);
        }
        return pluginPaths;
    }

    public static void addCustomPlugin(String absolutePath) throws IOException {
        File outFile = new File(DirectoryManager.getIgvDirectory(), CUSTOM_PLUGINS_FILENAME);
        outFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        writer.write(absolutePath);
        writer.write("\n");
        writer.flush();
        writer.close();
        pluginList = PluginSpecReader.generatePluginList();
    }

    public String getName() {
        return this.document.getDocumentElement().getAttribute(TOOL_NAME_KEY);
    }

    public String getToolPath(Element tool) {
        String toolPath = PreferenceManager.getInstance().getPluginPath(this.getId(), tool.getAttribute(TOOL_NAME_KEY));
        if (toolPath == null) {
            toolPath = tool.getAttribute("default_path");
        }
        return toolPath;
    }
}

