/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBTable {
    private static Logger log = Logger.getLogger(DBTable.class);
    private final ResourceLocator dbLocator;
    private final String tableName;
    private final String format;
    private final String binColName;
    private final String chromoColName;
    private final String posStartColName;
    private final String posEndColName;
    private final int startColIndex;
    private final int endColIndex;
    private final Map<Integer, String> columnLabelMap;
    private final String baseQuery;
    private final List<String> headerLines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBTable> parseProfile(String profilePath) {
        FileInputStream profileStream = null;
        String tableName = null;
        try {
            profileStream = new FileInputStream(profilePath);
            Document document = Utilities.createDOMDocumentFromXmlStream(profileStream);
            ResourceLocator dbLocator = DBTable.createDBLocator(document);
            NodeList tableNodes = document.getElementsByTagName("table");
            ArrayList<DBTable> tableList = new ArrayList<DBTable>(tableNodes.getLength());
            for (int tnum = 0; tnum < tableNodes.getLength(); ++tnum) {
                Node tableNode = tableNodes.item(tnum);
                NamedNodeMap attr = tableNode.getAttributes();
                tableName = attr.getNamedItem("name").getTextContent();
                String chromoColName = attr.getNamedItem("chromoColName").getTextContent();
                String posStartColName = attr.getNamedItem("posStartColName").getTextContent();
                String format = attr.getNamedItem("format").getTextContent();
                String posEndColName = Utilities.getNullSafe(attr, "posEndColName");
                String startColString = Utilities.getNullSafe(attr, "startColIndex");
                String endColString = Utilities.getNullSafe(attr, "endColIndex");
                String binColName = Utilities.getNullSafe(attr, "binColName");
                String baseQuery = Utilities.getNullSafe(attr, "baseQuery");
                int startColIndex = Integer.parseInt(startColString);
                int endColIndex = Integer.parseInt(endColString);
                Element tableElement = (Element)tableNode;
                NodeList columnNodes = tableElement.getElementsByTagName("column");
                HashMap<Integer, String> columnLabelMap = null;
                if (columnNodes.getLength() > 0) {
                    columnLabelMap = new HashMap<Integer, String>(columnNodes.getLength());
                    for (int col = 0; col < columnNodes.getLength(); ++col) {
                        Node child = columnNodes.item(col);
                        NamedNodeMap colAttr = child.getAttributes();
                        int fileIndex = Integer.parseInt(colAttr.getNamedItem("fileIndex").getTextContent());
                        String colLabel = Utilities.getNullSafe(colAttr, "colLabel");
                        columnLabelMap.put(fileIndex, colLabel);
                    }
                }
                NodeList headerLineNodes = tableElement.getElementsByTagName("headerLine");
                ArrayList<String> headerLines = null;
                if (headerLineNodes.getLength() > 0) {
                    headerLines = new ArrayList<String>(headerLineNodes.getLength());
                    for (int hl = 0; hl < headerLineNodes.getLength(); ++hl) {
                        Node child = headerLineNodes.item(hl);
                        headerLines.add(child.getTextContent().trim());
                    }
                }
                DBTable table = new DBTable(dbLocator, tableName, format, binColName, chromoColName, posStartColName, posEndColName, startColIndex, endColIndex, columnLabelMap, baseQuery, headerLines);
                tableList.add(table);
            }
            ArrayList<DBTable> arrayList = tableList;
            return arrayList;
        }
        catch (Exception e) {
            String msg = "Error reading profile " + profilePath + ", table " + tableName;
            MessageUtils.showErrorMessage(msg, e);
            List<DBTable> list = null;
            return list;
        }
        finally {
            try {
                if (profileStream != null) {
                    ((InputStream)profileStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ResourceLocator createDBLocator(Document document) {
        Node db = document.getElementsByTagName("database").item(0);
        NamedNodeMap attr = db.getAttributes();
        String host = attr.getNamedItem("host").getTextContent();
        String path = attr.getNamedItem("path").getTextContent();
        String subprotocol = attr.getNamedItem("subprotocol").getTextContent();
        String port = Utilities.getNullSafe(attr, "port");
        String username = Utilities.getNullSafe(attr, "username");
        String password = Utilities.getNullSafe(attr, "password");
        ResourceLocator locator = new ResourceLocator(DBManager.createConnectionURL(subprotocol, host, path, port));
        locator.setUsername(username);
        locator.setPassword(password);
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceLocator createDBLocator(String profilePath) {
        FileInputStream profileStream = null;
        try {
            profileStream = new FileInputStream(profilePath);
            Document document = Utilities.createDOMDocumentFromXmlStream(profileStream);
            ResourceLocator resourceLocator = DBTable.createDBLocator(document);
            return resourceLocator;
        }
        catch (Exception e) {
            log.error("Error creating DB Locator", e);
            ResourceLocator resourceLocator = null;
            return resourceLocator;
        }
        finally {
            try {
                if (profileStream != null) {
                    ((InputStream)profileStream).close();
                }
            }
            catch (IOException e) {
                log.error("Error closing profile stream", e);
            }
        }
    }

    public static DBTable build(ResourceLocator dbLocator, String tableName) {
        return new DBTable(dbLocator, tableName, null, null, null, null, null, 1, 0x7FFFFFFE, null, null, null);
    }

    public DBTable(ResourceLocator dbLocator, String tableName, String format, String binColName, String chromoColName, String posStartColName, String posEndColName, int startColIndex, int endColIndex, Map<Integer, String> columnLabelMap, String baseQuery, List<String> headerLines) {
        this.dbLocator = dbLocator;
        this.tableName = tableName;
        this.format = format;
        this.binColName = binColName;
        this.chromoColName = chromoColName;
        this.posStartColName = posStartColName;
        this.posEndColName = posEndColName;
        this.startColIndex = startColIndex;
        this.endColIndex = endColIndex;
        this.columnLabelMap = columnLabelMap;
        this.baseQuery = baseQuery;
        this.headerLines = headerLines;
    }

    public ResourceLocator getDbLocator() {
        return this.dbLocator;
    }

    public String getBinColName() {
        return this.binColName;
    }

    public String getChromoColName() {
        return this.chromoColName;
    }

    public int getEndColIndex() {
        return this.endColIndex;
    }

    public String getFormat() {
        return this.format;
    }

    public String getPosEndColName() {
        return this.posEndColName;
    }

    public String getPosStartColName() {
        return this.posStartColName;
    }

    public int getStartColIndex() {
        return this.startColIndex;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public Map<Integer, String> getColumnLabelMap() {
        return this.columnLabelMap;
    }

    public List<String> getHeaderLines() {
        return this.headerLines;
    }

    public static String[] columnMapToArray(Map<Integer, String> columnLabelMap) {
        ArrayList<Integer> arrayIndexes = new ArrayList<Integer>(columnLabelMap.keySet());
        Collections.sort(arrayIndexes);
        int minArrayIndex = (Integer)arrayIndexes.get(0);
        int maxArrayIndex = (Integer)arrayIndexes.get(arrayIndexes.size() - 1);
        int colCount = maxArrayIndex + 1;
        String[] tokens = new String[colCount];
        for (int cc = minArrayIndex; cc < maxArrayIndex; ++cc) {
            tokens[cc] = columnLabelMap.get(cc);
        }
        return tokens;
    }
}

