/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventObserver;

public class IGVEventBus {
    final Map<Class<?>, Set<IGVEventObserver>> observerMap = new HashMap();
    private static IGVEventBus instance;

    public static synchronized IGVEventBus getInstance() {
        if (instance == null) {
            instance = new IGVEventBus();
        }
        return instance;
    }

    public synchronized void subscribe(Class<?> eventClass, IGVEventObserver observer) {
        Set observerSet = this.observerMap.computeIfAbsent(eventClass, k -> Collections.newSetFromMap(new WeakHashMap()));
        observerSet.add(observer);
    }

    public synchronized void unsubscribe(IGVEventObserver observer) {
        for (Set<IGVEventObserver> observerSet : this.observerMap.values()) {
            observerSet.remove(observer);
        }
    }

    public void post(IGVEvent event) {
        Set<IGVEventObserver> observerSet = this.observerMap.get(event.getClass());
        if (observerSet != null) {
            ArrayList<IGVEventObserver> observers = new ArrayList<IGVEventObserver>(observerSet);
            for (IGVEventObserver observer : observers) {
                observer.receiveEvent(event);
            }
        }
    }
}

