/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.prefs;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesChangeEvent;
import org.broad.igv.prefs.PreferencesEditor;
import org.broad.igv.util.ParsingUtils;

public class PreferencesManager
implements IGVEventObserver {
    public static final String SEPARATOR_KEY = "---";
    public static final String INFO_KEY = "info";
    private static List<PreferenceGroup> preferenceGroupList;
    private static Logger log;
    private static Map<String, IGVPreferences> preferencesMap;
    private static Map<String, String> genericDefaults;
    private static String prefFile;
    static Hashtable<String, String> aliasTable;
    private static PreferencesManager theInstance;

    private PreferencesManager() {
    }

    public static IGVPreferences getPreferences(String category) {
        if (preferenceGroupList == null) {
            PreferencesManager.init();
        }
        if (preferencesMap.containsKey(category)) {
            return preferencesMap.get(category);
        }
        return preferencesMap.get("NULL");
    }

    private static void init() {
        try {
            preferenceGroupList = PreferencesManager.loadPreferenceList();
            HashMap<String, Map<String, String>> defaultPreferences = new HashMap<String, Map<String, String>>();
            Map<String, String> nullCategory = PreferencesManager.loadDefaults23();
            if (!nullCategory.containsKey("FONT_SCALE_FACTOR") || nullCategory.get("FONT_SCALE_FACTOR").equals("1")) {
                try {
                    double resolutionScale = Math.max(1.0, (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0);
                    nullCategory.put("FONT_SCALE_FACTOR", String.valueOf((float)resolutionScale));
                }
                catch (Exception e) {
                    log.error("Error overriding font scale factor", e);
                }
            }
            defaultPreferences.put("NULL", nullCategory);
            defaultPreferences.put("RNA", new HashMap());
            defaultPreferences.put("THIRD_GEN", new HashMap());
            for (PreferenceGroup group : preferenceGroupList) {
                String category = group.category == null ? "NULL" : group.category;
                Map defs = (Map)defaultPreferences.get(category);
                if (defs == null) {
                    log.warn("Unknown preference category: " + category);
                }
                for (Preference pref : group.preferences) {
                    defs.put(pref.getKey(), pref.getDefaultValue());
                }
            }
            genericDefaults = (Map)defaultPreferences.get("NULL");
            Map rnaDefaults = (Map)defaultPreferences.get("RNA");
            Map thirdGenDefaults = (Map)defaultPreferences.get("THIRD_GEN");
            Map<String, Map<String, String>> userPrefs = PreferencesManager.loadUserPreferences();
            IGVPreferences nullPrefs = new IGVPreferences(userPrefs.get("NULL"), genericDefaults, null);
            PreferencesManager.extractMutationColors(nullPrefs);
            preferencesMap.put("NULL", nullPrefs);
            preferencesMap.put("RNA", new IGVPreferences(userPrefs.get("RNA"), rnaDefaults, nullPrefs));
            preferencesMap.put("THIRD_GEN", new IGVPreferences(userPrefs.get("THIRD_GEN"), thirdGenDefaults, nullPrefs));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IGVEventBus.getInstance().subscribe(PreferencesChangeEvent.class, theInstance);
    }

    private static void extractMutationColors(IGVPreferences prefs) {
        String cts = prefs.get("MUTATION_COLOR_TABLE");
        if (cts != null) {
            String[] tokens;
            for (String t : tokens = cts.split(";")) {
                String[] kv = t.split("=");
                if (kv.length != 2) continue;
                String key = IGVPreferences.getMutationColorKey(kv[0]);
                prefs.put(key, kv[1]);
            }
            prefs.remove("MUTATION_COLOR_TABLE");
        }
    }

    public static String getDefault(String key) {
        return genericDefaults.get(key);
    }

    public static IGVPreferences getPreferences() {
        return PreferencesManager.getPreferences("NULL");
    }

    public static Collection<IGVPreferences> getAllPreferences() {
        return preferencesMap.values();
    }

    public static void setPrefsFile(String prefsFile) {
        prefFile = prefsFile;
    }

    private static Map<String, Map<String, String>> loadUserPreferences() {
        try {
            if (prefFile == null) {
                prefFile = DirectoryManager.getPreferencesFile().getAbsolutePath();
            }
            return PreferencesManager.load(prefFile);
        }
        catch (Exception e) {
            log.error("Error loading preferences file: " + prefFile, e);
            return null;
        }
    }

    public static void updateAll(Map<String, Map<String, String>> preferenceMap) {
        for (Map.Entry<String, Map<String, String>> entry : preferenceMap.entrySet()) {
            IGVPreferences preferences = PreferencesManager.getPreferences(entry.getKey());
            if (preferences == null) continue;
            preferences.putAll(entry.getValue());
        }
    }

    public static void loadOverrides(String overridePropertyFilePath) {
        if (preferencesMap.get("NULL") == null) {
            PreferencesManager.loadUserPreferences();
        }
        Map<String, Map<String, String>> overrides = PreferencesManager.load(overridePropertyFilePath);
        for (Map.Entry<String, Map<String, String>> entry : overrides.entrySet()) {
            IGVPreferences prefs = preferencesMap.containsKey(entry.getKey()) ? preferencesMap.get(entry.getKey()) : preferencesMap.get("NULL");
            prefs.addOverrides(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, String>> load(String prefFileName) {
        HashMap<String, Map<String, String>> prefMap = new HashMap<String, Map<String, String>>();
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(prefFileName);
            String nextLine = null;
            String category = "NULL";
            while ((nextLine = reader.readLine()) != null) {
                int idx;
                if (nextLine.startsWith("##")) {
                    category = nextLine.substring(2).trim();
                    continue;
                }
                Map<String, String> prefs = (Map<String, String>)prefMap.get(category);
                if (prefs == null) {
                    prefs = Collections.synchronizedMap(new HashMap());
                    prefMap.put(category, prefs);
                }
                if ((idx = nextLine.indexOf(61)) <= 0) continue;
                KeyValue kv = PreferencesManager.translate(nextLine.substring(0, idx), nextLine.substring(idx + 1));
                prefs.put(kv.key, kv.value);
            }
        }
        catch (IOException e) {
            log.warn("Error loading preferences " + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                log.error("Error closing preferences file", ex);
            }
        }
        return prefMap;
    }

    private static KeyValue translate(String key, String value) {
        if (aliasTable.containsKey(key)) {
            key = aliasTable.get(key);
        } else if (key.equals("SAM.SHADE_BASE_QUALITY")) {
            boolean b = value.equalsIgnoreCase("quality") || value.equalsIgnoreCase("true");
            value = String.valueOf(b);
        }
        return new KeyValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PreferenceGroup> loadPreferenceList() throws IOException {
        ArrayList<PreferenceGroup> groupList = new ArrayList<PreferenceGroup>();
        ArrayList<Preference> prefList = null;
        String group = null;
        try (BufferedReader reader = null;){
            String nextLine;
            reader = new BufferedReader(new InputStreamReader(PreferencesEditor.class.getResourceAsStream("/org/broad/igv/prefs/preferences.tab")));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if ((nextLine = nextLine.trim()).startsWith("//") || nextLine.length() == 0) continue;
                if (nextLine.startsWith(SEPARATOR_KEY)) {
                    prefList.add(new Preference(SEPARATOR_KEY, group));
                    continue;
                }
                if (nextLine.startsWith(INFO_KEY)) {
                    Preference preference = new Preference(INFO_KEY, nextLine.substring(INFO_KEY.length()).trim(), group);
                    prefList.add(preference);
                    continue;
                }
                if (nextLine.startsWith("##")) {
                    group = null;
                    if (nextLine.length() <= 2) continue;
                    group = nextLine.substring(2);
                    continue;
                }
                if (nextLine.startsWith("#")) {
                    tokens = Globals.tabPattern.split(nextLine);
                    String tabLabel = tokens[0].substring(1);
                    String category = tokens.length > 1 ? tokens[1] : null;
                    prefList = new ArrayList<Preference>();
                    PreferenceGroup preferenceGroup = new PreferenceGroup(tabLabel, category, prefList);
                    groupList.add(preferenceGroup);
                    group = null;
                    continue;
                }
                tokens = Globals.tabPattern.split(nextLine);
                if (tokens.length < 3) {
                    if (tokens.length != 2) continue;
                    tokens = new String[]{tokens[0], "", "", tokens[1]};
                    prefList.add(new Preference(tokens, group));
                    continue;
                }
                prefList.add(new Preference(tokens, group));
            }
        }
        return groupList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadDefaults23() throws IOException {
        HashMap<String, String> defs = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            String nextLine;
            reader = new BufferedReader(new InputStreamReader(PreferencesEditor.class.getResourceAsStream("/org/broad/igv/prefs/defaults_2.3.tab")));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = Globals.tabPattern.split(nextLine);
                if (tokens.length != 2) continue;
                defs.put(tokens[0], tokens[1]);
            }
        }
        return defs;
    }

    public static void setOverride(String prefKey, String prefVal) {
        if (preferenceGroupList == null) {
            PreferencesManager.init();
        }
        for (IGVPreferences prefs : preferencesMap.values()) {
            prefs.override(prefKey, prefVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storePreferences() {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(prefFile);
            PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
            for (Map.Entry<String, IGVPreferences> entry : preferencesMap.entrySet()) {
                if (!entry.getKey().equals("NULL")) {
                    pw.println();
                    pw.println("##" + entry.getKey());
                }
                entry.getValue().print(pw);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            log.error("Error loading preferences", e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof PreferencesChangeEvent) {
            this.storePreferences();
        }
    }

    static {
        log = LogManager.getLogger(PreferencesManager.class);
        preferencesMap = Collections.synchronizedMap(new HashMap());
        aliasTable = new Hashtable();
        aliasTable.put("SAM>SORT_OPTION", "SAM.SORT_OPTION");
        aliasTable.put("FLAKING_REGIONS", "FLANKING_REGION");
        theInstance = new PreferencesManager();
    }

    static class PreferenceGroup {
        String tabLabel;
        String category;
        List<Preference> preferences;

        public PreferenceGroup(String tabLabel, String category, List<Preference> preferences) {
            this.tabLabel = tabLabel;
            this.category = category;
            this.preferences = preferences;
        }
    }

    static class Preference {
        String group;
        String[] tokens;

        Preference(String[] tokens, String group) {
            this.tokens = tokens;
            this.group = group;
        }

        Preference(String key, String group) {
            this(new String[]{key, null, null, null}, group);
        }

        Preference(String key, String label, String group) {
            this(new String[]{key, label, null, null}, group);
        }

        String getKey() {
            return this.tokens[0];
        }

        String getLabel() {
            return this.tokens[1];
        }

        String getType() {
            return this.tokens[2];
        }

        String getDefaultValue() {
            return this.tokens.length < 4 || this.tokens[3] == null || this.tokens[3].equals("null") ? null : this.tokens[3];
        }

        String getComment() {
            return this.tokens.length > 4 ? this.tokens[4] : null;
        }

        String getGroup() {
            return this.group;
        }

        String printString() {
            String str = this.getKey() + "\t" + this.getLabel() + "\t" + this.getType() + "\t" + this.getDefaultValue();
            if (this.getComment() != null) {
                str = str + "\t" + this.getComment();
            }
            return str;
        }
    }

    static class KeyValue {
        String key;
        String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

