/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.twobit;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.SequenceNotFoundException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ucsc.BPIndex;
import org.broad.igv.ucsc.BPTree;
import org.broad.igv.ucsc.twobit.Block;
import org.broad.igv.ucsc.twobit.SequenceRecord;
import org.broad.igv.ucsc.twobit.TwoBitIndex;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;

public class TwoBitSequence
implements Sequence {
    private static Logger log;
    static int SIGNATURE;
    String path;
    private HashMap<String, SequenceRecord> sequenceRecordCache;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private int seqCount;
    BPIndex index;
    static byte[] twoBit;
    static byte[][] byteTo4Bases;
    static byte[][] maskedByteTo4Bases;

    public TwoBitSequence(String path) throws IOException {
        this.init(path);
        this.index = new TwoBitIndex(path, this.byteOrder, this.seqCount);
    }

    public TwoBitSequence(String path, String indexPath) throws IOException {
        this.init(path);
        this.index = BPTree.loadBPTree(indexPath, 0L);
    }

    UnsignedByteBuffer loadBinaryBuffer(long start, int size) throws IOException {
        return UnsignedByteBuffer.loadBinaryBuffer(this.path, this.byteOrder, start, size);
    }

    private void init(String path) throws IOException {
        this.path = path;
        this.sequenceRecordCache = new HashMap();
        long filePosition = 0L;
        UnsignedByteBuffer buffer = UnsignedByteBuffer.loadBinaryBuffer(path, this.byteOrder, filePosition, 64);
        int signature = buffer.getInt();
        if (SIGNATURE != signature) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            buffer.position(0);
            signature = buffer.getInt();
            if (SIGNATURE != signature) {
                throw new RuntimeException("Unexpected magic number");
            }
        }
        int version = buffer.getInt();
        this.seqCount = buffer.getInt();
        int reserved = buffer.getInt();
    }

    @Override
    public byte[] getSequence(String chr, int start, int end) {
        return this.readSequence(chr, start, end);
    }

    @Override
    public byte getBase(String chr, int position) {
        throw new RuntimeException("getBase is not implementd for TwoBitSequence");
    }

    @Override
    public List<String> getChromosomeNames() {
        return null;
    }

    @Override
    public int getChromosomeLength(String seq) {
        try {
            SequenceRecord sequenceRecord = this.getSequenceRecord(seq);
            return sequenceRecord.getDnaSize();
        }
        catch (SequenceNotFoundException e) {
            return -1;
        }
        catch (IOException e) {
            log.error("Error reading sequence " + seq, e);
            return -1;
        }
    }

    @Override
    public List<Chromosome> getChromosomes() {
        return null;
    }

    @Override
    public boolean hasChromosomes() {
        return false;
    }

    public byte[] readSequence(String seqName, int regionStart, int regionEnd) {
        try {
            SequenceRecord record = this.getSequenceRecord(seqName);
            if (record == null) {
                return null;
            }
            if (regionStart < 0) {
                throw new RuntimeException("regionStart cannot be less than 0");
            }
            Queue<Block> nBlocks = TwoBitSequence._getOverlappingBlocks(regionStart, regionEnd, record.nBlocks);
            Queue<Block> maskBlocks = TwoBitSequence._getOverlappingBlocks(regionStart, regionEnd, record.maskBlocks);
            int baseBytesOffset = regionStart / 4;
            long start = record.packedPos + (long)baseBytesOffset;
            int size = regionEnd / 4 - baseBytesOffset + 1;
            UnsignedByteBuffer buffer = this.loadBinaryBuffer(start, size);
            byte[] baseBytes = buffer.array();
            byte[] sequenceBases = new byte[regionEnd - regionStart];
            for (int genomicPosition = regionStart; genomicPosition < regionEnd; ++genomicPosition) {
                while (maskBlocks.size() > 0 && maskBlocks.peek().end <= (long)genomicPosition) {
                    maskBlocks.remove();
                }
                Block mBlock = maskBlocks.peek();
                boolean baseIsMaked = mBlock != null && mBlock.start <= (long)genomicPosition && mBlock.end > (long)genomicPosition;
                Block firstBlock = nBlocks.peek();
                if (firstBlock != null && (long)genomicPosition >= firstBlock.start && (long)genomicPosition < firstBlock.end) {
                    Block currentNBlock = nBlocks.remove();
                    while ((long)genomicPosition < currentNBlock.end && genomicPosition < regionEnd) {
                        sequenceBases[genomicPosition - regionStart] = 78;
                        ++genomicPosition;
                    }
                    --genomicPosition;
                    continue;
                }
                int bytePosition = genomicPosition / 4 - baseBytesOffset;
                int subPosition = genomicPosition % 4;
                int s = Byte.toUnsignedInt(baseBytes[bytePosition]);
                int idx = genomicPosition - regionStart;
                sequenceBases[idx] = baseIsMaked ? maskedByteTo4Bases[s][subPosition] : byteTo4Bases[s][subPosition];
            }
            return sequenceBases;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SequenceRecord getSequenceRecord(String seqName) throws IOException {
        SequenceRecord record = this.sequenceRecordCache.get(seqName);
        if (record == null) {
            long[] offset_length = this.index.search(seqName);
            if (offset_length == null) {
                throw new SequenceNotFoundException("Unknown sequence: " + seqName);
            }
            long offset = offset_length[0];
            int size = 8;
            UnsignedByteBuffer buffer = this.loadBinaryBuffer(offset, size);
            int dnaSize = buffer.getInt();
            int nBlockCount = buffer.getInt();
            offset += (long)size;
            size = nBlockCount * 8 + 4;
            buffer = this.loadBinaryBuffer(offset, size);
            int[] nBlockStarts = new int[nBlockCount];
            for (int i = 0; i < nBlockCount; ++i) {
                nBlockStarts[i] = buffer.getInt();
            }
            int[] nBlockSizes = new int[nBlockCount];
            for (int i = 0; i < nBlockCount; ++i) {
                nBlockSizes[i] = buffer.getInt();
            }
            int maskBlockCount = buffer.getInt();
            offset += (long)size;
            size = maskBlockCount * 8 + 4;
            buffer = this.loadBinaryBuffer(offset, size);
            int[] maskBlockStarts = new int[maskBlockCount];
            for (int i = 0; i < maskBlockCount; ++i) {
                maskBlockStarts[i] = buffer.getInt();
            }
            int[] maskBlockSizes = new int[maskBlockCount];
            for (int i = 0; i < maskBlockCount; ++i) {
                maskBlockSizes[i] = buffer.getInt();
            }
            Block[] nBlocks = new Block[nBlockCount];
            for (int i = 0; i < nBlockCount; ++i) {
                nBlocks[i] = new Block(nBlockStarts[i], nBlockSizes[i]);
            }
            Block[] maskBlocks = new Block[maskBlockCount];
            for (int i = 0; i < maskBlockCount; ++i) {
                maskBlocks[i] = new Block(maskBlockStarts[i], maskBlockSizes[i]);
            }
            int reserved = buffer.getInt();
            if (reserved != 0) {
                throw new RuntimeException("Bad 2-bit file");
            }
            long packedPos = offset + (long)size;
            record = new SequenceRecord(dnaSize, nBlocks, maskBlocks, packedPos);
            this.sequenceRecordCache.put(seqName, record);
        }
        return record;
    }

    static Queue<Block> _getOverlappingBlocks(long start, long end, Block[] blocks) {
        LinkedList<Block> overlappingBlocks = new LinkedList<Block>();
        for (Block block : blocks) {
            if (block.start > end) break;
            if (block.end < start) continue;
            overlappingBlocks.add(block);
        }
        return overlappingBlocks;
    }

    static {
        int i;
        log = LogManager.getLogger(TwoBitSequence.class);
        SIGNATURE = 440477507;
        twoBit = new byte[]{84, 67, 65, 71};
        byteTo4Bases = new byte[256][4];
        maskedByteTo4Bases = new byte[256][4];
        for (i = 0; i < 256; ++i) {
            TwoBitSequence.byteTo4Bases[i] = new byte[]{twoBit[i >> 6 & 3], twoBit[i >> 4 & 3], twoBit[i >> 2 & 3], twoBit[i & 3]};
        }
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 4; ++j) {
                TwoBitSequence.maskedByteTo4Bases[i][j] = (byte)Character.toLowerCase(byteTo4Bases[i][j]);
            }
        }
    }
}

