/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.common.primitives.Ints;
import htsjdk.samtools.util.Locatable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.BaseRenderer;
import org.broad.igv.sam.BisulfiteBaseInfo;
import org.broad.igv.sam.BisulfiteBaseInfoNOMeseq;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.ClippingCounts;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SupplementaryAlignment;
import org.broad.igv.sam.mods.BaseModificationRenderer;
import org.broad.igv.sam.smrt.SMRTKineticsRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.GreyscaleColorTable;
import org.broad.igv.ui.color.HSLColorTable;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ultima.render.ColorByTagValueList;
import org.broad.igv.ultima.render.FlowIndelRendering;
import org.broad.igv.util.ChromosomeColors;

public class AlignmentRenderer {
    private static final Logger log = LogManager.getLogger(AlignmentRenderer.class);
    private static final Color negStrandColor = new Color(150, 150, 230);
    private static final Color posStrandColor = new Color(230, 150, 150);
    private static final Color firstOfPairColor = new Color(150, 150, 230);
    private static final Color secondOfPairColor = new Color(230, 150, 150);
    private static final Color firstAndSecondofPairColor = new Color(150, 150, 0);
    private static final Color neitherForOrSecondOfPair = new Color(198, 106, 245, 255);
    private static final Color RL_COLOR = new Color(0, 150, 0);
    private static final Color RR_COLOR = new Color(20, 50, 200);
    private static final Color LL_COLOR = new Color(0, 150, 150);
    private static final Color smallISizeColor = new Color(0, 0, 150);
    private static final Color largeISizeColor = new Color(200, 0, 0);
    private static final Color OUTLINE_COLOR = new Color(185, 185, 185);
    private static final Color INVERSION_COLOR = new Color(200, 0, 0);
    private static final Color NON_INVERSION_COLOR = new Color(230, 150, 150);
    private static final Color clippedColor = new Color(255, 20, 147);
    public static Color purple = new Color(118, 24, 220);
    public static Color deletionColor = Color.black;
    private static Color skippedColor = new Color(150, 184, 200);
    private static Color unknownGapColor = new Color(0, 150, 0);
    private static final Color bisulfiteColorFw1 = new Color(195, 195, 195);
    private static final Color bisulfiteColorRev1 = new Color(195, 210, 195);
    private static final Color nomeseqColor = new Color(195, 195, 195);
    private static Map<String, AlignmentTrack.OrientationType> frOrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f1f2OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f2f1OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> rfOrientationTypes;
    private static Map<AlignmentTrack.OrientationType, Color> typeToColorMap;
    public static final HSLColorTable tenXColorTable1;
    public static final HSLColorTable tenXColorTable2;
    public static final GreyscaleColorTable tenXColorTable3;
    public static final Color GROUP_DIVIDER_COLOR;
    private static final byte[] softClippedReference;
    private static ColorTable readGroupColors;
    private static ColorTable sampleColors;
    private static ColorTable movieColors;
    private static ColorTable zmwColors;
    private static Map<String, ColorTable> tagValueColors;
    private static ColorTable defaultTagColors;
    public static HashMap<Character, Color> nucleotideColors;
    private static final ColorByTagValueList colorByTagValueList;
    private static final FlowIndelRendering flowIndelRendering;
    AlignmentTrack track;

    private static void initializeTagTypes() {
        frOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        frOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F R ", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("FR", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F F ", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("FF", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R R ", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("RR", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R F ", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("RF", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        rfOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R R ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("RR ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F F ", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("FF", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F R ", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("FR", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f2f1OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f1f2OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RL);
    }

    private static void initializeTagColors() {
        ColorPalette palette = ColorUtilities.getPalette("Pastel 1");
        readGroupColors = new PaletteColorTable(palette);
        sampleColors = new PaletteColorTable(palette);
        movieColors = new PaletteColorTable(palette);
        zmwColors = new PaletteColorTable(palette);
        defaultTagColors = new PaletteColorTable(palette);
        tagValueColors = new HashMap<String, ColorTable>();
        typeToColorMap = new HashMap<AlignmentTrack.OrientationType, Color>(5);
        typeToColorMap.put(AlignmentTrack.OrientationType.LL, LL_COLOR);
        typeToColorMap.put(AlignmentTrack.OrientationType.RL, RL_COLOR);
        typeToColorMap.put(AlignmentTrack.OrientationType.RR, RR_COLOR);
    }

    private static void setNucleotideColors() {
        IGVPreferences prefs = PreferencesManager.getPreferences();
        nucleotideColors = new HashMap();
        Color a = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.A"), Color.green);
        Color c = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.C"), Color.blue);
        Color t = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.T"), Color.red);
        Color g = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.G"), new Color(209, 113, 5));
        Color n = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.N"), new Color(64, 64, 64));
        nucleotideColors.put(Character.valueOf('A'), a);
        nucleotideColors.put(Character.valueOf('a'), a);
        nucleotideColors.put(Character.valueOf('C'), c);
        nucleotideColors.put(Character.valueOf('c'), c);
        nucleotideColors.put(Character.valueOf('T'), t);
        nucleotideColors.put(Character.valueOf('t'), t);
        nucleotideColors.put(Character.valueOf('G'), g);
        nucleotideColors.put(Character.valueOf('g'), g);
        nucleotideColors.put(Character.valueOf('N'), n);
        nucleotideColors.put(Character.valueOf('n'), n);
        nucleotideColors.put(Character.valueOf('-'), Color.lightGray);
    }

    public AlignmentRenderer(AlignmentTrack track) {
        this.track = track;
    }

    private void initializeGraphics(RenderContext context) {
        Font font = FontManager.getFont(10);
        Graphics2D g1 = context.getGraphics2D("ALIGNMENT");
        float alpha = 0.75f;
        int type = 3;
        AlphaComposite alignmentAlphaComposite = AlphaComposite.getInstance(type, alpha);
        g1.setComposite(alignmentAlphaComposite);
        g1.setFont(font);
        Graphics2D g2 = context.getGraphics2D("LINK_LINE");
        alpha = 0.3f;
        alignmentAlphaComposite = AlphaComposite.getInstance(type, alpha);
        g2.setComposite(alignmentAlphaComposite);
        Graphics2D g3 = context.getGraphics2D("THICK_STROKE");
        g3.setStroke(new BasicStroke(2.0f));
        Graphics2D g4 = context.getGraphics2D("STRAND");
        g4.setColor(Color.DARK_GRAY);
        Graphics2D g5 = context.getGraphics2D("SOFT_CLIP");
        g5.setColor(Color.BLACK);
        Graphics2D g6 = context.getGraphics2D("MISMATCH");
        g6.setColor(Color.RED);
    }

    public void renderAlignments(List<Alignment> alignments, AlignmentCounts alignmentCounts, RenderContext context, Rectangle rowRect, AlignmentTrack.RenderOptions renderOptions) {
        this.initializeGraphics(context);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color defaultColor = this.track.getColor();
        if (alignments != null && alignments.size() > 0) {
            int lastPixelDrawn = -1;
            for (Alignment alignment : alignments) {
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (pixelEnd < (double)rowRect.x || pixelStart > rowRect.getMaxX()) continue;
                double pixelWidth = pixelEnd - pixelStart;
                Color alignmentColor = this.getAlignmentColor(alignment, this.track);
                boolean leaveMargin = this.track.getDisplayMode() != Track.DisplayMode.SQUISHED;
                AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
                if (!(!(pixelWidth < 2.0) || (AlignmentTrack.isBisulfiteColorType(colorOption) || colorOption.isBaseMod() || colorOption.isSMRTKinetics()) && pixelWidth >= 1.0)) {
                    if (pixelEnd <= (double)lastPixelDrawn && alignmentColor == defaultColor) continue;
                    Graphics2D g = context.getGraphics2D("ALIGNMENT");
                    g.setColor(alignmentColor);
                    int w = Math.max(1, (int)pixelWidth);
                    int h = (int)Math.max(1.0, rowRect.getHeight() - 2.0);
                    int y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h) / 2.0);
                    g.fillRect((int)pixelStart, y, w, h);
                    lastPixelDrawn = (int)pixelStart + w;
                    continue;
                }
                if (alignment instanceof PairedAlignment) {
                    this.drawPairedAlignment((PairedAlignment)alignment, rowRect, context, renderOptions, leaveMargin, alignmentCounts);
                    continue;
                }
                if (alignment instanceof LinkedAlignment) {
                    this.drawLinkedAlignment((LinkedAlignment)alignment, rowRect, context, renderOptions, leaveMargin, alignmentCounts);
                    continue;
                }
                this.drawAlignment(alignment, rowRect, context, alignmentColor, renderOptions, leaveMargin, alignmentCounts, false);
            }
            IGVPreferences prefs = this.track.getPreferences();
            boolean showCenterLine = prefs.getAsBoolean("SAM.SHOW_CENTER_LINE");
            int bottom = rowRect.y + rowRect.height;
            if (showCenterLine) {
                double center = (int)(context.getReferenceFrame().getCenter() - origin);
                int centerLeftP = (int)(center / locScale);
                int centerRightP = (int)((center + 1.0) / locScale);
                Graphics2D g = context.getGraphics();
                g.setColor(Color.black);
                GraphicUtils.drawDottedDashLine(g, centerLeftP, rowRect.y, centerLeftP, bottom);
                if (centerRightP - centerLeftP > 2) {
                    GraphicUtils.drawDottedDashLine(g, centerRightP, rowRect.y, centerRightP, bottom);
                }
            }
        }
    }

    private void drawLinkedAlignment(LinkedAlignment alignment, Rectangle rowRect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color alignmentColor = this.getAlignmentColor(alignment, this.track);
        List<Alignment> barcodedAlignments = alignment.alignments;
        if (barcodedAlignments.size() > 0) {
            boolean mixedStrand = alignment.getStrand() == Strand.NONE;
            Alignment firstAlignment = barcodedAlignments.get(0);
            if (barcodedAlignments.size() > 1) {
                Graphics2D gline = context.getGraphics2D("LINK_LINE");
                gline.setColor(alignmentColor);
                int startX = (int)(((double)firstAlignment.getEnd() - origin) / locScale);
                int endX = (int)(((double)barcodedAlignments.get(barcodedAlignments.size() - 1).getStart() - origin) / locScale);
                int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
                int y = (int)rowRect.getY();
                startX = Math.max(rowRect.x, startX);
                endX = Math.min(rowRect.x + rowRect.width, endX);
                gline.drawLine(startX, y + h / 2, endX, y + h / 2);
            }
            for (int i = 0; i < barcodedAlignments.size(); ++i) {
                boolean overlapped = false;
                Alignment al = barcodedAlignments.get(i);
                if (al.isNegativeStrand()) {
                    if (mixedStrand) {
                        alignmentColor = negStrandColor;
                    }
                    overlapped = i > 0 && barcodedAlignments.get(i - 1).getAlignmentEnd() > al.getAlignmentStart();
                } else {
                    if (mixedStrand) {
                        alignmentColor = posStrandColor;
                    }
                    overlapped = i < barcodedAlignments.size() - 1 && al.getAlignmentEnd() > barcodedAlignments.get(i + 1).getAlignmentStart();
                }
                this.drawAlignment(al, rowRect, context, alignmentColor, renderOptions, leaveMargin, alignmentCounts, overlapped);
            }
        }
    }

    private void drawSimpleAlignment(Alignment alignment, Rectangle rect, Graphics2D g, RenderContext context, boolean flagUnmappedPair) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        int x = (int)(((double)alignment.getStart() - origin) / locScale);
        int length = alignment.getEnd() - alignment.getStart();
        int w = (int)Math.ceil((double)length / locScale);
        int h = (int)Math.max(1.0, rect.getHeight() - 2.0);
        int y = (int)(rect.getY() + (rect.getHeight() - (double)h) / 2.0);
        int arrowLength = Math.min(5, w / 6);
        int d = Math.max(0, (int)((double)(arrowLength + 2) - 2.0 / context.getScale()));
        if (alignment.isNegativeStrand()) {
            x += d;
        }
        if (!alignment.isNegativeStrand()) {
            w -= d;
        }
        int[] xPoly = null;
        int[] yPoly = new int[]{y, y, y + h / 2, y + h, y + h};
        if (x < rect.x && x + w > rect.x + rect.width) {
            x = rect.x;
            w = rect.width;
            arrowLength = 0;
        } else if (x < rect.x) {
            int delta = rect.x - x;
            x = rect.x;
            w -= delta;
            if (alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        } else if (x + w > rect.x + rect.width) {
            w -= x + w - (rect.x + rect.width);
            if (!alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        }
        xPoly = alignment.isNegativeStrand() ? new int[]{x + w, x, x - arrowLength, x, x + w} : new int[]{x, x + w, x + w + arrowLength, x + w, x};
        g.fillPolygon(xPoly, yPoly, xPoly.length);
        if (flagUnmappedPair && alignment.isPaired() && !alignment.getMate().isMapped()) {
            g.setColor(Color.red);
            g.drawPolygon(xPoly, yPoly, xPoly.length);
        }
    }

    private void drawPairedAlignment(PairedAlignment pair, Rectangle rowRect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts) {
        double locScale = context.getScale();
        Color alignmentColor1 = this.getAlignmentColor(pair.firstAlignment, this.track);
        Color alignmentColor2 = null;
        boolean overlapped = pair.secondAlignment != null && pair.firstAlignment.getChr().equals(pair.secondAlignment.getChr()) && pair.firstAlignment.getAlignmentEnd() > pair.secondAlignment.getAlignmentStart();
        Graphics2D g = context.getGraphics2D("ALIGNMENT");
        g.setColor(alignmentColor1);
        this.drawAlignment(pair.firstAlignment, rowRect, context, alignmentColor1, renderOptions, leaveMargin, alignmentCounts, overlapped);
        if (pair.secondAlignment != null) {
            if (alignmentColor2 == null) {
                alignmentColor2 = this.getAlignmentColor(pair.secondAlignment, this.track);
            }
        } else {
            return;
        }
        g.setColor(alignmentColor2);
        this.drawAlignment(pair.secondAlignment, rowRect, context, alignmentColor2, renderOptions, leaveMargin, alignmentCounts, overlapped);
        Color lineColor = this.track.getColor();
        if (alignmentColor1.equals(alignmentColor2) || pair.secondAlignment == null) {
            lineColor = alignmentColor1;
        }
        g.setColor(lineColor);
        double origin = context.getOrigin();
        int startX = (int)(((double)pair.firstAlignment.getEnd() - origin) / locScale);
        int endX = (int)(((double)pair.firstAlignment.getMate().getStart() - origin) / locScale);
        int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        startX = Math.max(rowRect.x, startX);
        endX = Math.min(rowRect.x + rowRect.width, endX);
        g.drawLine(startX, y + h / 2, endX, y + h / 2);
    }

    private void drawAlignment(Alignment alignment, Rectangle rowRect, RenderContext context, Color alignmentColor, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts, boolean overlapped) {
        AlignmentBlock[] insertions;
        String readName;
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        Graphics2D gAlignment = context.getGraphics2D("ALIGNMENT");
        gAlignment.setColor(alignmentColor);
        if (blocks == null || blocks.length == 0) {
            this.drawSimpleAlignment(alignment, rowRect, gAlignment, context, renderOptions.isFlagUnmappedPairs());
            return;
        }
        IGVPreferences prefs = this.track.getPreferences();
        boolean flagLargeIndels = prefs.getAsBoolean("SAM.FLAG_LARGE_INDELS");
        int largeInsertionsThreshold = prefs.getAsInt("SAM.LARGE_INSERTIONS_THRESOLD");
        boolean hideSmallIndelsBP = renderOptions.isHideSmallIndels();
        int indelThresholdBP = renderOptions.getSmallIndelThreshold();
        boolean quickConsensus = renderOptions.isQuickConsensusMode();
        float snpThreshold = prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        double locScale = context.getScale();
        int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        Graphics2D clippedGraphics = context.getGraphic2DForColor(clippedColor);
        if (h > 5) {
            clippedGraphics.setStroke(new BasicStroke(1.2f));
        }
        Graphics2D strandGraphics = context.getGraphics2D("STRAND");
        Graphics2D largeIndelGraphics = context.getGraphics2D("INDEL_LABEL");
        largeIndelGraphics.setFont(FontManager.getFont(1, h - 2));
        Graphics2D bpGraphics = context.getGraphics2D("BASE");
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        if (dX >= 8) {
            Font f = FontManager.getFont(1, Math.min(dX, h));
            bpGraphics.setFont(f);
        }
        boolean flagClipping = prefs.getAsBoolean("SAM.FLAG_CLIPPING");
        int clippingThreshold = prefs.getAsInt("SAM.CLIPPING_THRESHOLD");
        ClippingCounts clipping = alignment.getClippingCounts();
        boolean leftClipped = flagClipping && clipping.getLeft() > clippingThreshold;
        boolean rightClipped = flagClipping && clipping.getRight() > clippingThreshold;
        double bpStart = context.getOrigin();
        double bpEnd = Math.ceil(context.getEndLocation());
        List<Gap> gaps = alignment.getGaps();
        if (gaps != null) {
            for (Gap gap : gaps) {
                boolean drawGap;
                int gapStart = gap.getStart();
                int gapWidth = gap.getnBases();
                int gapEnd = gapStart + gapWidth;
                int gapPxStart = (int)((Math.max(bpStart, (double)gapStart) - bpStart) / locScale);
                int gapPxEnd = (int)((Math.min(bpEnd, (double)gapEnd) - bpStart) / locScale);
                if ((double)gapEnd <= bpStart) continue;
                if ((double)gapStart >= bpEnd) break;
                boolean bl = drawGap = !hideSmallIndelsBP || gapWidth >= indelThresholdBP;
                if (!drawGap) continue;
                Graphics2D gapGraphics = context.getGraphics2D("GAP");
                if (gap.getType() == '\u0000') {
                    gapGraphics.setColor(unknownGapColor);
                } else if (gap.getType() == 'N') {
                    gapGraphics.setColor(skippedColor);
                } else {
                    gapGraphics.setColor(deletionColor);
                    if (h > 5) {
                        gapGraphics = context.getGraphics2D("THICK_STROKE");
                    }
                }
                gapGraphics.drawLine(gapPxStart, y + h / 2, gapPxEnd, y + h / 2);
                if (flagLargeIndels && gap.getType() == 'D' && gapWidth > largeInsertionsThreshold) {
                    this.drawLargeIndelLabel(largeIndelGraphics, false, Globals.DECIMAL_FORMAT.format(gapWidth), (gapPxStart + gapPxEnd) / 2, y, h, gapPxEnd - gapPxStart - 2, context.translateX, null, alignment, context);
                }
                if (!flowIndelRendering.handlesAlignment(alignment)) continue;
                flowIndelRendering.renderDeletionGap(alignment, gap, y, h, gapPxStart, gapPxEnd - gapPxStart, context, renderOptions);
            }
        }
        Graphics2D outlineGraphics = null;
        HashMap<String, Color> selectedReadNames = this.track.getSelectedReadNames();
        if (selectedReadNames.containsKey(readName = alignment.getReadName())) {
            Color c = selectedReadNames.get(readName);
            c = c == null ? Color.blue : c;
            outlineGraphics = context.getGraphics2D("THICK_STROKE");
            gAlignment.setColor(c);
        } else if (renderOptions.isFlagUnmappedPairs() && alignment.isPaired() && !alignment.getMate().isMapped()) {
            outlineGraphics = context.getGraphics2D("OUTLINE");
            outlineGraphics.setColor(Color.red);
        } else if (alignment.getMappingQuality() == 0 && renderOptions.isFlagZeroQualityAlignments()) {
            outlineGraphics = context.getGraphic2DForColor(OUTLINE_COLOR);
        }
        double pixelLengthOnReference = (double)alignment.getLengthOnReference() / locScale;
        int arrowPxWidth = pixelLengthOnReference == 0.0 ? 0 : (int)Math.min((double)Math.min(5, h / 2), pixelLengthOnReference / 6.0);
        int blockChromStart = blocks[0].getStart();
        boolean leftmost = true;
        for (int blockIx = 0; blockIx < blocks.length; ++blockIx) {
            boolean rightmost;
            AlignmentBlock block = blocks[blockIx];
            int blockChromEnd = block.getStart() + block.getLength();
            int blockPxStart = (int)Math.round(((double)blockChromStart - bpStart) / locScale);
            int blockPxEnd = (int)Math.round(((double)blockChromEnd - bpStart) / locScale);
            if (blockPxEnd < 0) continue;
            if (blockPxStart > rowRect.x + rowRect.width) break;
            boolean bl = rightmost = blockIx + 1 == blocks.length;
            if (!rightmost) {
                if (hideSmallIndelsBP && blocks[blockIx + 1].getStart() - blockChromEnd < indelThresholdBP) continue;
                blockChromStart = blocks[blockIx + 1].getStart();
            }
            if (h == 1) {
                gAlignment.drawLine(blockPxStart, y, blockPxEnd, y);
            } else {
                int pixelGap;
                if (!overlapped && (pixelGap = (int)(2.0 / locScale)) < arrowPxWidth) {
                    arrowPxWidth = Math.max(0, arrowPxWidth - pixelGap);
                }
                boolean drawArrow = h > 6 && (leftmost && blockPxStart > 0 || rightmost && blockPxEnd < rowRect.x + rowRect.width);
                blockPxStart = Math.max(0, blockPxStart);
                blockPxEnd = Math.min(rowRect.x + rowRect.width, blockPxEnd);
                int[] xPoly = new int[]{blockPxStart - (leftmost && alignment.isNegativeStrand() && drawArrow ? arrowPxWidth : 0), blockPxStart, blockPxEnd, blockPxEnd + (rightmost && !alignment.isNegativeStrand() && drawArrow ? arrowPxWidth : 0), blockPxEnd, blockPxStart};
                int[] yPoly = new int[]{y + h / 2, y, y, y + h / 2, y + h, y + h};
                Polygon blockShape = new Polygon(xPoly, yPoly, xPoly.length);
                Graphics2D g = gAlignment;
                if (!block.hasBases()) {
                    if (block.isSoftClip()) {
                        g = context.getGraphics2D("SOFT_CLIP");
                    } else if (block.getCigarOperator() == 'X') {
                        g = context.getGraphics2D("MISMATCH");
                    }
                }
                g.fill(blockShape);
                if (outlineGraphics != null) {
                    outlineGraphics.draw(blockShape);
                }
                SupplementaryAlignment.SupplementaryNeighbors supplementaryRenderingInfo = SupplementaryAlignment.getAdjacentSupplementaryReads(alignment);
                boolean drawLeftClip = leftmost && leftClipped;
                boolean drawRightClip = rightmost && rightClipped;
                AlignmentRenderer.drawClippedEnds(clippedGraphics, xPoly, yPoly, drawLeftClip, drawRightClip, supplementaryRenderingInfo);
            }
            leftmost = false;
        }
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        if (locScale < 100.0) {
            boolean showAllBases;
            boolean bl = showAllBases = renderOptions.isShowAllBases() && colorOption != AlignmentTrack.ColorOption.BISULFITE && colorOption != AlignmentTrack.ColorOption.NOMESEQ;
            if (renderOptions.isShowMismatches() || showAllBases) {
                block2: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                    byte[] reference;
                    boolean haveBases;
                    boolean bl2 = haveBases = block.hasBases() && block.getLength() > 0;
                    if (!haveBases) continue;
                    String chr = context.getChr();
                    int start = block.getStart();
                    int end = block.getEnd();
                    boolean isSoftClip = block.isSoftClip();
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    byte[] byArray = reference = isSoftClip ? softClippedReference : genome.getSequence(chr, start, end);
                    if (reference == null && !showAllBases) continue;
                    int pY = (int)rowRect.getY();
                    int dY = (int)rowRect.getHeight();
                    dX = (int)Math.max(1.0, 1.0 / locScale);
                    BisulfiteBaseInfo bisinfo = null;
                    boolean nomeseqMode = colorOption.equals((Object)AlignmentTrack.ColorOption.NOMESEQ);
                    boolean bisulfiteMode = AlignmentTrack.isBisulfiteColorType(colorOption);
                    if (nomeseqMode) {
                        bisinfo = new BisulfiteBaseInfoNOMeseq(reference, alignment, block, renderOptions.bisulfiteContext);
                    } else if (bisulfiteMode) {
                        bisinfo = new BisulfiteBaseInfo(reference, alignment, block, renderOptions.bisulfiteContext);
                    }
                    ByteSubarray blockBases = block.getBases();
                    int s = (int)Math.max(Math.floor(bpStart), (double)start);
                    int e = (int)Math.min(Math.ceil(bpEnd), (double)end);
                    for (int loc = s; loc < e; ++loc) {
                        boolean showBase;
                        int idx = loc - start;
                        boolean misMatch = AlignmentUtils.isMisMatch(reference, blockBases, isSoftClip, idx);
                        if (!showAllBases && (bisulfiteMode || !misMatch) && (!bisulfiteMode || BisulfiteBaseInfo.DisplayStatus.NOTHING == bisinfo.getDisplayStatus(idx))) continue;
                        char c = (char)blockBases.getByte(idx);
                        double bisulfiteXaxisShift = bisulfiteMode ? bisinfo.getXaxisShift(idx) : 0.0;
                        int pX = (int)(((double)loc + bisulfiteXaxisShift - bpStart) / locScale);
                        if ((double)pX > rowRect.getMaxX()) continue block2;
                        if ((double)(pX + dX) < rowRect.getX()) continue;
                        Color color = null;
                        color = bisulfiteMode ? bisinfo.getDisplayColor(idx) : (colorOption.isBaseMod() || colorOption.isSMRTKinetics() ? Color.GRAY : nucleotideColors.get(Character.valueOf(c)));
                        if (color == null) {
                            color = Color.black;
                        }
                        if (renderOptions.getShadeBasesOption()) {
                            byte qual = block.getQuality(loc - start);
                            color = BaseRenderer.getShadedColor(color, qual, renderOptions.getBaseQualityMin(), renderOptions.getBaseQualityMax());
                        }
                        BisulfiteBaseInfo.DisplayStatus bisstatus = bisinfo == null ? null : bisinfo.getDisplayStatus(idx);
                        boolean bl3 = showBase = showAllBases || isSoftClip || bisulfiteMode || !quickConsensus || alignmentCounts.isConsensusMismatch(loc, reference[idx], chr, snpThreshold);
                        if (!showBase) continue;
                        BaseRenderer.drawBase(gAlignment, color, c, pX, pY, dX, dY - (leaveMargin ? 2 : 0), bisulfiteMode, bisstatus);
                    }
                }
            }
        }
        if (colorOption.isBaseMod()) {
            BaseModificationRenderer.drawModifications(alignment, bpStart, locScale, rowRect, context.getGraphics(), renderOptions);
        }
        if (colorOption.isSMRTKinetics()) {
            SMRTKineticsRenderer.drawSmrtKinetics(alignment, bpStart, locScale, rowRect, context.getGraphics(), colorOption);
        }
        if ((insertions = alignment.getInsertions()) != null) {
            for (AlignmentBlock aBlock : insertions) {
                if (aBlock.getStart() == context.expandedInsertionPosition) continue;
                int x = (int)(((double)aBlock.getStart() - bpStart) / locScale);
                int bpWidth = aBlock.getBasesLength();
                double pxWidthExact = (double)bpWidth / locScale;
                h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
                y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h) / 2.0) - (leaveMargin ? 1 : 0);
                if ((double)x > rowRect.getMaxX()) break;
                if ((double)x < rowRect.getX() || hideSmallIndelsBP && bpWidth < indelThresholdBP) continue;
                if (flagLargeIndels && bpWidth > largeInsertionsThreshold) {
                    this.drawLargeIndelLabel(context.getGraphics2D("INDEL_LABEL"), true, Globals.DECIMAL_FORMAT.format(bpWidth), x - 1, y, h, (int)pxWidthExact, context.translateX, aBlock, alignment, context);
                    continue;
                }
                int pxWing = h > 10 ? 2 : (h > 5 ? 1 : 0);
                Graphics2D ig = context.getGraphics();
                ig.setColor(purple);
                if (flowIndelRendering.handlesAlignment(alignment)) {
                    flowIndelRendering.renderSmallInsertion(alignment, aBlock, context, h, x, y, renderOptions);
                } else {
                    ig.fillRect(x, y, 2, h);
                    ig.fillRect(x - pxWing, y, 2 + 2 * pxWing, 2);
                    ig.fillRect(x - pxWing, y + h - 2, 2 + 2 * pxWing, 2);
                }
                aBlock.setPixelRange(context.translateX + x - pxWing, context.translateX + x + 2 + pxWing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawClippedEnds(Graphics2D g, int[] xPoly, int[] yPoly, boolean drawLeftClip, boolean drawRightClip, SupplementaryAlignment.SupplementaryNeighbors sri) {
        int xLeftPoint = xPoly[0];
        int xLeft = xPoly[1];
        int xRightPoint = xPoly[3];
        int xRight = xPoly[2];
        int yMiddle = yPoly[0];
        int yBottom = yPoly[5];
        int yTop = yPoly[1];
        Color savedColor = g.getColor();
        int arrowWidth = 3;
        String leftContigLabel = null;
        String rightContigLabel = null;
        try {
            if (drawLeftClip) {
                if (sri != null && sri.previous() != null) {
                    SupplementaryAlignment previous = sri.previous();
                    if (previous.contigsMatch((Locatable)sri.alignment())) {
                        g.setColor(previous.getStrand() == sri.alignment().getReadStrand() ? NON_INVERSION_COLOR : INVERSION_COLOR);
                    } else if (previous.getContig() != null) {
                        g.setColor(ChromosomeColors.getColor(previous.getContig()));
                        leftContigLabel = previous.getContig();
                    } else {
                        log.warn("previous is missing contig: " + previous);
                    }
                    Polygon thickLeftArrow = new Polygon(new int[]{xLeftPoint, xLeft, xLeft + 3, xLeft + 3, xLeft}, new int[]{yMiddle, yBottom, yBottom, yTop, yTop}, 5);
                    g.drawPolygon(thickLeftArrow);
                    g.fillPolygon(thickLeftArrow);
                    g.setColor(savedColor);
                }
                g.drawLine(xLeftPoint, yMiddle, xLeft, yBottom);
                g.drawLine(xLeft, yTop - 1, xLeftPoint, yMiddle);
            }
            if (drawRightClip) {
                if (sri != null && sri.next() != null) {
                    SupplementaryAlignment next = sri.next();
                    if (next.contigsMatch((Locatable)sri.alignment())) {
                        g.setColor(next.getStrand() == sri.alignment().getReadStrand() ? NON_INVERSION_COLOR : INVERSION_COLOR);
                    } else {
                        g.setColor(ChromosomeColors.getColor(next.getContig()));
                        rightContigLabel = next.getContig();
                    }
                    Polygon thickRightArrow = new Polygon(new int[]{xRightPoint, xRight, xRight - 3, xRight - 3, xRight}, new int[]{yMiddle, yBottom, yBottom, yTop, yTop}, 5);
                    g.drawPolygon(thickRightArrow);
                    g.fillPolygon(thickRightArrow);
                    g.setColor(savedColor);
                }
                g.drawLine(xRight, yBottom, xRightPoint, yMiddle);
                g.drawLine(xRightPoint, yMiddle, xRight, yTop - 1);
            }
            if (PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_CONNECTED_CHR_NAME") && (leftContigLabel != null || rightContigLabel != null)) {
                int height = yBottom - yTop;
                int textHeight = g.getFontMetrics().getHeight();
                if (textHeight <= height + 4) {
                    int leftTextWidth = leftContigLabel != null ? g.getFontMetrics().stringWidth(leftContigLabel) : 0;
                    int rightContigWidth = rightContigLabel != null ? g.getFontMetrics().stringWidth(rightContigLabel) : 0;
                    int width = xRight - xLeft;
                    int totalTextWidth = leftTextWidth + rightContigWidth + g.getFontMetrics().stringWidth(" ");
                    int distanceFromArrow = 4;
                    if (totalTextWidth <= width + 8) {
                        if (leftContigLabel != null) {
                            g.setColor(ChromosomeColors.getColor(leftContigLabel));
                            g.drawString(leftContigLabel, xLeft + 4, yBottom - 1);
                        }
                        if (rightContigLabel != null) {
                            g.setColor(ChromosomeColors.getColor(rightContigLabel));
                            g.drawString(rightContigLabel, xRight - (rightContigWidth + 4), yBottom - 1);
                        }
                    }
                }
            }
        }
        finally {
            g.setColor(savedColor);
        }
    }

    private void drawLargeIndelLabel(Graphics2D g, boolean isInsertion, String labelText, int pxCenter, int pxTop, int pxH, int pxWmax, int translateX, AlignmentBlock insertionBlock, Alignment alignment, RenderContext context) {
        boolean doesTextFit;
        int pxPad = 2;
        int pxWing = pxH > 10 ? 2 : 1;
        int minTextHeight = 8;
        Rectangle2D textBounds = g.getFontMetrics().getStringBounds(labelText, g);
        int pxTextW = 4 + (int)textBounds.getWidth();
        boolean bl = doesTextFit = pxH >= 8 && pxTextW < pxWmax;
        if (!doesTextFit && !isInsertion) {
            return;
        }
        int pxW = Math.max(2, Math.min(pxTextW, pxWmax));
        int pxLeft = pxCenter - (int)Math.ceil(pxW / 2);
        int pxRight = pxLeft + pxW;
        g.setColor(isInsertion ? purple : Color.white);
        g.fillRect(pxLeft, pxTop, pxRight - pxLeft, pxH);
        if (isInsertion && pxH > 5) {
            if (flowIndelRendering.handlesAlignment(alignment)) {
                flowIndelRendering.renderSmallInsertionWings(alignment, insertionBlock, context, pxH, pxTop, pxRight, pxLeft, this.track.renderOptions);
            } else {
                g.fillRect(pxLeft - pxWing, pxTop, pxRight - pxLeft + 2 * pxWing, 2);
                g.fillRect(pxLeft - pxWing, pxTop + pxH - 2, pxRight - pxLeft + 2 * pxWing, 2);
            }
        }
        if (doesTextFit) {
            g.setColor(isInsertion ? Color.white : purple);
            GraphicUtils.drawCenteredText(labelText, pxLeft, pxTop, pxW, pxH, (Graphics)g);
        }
        if (insertionBlock != null) {
            insertionBlock.setPixelRange(context.translateX + pxLeft, context.translateX + pxRight);
        }
    }

    public void renderExpandedInsertion(InsertionMarker i, List<Alignment> alignments, RenderContext context, Rectangle rect, boolean leaveMargin) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (alignments != null && alignments.size() > 0) {
            Graphics2D g = context.getGraphics2D("INSERTIONS");
            double dX = 1.0 / context.getScale();
            int fontSize = (int)Math.min(dX, 12.0);
            if (fontSize >= 8) {
                Font f = FontManager.getFont(1, fontSize);
                g.setFont(f);
            }
            for (Alignment alignment : alignments) {
                if (alignment.getEnd() < i.position) continue;
                if (alignment.getStart() > i.position) break;
                AlignmentBlock insertion = alignment.getInsertionAt(i.position);
                if (insertion == null) continue;
                double pixelStart = ((double)insertion.getStart() - origin) / locScale;
                double pixelEnd = ((double)insertion.getEnd() - origin) / locScale;
                int x = (int)pixelStart;
                if (pixelEnd < (double)rect.x || pixelStart > rect.getMaxX()) continue;
                int bpWidth = insertion.getBasesLength();
                double pxWidthExact = (double)bpWidth / locScale;
                int h = (int)Math.max(1.0, rect.getHeight() - 2.0);
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h) / 2.0) - 1;
                if (!insertion.hasBases()) {
                    g.setColor(purple);
                    g.fillRect(x, y, (int)pxWidthExact, h);
                    continue;
                }
                this.drawExpandedInsertionBases(x, context, rect, insertion, leaveMargin);
            }
        }
    }

    private void drawExpandedInsertionBases(int pixelPosition, RenderContext context, Rectangle rect, AlignmentBlock block, boolean leaveMargin) {
        Graphics2D g = context.getGraphics2D("INSERTIONS");
        ByteSubarray bases = block.getBases();
        int padding = block.getPadding();
        double locScale = context.getScale();
        double origin = context.getOrigin();
        int pY = (int)rect.getY();
        int dY = (int)rect.getHeight();
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        int size = bases.length + padding;
        for (int p = 0; p < size; ++p) {
            int pX;
            char c = p < padding ? (char)'-' : (char)bases.getByte(p - padding);
            Color color = SequenceRenderer.nucleotideColors.get(Character.valueOf(c));
            if (color == null) {
                color = Color.black;
            }
            if ((double)(pX = (int)((double)pixelPosition + (double)p / locScale)) > rect.getMaxX()) break;
            if ((double)(pX + dX) < rect.getX()) continue;
            BaseRenderer.drawBase(g, color, c, pX, pY, dX, dY - (leaveMargin ? 2 : 0), false, null);
        }
        int leftX = pixelPosition + context.translateX;
        int rightX = leftX + rect.width;
        block.setPixelRange(leftX, rightX);
    }

    private Color getAlignmentColor(Alignment alignment, AlignmentTrack track) {
        Color defaultColor;
        Color c = defaultColor = track.getColor();
        AlignmentTrack.RenderOptions renderOptions = track.getRenderOptions();
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        switch (colorOption) {
            case YC_TAG: {
                Color ycColor = alignment.getYcColor();
                if (ycColor == null) break;
                c = ycColor;
                break;
            }
            case BISULFITE: 
            case BASE_MODIFICATION: 
            case BASE_MODIFICATION_2COLOR: 
            case SMRT_SUBREAD_IPD: 
            case SMRT_SUBREAD_PW: 
            case SMRT_CCS_FWD_IPD: 
            case SMRT_CCS_FWD_PW: 
            case SMRT_CCS_REV_IPD: 
            case SMRT_CCS_REV_PW: {
                c = alignment.getFirstOfPairStrand() == Strand.POSITIVE ? bisulfiteColorFw1 : bisulfiteColorRev1;
                break;
            }
            case NOMESEQ: {
                c = nomeseqColor;
                break;
            }
            case UNEXPECTED_PAIR: 
            case PAIR_ORIENTATION: {
                c = this.getOrientationColor(alignment, AlignmentRenderer.getPEStats(alignment, renderOptions));
                if (c != defaultColor || colorOption == AlignmentTrack.ColorOption.PAIR_ORIENTATION) break;
            }
            case INSERT_SIZE: {
                boolean sameChr;
                boolean isPairedAlignment = alignment instanceof PairedAlignment;
                ReadMate mate = alignment.getMate();
                if ((!alignment.isPaired() || mate == null || !mate.isMapped()) && !isPairedAlignment) break;
                String mateChr = mate == null ? null : mate.getChr();
                boolean bl = sameChr = isPairedAlignment || mateChr != null && mateChr.equals(alignment.getChr());
                if (sameChr) {
                    int readDistance = Math.abs(alignment.getInferredInsertSize());
                    if (readDistance == 0) break;
                    int minThreshold = renderOptions.getMinInsertSize();
                    int maxThreshold = renderOptions.getMaxInsertSize();
                    PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
                    if (renderOptions.isComputeIsizes() && peStats != null) {
                        minThreshold = peStats.getMinThreshold();
                        maxThreshold = peStats.getMaxThreshold();
                    }
                    if (readDistance < minThreshold) {
                        c = smallISizeColor;
                        break;
                    }
                    if (readDistance <= maxThreshold) break;
                    c = largeISizeColor;
                    break;
                }
                c = ChromosomeColors.getColor(alignment.getMate().getChr());
                if (c != null) break;
                c = Color.black;
                break;
            }
            case READ_STRAND: {
                if (alignment.isNegativeStrand()) {
                    c = negStrandColor;
                    break;
                }
                c = posStrandColor;
                break;
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand fragmentStrand = alignment.getFirstOfPairStrand();
                if (fragmentStrand == Strand.NEGATIVE) {
                    c = negStrandColor;
                    break;
                }
                if (fragmentStrand != Strand.POSITIVE) break;
                c = posStrandColor;
                break;
            }
            case READ_ORDER: {
                if (!alignment.isPaired()) break;
                if (alignment.isFirstOfPair() && !alignment.isSecondOfPair()) {
                    c = firstOfPairColor;
                    break;
                }
                if (!alignment.isFirstOfPair() && alignment.isSecondOfPair()) {
                    c = secondOfPairColor;
                    break;
                }
                if (alignment.isFirstOfPair() && alignment.isSecondOfPair()) {
                    c = firstAndSecondofPairColor;
                    break;
                }
                c = neitherForOrSecondOfPair;
                break;
            }
            case READ_GROUP: {
                String rg = alignment.getReadGroup();
                if (rg == null) break;
                c = readGroupColors.get(rg);
                break;
            }
            case SAMPLE: {
                String sample = alignment.getSample();
                if (sample == null) break;
                c = sampleColors.get(sample);
                break;
            }
            case LIBRARY: {
                String library = alignment.getLibrary();
                if (library == null) break;
                c = sampleColors.get(library);
                break;
            }
            case MOVIE: {
                String[] readNameParts = alignment.getReadName().split("/");
                if (readNameParts.length < 3) break;
                c = movieColors.get(readNameParts[0]);
                break;
            }
            case ZMW: {
                String[] readNameParts = alignment.getReadName().split("/");
                if (readNameParts.length < 3) break;
                c = zmwColors.get(readNameParts[0] + "/" + readNameParts[1]);
                break;
            }
            case TAG: {
                ColorTable ctable;
                Object tagValue;
                String tag = renderOptions.getColorByTag();
                if (tag == null) break;
                Object object = tagValue = !colorByTagValueList.handlesTag(tag) ? alignment.getAttribute(tag) : colorByTagValueList.getValueForColorByTag(alignment, tag);
                if (tagValue == null) break;
                String groupByTag = renderOptions.getGroupByTag();
                if (groupByTag == null) {
                    ctable = defaultTagColors;
                } else {
                    Object g = alignment.getAttribute(groupByTag);
                    String group = g == null ? "" : g.toString();
                    String ctableKey = groupByTag + ":" + group;
                    ctable = tagValueColors.get(ctableKey);
                    if (ctable == null) {
                        ctable = groupByTag.equals("HP") ? this.getTenXColorTable(group) : defaultTagColors;
                        tagValueColors.put(group, ctable);
                    }
                }
                c = ctable.get(tagValue.toString());
                break;
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        c = this.shadeByMappingQuality(c, renderOptions, alignment.getMappingQuality());
        return c;
    }

    private Color shadeByMappingQuality(Color initialColor, AlignmentTrack.RenderOptions renderOptions, int mappingQuality) {
        float minAlpha = 0.15f;
        float maxAlpha = 1.0f;
        int maxMapQCutoff = renderOptions.getMappingQualityHigh();
        int minMapQCutoff = renderOptions.getMappingQualityLow();
        maxMapQCutoff = Ints.constrainToRange((int)maxMapQCutoff, (int)1, (int)255);
        minMapQCutoff = Ints.constrainToRange((int)minMapQCutoff, (int)0, (int)(maxMapQCutoff - 1));
        int clippedMQ = Ints.constrainToRange((int)mappingQuality, (int)minMapQCutoff, (int)maxMapQCutoff);
        float alphaRange = 0.85f;
        float normalizedMQ = (float)(clippedMQ - minMapQCutoff) / (float)(maxMapQCutoff - minMapQCutoff);
        Color backgroundColor = Color.white;
        if (mappingQuality == 0 && renderOptions.isFlagZeroQualityAlignments()) {
            return ColorUtilities.getCompositeColor(backgroundColor, initialColor, 0.15f);
        }
        switch (renderOptions.getShadeAlignmentsOption()) {
            case NONE: {
                return initialColor;
            }
            case MAPPING_QUALITY_LOW: {
                normalizedMQ = 1.0f - normalizedMQ;
            }
            case MAPPING_QUALITY_HIGH: {
                float actualAlpha = 0.15f + alphaRange * normalizedMQ;
                return ColorUtilities.getCompositeColor(backgroundColor, initialColor, actualAlpha);
            }
        }
        return initialColor;
    }

    private ColorTable getTenXColorTable(String group) {
        ColorTable ctable = group.equals("1") ? tenXColorTable1 : (group.equals("2") ? tenXColorTable2 : tenXColorTable3);
        return ctable;
    }

    public static PEStats getPEStats(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        String lb = alignment.getLibrary();
        if (lb == null) {
            lb = "null";
        }
        PEStats peStats = null;
        if (renderOptions.peStats != null) {
            peStats = renderOptions.peStats.get(lb);
        }
        return peStats;
    }

    private int getOutlierStatus(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            int minThreshold = peStats.getMinOutlierInsertSize();
            int maxThreshold = peStats.getMaxOutlierInsertSize();
            int dist = Math.abs(alignment.getInferredInsertSize());
            if (dist >= minThreshold || dist <= maxThreshold) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private int compareToBounds(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        int dist;
        int minThreshold = renderOptions.getMinInsertSize();
        int maxThreshold = renderOptions.getMaxInsertSize();
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            minThreshold = peStats.getMinThreshold();
            maxThreshold = peStats.getMaxThreshold();
        }
        if ((dist = Math.abs(alignment.getInferredInsertSize())) < minThreshold) {
            return -1;
        }
        if (dist > maxThreshold) {
            return 1;
        }
        return 0;
    }

    private Color getOrientationColor(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(alignment, peStats);
        Color c = typeToColorMap.get((Object)type);
        return c == null ? this.track.getColor() : c;
    }

    static AlignmentTrack.OrientationType getOrientationType(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = null;
        if (alignment.isPaired()) {
            String pairOrientation = alignment.getPairOrientation();
            if (peStats != null) {
                PEStats.Orientation libraryOrientation = peStats.getOrientation();
                switch (libraryOrientation) {
                    case FR: {
                        type = frOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case RF: {
                        type = rfOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F1F2: {
                        type = f1f2OrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F2F1: {
                        type = f2f1OrientationTypes.get(pairOrientation);
                    }
                }
            } else {
                type = alignment.getAttribute("CS") != null ? f2f1OrientationTypes.get(pairOrientation) : frOrientationTypes.get(pairOrientation);
            }
        }
        return type;
    }

    static {
        tenXColorTable1 = new HSLColorTable(30);
        tenXColorTable2 = new HSLColorTable(270);
        tenXColorTable3 = new GreyscaleColorTable();
        GROUP_DIVIDER_COLOR = new Color(200, 200, 200);
        softClippedReference = new byte[1000];
        colorByTagValueList = new ColorByTagValueList();
        flowIndelRendering = new FlowIndelRendering();
        AlignmentRenderer.initializeTagTypes();
        AlignmentRenderer.setNucleotideColors();
        AlignmentRenderer.initializeTagColors();
    }
}

