/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractProgressLogger
implements ProgressLoggerInterface {
    private final int n;
    private final String verb;
    private final String noun;
    private long startTime;
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed = 0L;
    private long lastStartTime = -1L;
    private String lastChrom = null;
    private int lastPos = 0;
    private String lastReadName = null;
    private long countNonIncreasing = 0L;
    private static final long PRINT_READ_NAME_THRESHOLD = 1000L;

    protected AbstractProgressLogger(String noun, String verb, int n) {
        this.noun = noun;
        this.verb = verb;
        this.n = n;
        this.reset();
    }

    protected abstract void log(String ... var1);

    private synchronized void record() {
        long now = System.currentTimeMillis();
        long lastPeriodSeconds = (now - this.lastStartTime) / 1000L;
        this.lastStartTime = now;
        long seconds = (now - this.startTime) / 1000L;
        String elapsed = this.formatElapseTime(seconds);
        String period = AbstractProgressLogger.pad(this.fmt.format(lastPeriodSeconds), 4);
        String processed = AbstractProgressLogger.pad(this.fmt.format(this.processed), 13);
        Object readInfo = this.lastChrom == null ? "*/*" : this.lastChrom + ":" + this.fmt.format(this.lastPos);
        Object rnInfo = this.lastReadName != null && this.countNonIncreasing > 1000L ? ".  Last read name: " + this.lastReadName : "";
        long n = this.processed % (long)this.n == 0L ? (long)this.n : this.processed % (long)this.n;
        this.log(new String[]{this.verb, " ", processed, " " + this.noun + ".  Elapsed time: ", elapsed, "s.  Time for last ", this.fmt.format(n), ": ", period, "s.  Last read position: ", readInfo, rnInfo});
    }

    public synchronized boolean log() {
        if (this.processed % (long)this.n != 0L) {
            this.record();
            return true;
        }
        return false;
    }

    protected synchronized boolean record(String chrom, int pos, String rname) {
        if (chrom != null && chrom.equals(this.lastChrom) && pos < this.lastPos) {
            ++this.countNonIncreasing;
        } else {
            this.lastChrom = chrom;
        }
        this.lastPos = pos;
        this.lastReadName = rname;
        if (this.lastStartTime == -1L) {
            this.lastStartTime = System.currentTimeMillis();
        }
        if (++this.processed % (long)this.n == 0L) {
            this.record();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean record(String chrom, int pos) {
        return this.record(chrom, pos, null);
    }

    @Override
    public synchronized boolean record(SAMRecord rec) {
        if ("*".equals(rec.getReferenceName())) {
            return this.record(null, 0, rec.getReadName());
        }
        return this.record(rec.getReferenceName(), rec.getAlignmentStart(), rec.getReadName());
    }

    @Override
    public boolean record(SAMRecord ... recs) {
        boolean triggered = false;
        for (SAMRecord rec : recs) {
            triggered = this.record(rec) || triggered;
        }
        return triggered;
    }

    public synchronized long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    @Override
    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.processed = 0L;
        this.lastStartTime = -1L;
        this.lastChrom = null;
        this.lastPos = 0;
        this.lastReadName = null;
        this.countNonIncreasing = 0L;
    }

    static String pad(String in, int length) {
        StringBuilder inBuilder = new StringBuilder(Math.max(length, in.length()));
        while (inBuilder.length() < length - in.length()) {
            inBuilder.append(" ");
        }
        return inBuilder.append(in).toString();
    }

    private String formatElapseTime(long seconds) {
        long s = seconds % 60L;
        long allMinutes = seconds / 60L;
        long m = allMinutes % 60L;
        long h = allMinutes / 60L;
        return this.timeFmt.format(h) + ":" + this.timeFmt.format(m) + ":" + this.timeFmt.format(s);
    }
}

