/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.htsget;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.broad.igv.util.HttpUtils;

public class HtsgetUtils {
    public static Metadata getMetadata(String url) throws IOException {
        if (url.startsWith("htsget://")) {
            try {
                return HtsgetUtils.getMetadata(url.replace("htsget://", "https://"));
            }
            catch (IOException e) {
                return HtsgetUtils.getMetadata(url.replace("htsget://", "http://"));
            }
        }
        URL headerURL = HtsgetUtils.addQueryString(url, "class=header");
        String ticket = HttpUtils.getInstance().getContentsAsJSON(headerURL);
        JsonParser parser = new JsonParser();
        JsonObject json = null;
        try {
            json = parser.parse(ticket).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (!json.has("htsget")) {
            return null;
        }
        String format = json.get("htsget").getAsJsonObject().get("format").getAsString();
        return new Metadata(url, format);
    }

    static URL addQueryString(String urlBase, String queryString) throws MalformedURLException {
        String separator = urlBase.contains("?") ? "&" : "?";
        return new URL(urlBase + separator + queryString);
    }

    public static class Metadata {
        private final String url;
        private final String format;

        public Metadata(String url, String format) {
            this.url = url;
            this.format = format;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

