/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.HubGenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class DataPanelContainer
extends TrackPanelComponent
implements Paintable {
    static final int default_hgap = 6;
    private static Logger log = LogManager.getLogger(DataPanelContainer.class);
    TrackPanel parent;

    public DataPanelContainer(TrackPanel trackPanel) {
        super(trackPanel);
        DropTarget target = new DropTarget(this, new FileDropTargetListener(trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
        this.setLayout(new BoxLayout(this, 0));
        this.parent = trackPanel;
        this.createDataPanels();
    }

    public void createDataPanels() {
        this.removeAll();
        int hgap = 6;
        if (FrameManager.getFrames().size() > 10) {
            hgap = 1 + 20 / FrameManager.getFrames().size();
        }
        boolean first = true;
        for (ReferenceFrame f : FrameManager.getFrames()) {
            if (!f.isVisible()) continue;
            if (!first) {
                this.add(Box.createRigidArea(new Dimension(hgap, 0)));
            }
            DataPanel dp = new DataPanel(f, this);
            this.add(dp);
            first = false;
        }
        this.invalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            c.setBackground(color);
        }
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    public void setCurrentTool(RegionOfInterestTool regionOfInterestTool) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            ((DataPanel)c).setCurrentTool(regionOfInterestTool);
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Component[] components = this.getComponents();
        Arrays.sort(components, Comparator.comparingInt(Component::getX));
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(c.getX(), 0);
            Rectangle panelRect = new Rectangle(0, rect.y, c.getWidth(), rect.height);
            ((DataPanel)c).paintOffscreen(g2d, panelRect, batch);
        }
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (IGV.getInstance().isRulerEnabled()) {
            int start = MouseInfo.getPointerInfo().getLocation().x - this.getLocationOnScreen().x;
            g.setColor(Color.BLACK);
            g.drawLine(start, 0, start, this.getHeight());
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            boolean allChrMode = frame.getChrName().equals("All");
            if (!FrameManager.isGeneListMode() && !allChrMode) {
                int y = MouseInfo.getPointerInfo().getLocation().y - this.getLocationOnScreen().y;
                int pos = (int)frame.getChromosomePosition(start) + 1;
                g.setFont(FontManager.getDefaultFont());
                g.drawString(Globals.DECIMAL_FORMAT.format((double)pos), start + 10, y + 30);
            }
        }
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(TrackPanel dataPanel) {
            this.panel = dataPanel;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            MessageCollection messages;
            block14: {
                if (!this.isDropAcceptable(event)) {
                    event.rejectDrop();
                    return;
                }
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                messages = new MessageCollection();
                try {
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (files != null && files.size() > 0) {
                            List<ResourceLocator> locators = ResourceLocator.getLocators(files);
                            for (ResourceLocator locator : locators) {
                                try {
                                    IGV.getInstance().load(locator, this.panel);
                                }
                                catch (DataLoadException de) {
                                    messages.append(de.getMessage());
                                }
                            }
                        }
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        if (HubGenomeLoader.isHubURL(obj)) {
                            LongRunningTask.submit(() -> {
                                try {
                                    GenomeManager.getInstance().loadGenome(obj);
                                }
                                catch (IOException e) {
                                    MessageUtils.showMessage("Error loading track hub: " + e.getMessage());
                                }
                            });
                        } else {
                            IGV.getInstance().load(new ResourceLocator(obj), this.panel);
                        }
                    } else {
                        messages.append("Unknown object type: " + transferable.toString());
                    }
                }
                catch (Exception e) {
                    log.error(e);
                    if (e.getMessage() == null) break block14;
                    messages.append(e.getMessage());
                }
            }
            if (messages != null && !messages.isEmpty()) {
                MessageUtils.showMessage(messages.getFormattedMessage());
            }
            IGV.getInstance().getMainFrame().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

