/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ucsc.bb.BBFile;
import org.broad.igv.ucsc.bb.BBTotalSummary;
import org.broad.igv.ucsc.bb.BBZoomHeader;
import org.broad.igv.ucsc.bb.WigDatum;

public class BBDataSource
extends AbstractDataSource
implements DataSource {
    private final Genome genome;
    Collection<WindowFunction> availableWindowFunctions = Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max, WindowFunction.none);
    BBFile reader;
    private Map<WindowFunction, List<LocusScore>> wholeGenomeScores;
    private double dataMin = 0.0;
    private double dataMax = 100.0;
    List<LocusScore> wgScores = null;

    public BBDataSource(BBFile reader, Genome genome) throws IOException {
        super(genome);
        this.reader = reader;
        this.genome = genome;
        this.wholeGenomeScores = new HashMap<WindowFunction, List<LocusScore>>();
        this.initMinMax();
    }

    private void initMinMax() {
        BBTotalSummary totalSummary = this.reader.totalSummary;
        if (totalSummary == null) {
            this.dataMin = 0.0;
            this.dataMax = 100.0;
        } else {
            this.dataMin = totalSummary.minVal;
            if (totalSummary.basesCovered < 100L) {
                this.dataMin = Math.min(0.0, totalSummary.minVal);
                this.dataMax = totalSummary.maxVal;
            } else if (totalSummary.minVal < 0.0) {
                this.dataMax = Math.min(totalSummary.maxVal, 3.0 * totalSummary.stddev);
                this.dataMin = Math.max(totalSummary.minVal, -this.dataMax);
            } else {
                this.dataMin = 0.0;
                this.dataMax = Math.min(totalSummary.maxVal, totalSummary.mean + 2.0 * totalSummary.stddev);
            }
        }
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    protected DataTile getRawData(String chr, int start, int end) {
        try {
            long rTreeOffset = this.reader.header.fullIndexOffset;
            List<byte[]> chunks = this.reader.getLeafChunks(chr, start, chr, end, rTreeOffset);
            Integer chrIdx = this.reader.getIdForChr(chr);
            ArrayList<LocusScore> features = new ArrayList<LocusScore>();
            for (byte[] c : chunks) {
                this.reader.decodeWigData(c, chrIdx, start, end, features);
            }
            int size = features.size();
            int[] starts = new int[size];
            int[] ends = new int[size];
            float[] values = new float[size];
            for (int i = 0; i < size; ++i) {
                LocusScore locusScore = (LocusScore)features.get(i);
                starts[i] = locusScore.getStart();
                ends[i] = locusScore.getEnd();
                values[i] = locusScore.getScore();
            }
            return new DataTile(starts, ends, values, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int start, int end, int zoom) {
        try {
            if ("All".equals(chr)) {
                if (this.genome.getHomeChromosome().equals("All") && this.windowFunction != WindowFunction.none) {
                    return this.getWholeGenomeScores();
                }
                return null;
            }
            Chromosome chromosome = this.genome.getChromosome(chr);
            if (chromosome == null) {
                throw new RuntimeException("Unexpected chromosome name: " + chr);
            }
            double nBins = Math.pow(2.0, zoom);
            double scale = (double)chromosome.getLength() / (nBins * 700.0);
            BBZoomHeader zlHeader = this.reader.zoomLevelForScale(scale);
            if (zlHeader == null) {
                return null;
            }
            long rTreeOffset = zlHeader.indexOffset;
            int chrIdx = this.reader.getIdForChr(chr);
            List<byte[]> chunks = this.reader.getLeafChunks(chr, start, chr, end, rTreeOffset);
            ArrayList<LocusScore> features = new ArrayList<LocusScore>();
            for (byte[] c : chunks) {
                this.reader.decodeZoomData(c, chrIdx, start, end, this.windowFunction, features);
            }
            return features;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getLongestFeature(String chr) {
        return 0;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.OTHER;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableWindowFunctions;
    }

    @Override
    public void dispose() {
    }

    private List<LocusScore> getWholeGenomeScores() {
        try {
            if (this.genome.getHomeChromosome().equals("All") && this.windowFunction != WindowFunction.none) {
                if (!this.wholeGenomeScores.containsKey(this.windowFunction)) {
                    int screenWidth = 1000;
                    double scale = this.genome.getWGLength() / (long)screenWidth;
                    int maxChromId = this.reader.getChromosomeNames().length - 1;
                    String firstChr = this.reader.getChrForId(0);
                    String lastChr = this.reader.getChrForId(maxChromId);
                    ArrayList<BasicScore> scores = new ArrayList<BasicScore>();
                    this.wholeGenomeScores.put(this.windowFunction, scores);
                    BBZoomHeader lowestResHeader = this.reader.zoomLevelForScale(scale);
                    if (lowestResHeader == null) {
                        return null;
                    }
                    HashSet<String> wgChrNames = new HashSet<String>(this.genome.getLongChromosomeNames());
                    long rTreeOffset = lowestResHeader.indexOffset;
                    List<byte[]> chunks = this.reader.getLeafChunks(firstChr, 0, lastChr, Integer.MAX_VALUE, rTreeOffset);
                    ArrayList<LocusScore> features = new ArrayList<LocusScore>();
                    for (byte[] c : chunks) {
                        this.reader.decodeZoomData(c, -1, -1, -1, this.windowFunction, features);
                    }
                    for (LocusScore s : features) {
                        WigDatum rec = (WigDatum)s;
                        String chr = this.genome.getCanonicalChrName(rec.getChr());
                        if (!wgChrNames.contains(chr)) continue;
                        int genomeStart = this.genome.getGenomeCoordinate(chr, rec.getStart());
                        int genomeEnd = this.genome.getGenomeCoordinate(chr, rec.getEnd());
                        scores.add(new BasicScore(genomeStart, genomeEnd, rec.getScore()));
                    }
                    scores.sort((o1, o2) -> o1.getStart() - o2.getStart());
                }
                return this.wholeGenomeScores.get(this.windowFunction);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

