/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.Cigar;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.ClippingCounts;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.sam.mods.BaseModificationUtils;
import org.broad.igv.sam.smrt.SMRTKinetics;

public interface Alignment
extends LocusScore {
    default public String getReadName() {
        return "";
    }

    default public String getReadSequence() {
        return "";
    }

    default public String getChr() {
        return this.getContig();
    }

    public int getAlignmentStart();

    public int getAlignmentEnd();

    public boolean contains(double var1);

    public AlignmentBlock[] getAlignmentBlocks();

    public AlignmentBlock[] getInsertions();

    default public String getCigarString() {
        return "*";
    }

    default public Cigar getCigar() {
        return Cigar.fromCigarString((String)this.getCigarString());
    }

    public List<Gap> getGaps();

    public int getInferredInsertSize();

    default public int getLeadingHardClipLength() {
        return 0;
    }

    public int getMappingQuality();

    default public ReadMate getMate() {
        return null;
    }

    public Strand getReadStrand();

    public boolean isProperPair();

    public boolean isMapped();

    public boolean isPaired();

    public boolean isFirstOfPair();

    public boolean isSecondOfPair();

    public boolean isNegativeStrand();

    public boolean isDuplicate();

    public boolean isPrimary();

    public boolean isSupplementary();

    public byte getBase(double var1);

    public byte getPhred(double var1);

    default public Object getAttribute(String key) {
        return null;
    }

    public void setMateSequence(String var1);

    public String getPairOrientation();

    public Strand getFirstOfPairStrand();

    public Strand getSecondOfPairStrand();

    public boolean isVendorFailedRead();

    public Color getYcColor();

    default public String getSample() {
        return null;
    }

    default public String getReadGroup() {
        return null;
    }

    default public String getLibrary() {
        return null;
    }

    public String getClipboardString(double var1, int var3);

    default public void finish() {
    }

    default public AlignmentBlock getInsertionAt(int position) {
        AlignmentBlock[] insertions = this.getInsertions();
        if (insertions == null) {
            return null;
        }
        for (AlignmentBlock block : insertions) {
            if (block.getStart() != position) continue;
            return block;
        }
        return null;
    }

    default public Gap getDeletionAt(int position) {
        List<Gap> gaps = this.getGaps();
        if (gaps != null && !gaps.isEmpty()) {
            for (Gap gap : gaps) {
                if (gap.getStart() > position || gap.getnBases() + gap.getStart() <= position || gap.getType() != 'D') continue;
                return gap;
            }
        }
        return null;
    }

    default public ClippingCounts getClippingCounts() {
        return ClippingCounts.fromCigar(this.getCigar());
    }

    default public void setHaplotypeName(String hap) {
    }

    default public String getHaplotypeName() {
        return null;
    }

    default public void setHapDistance(int dist) {
    }

    default public int getHapDistance() {
        return 0;
    }

    default public Map<Integer, BaseModificationUtils> getBaseModificationMap() {
        return null;
    }

    default public List<BaseModificationSet> getBaseModificationSets() {
        return null;
    }

    default public SMRTKinetics getSmrtKinetics() {
        return null;
    }

    default public String getAlignmentValueString(double position, int mouseX, AlignmentTrack.RenderOptions renderOptions) {
        return this.getValueString(position, mouseX, null);
    }

    default public Alignment getSpecificAlignment(double location) {
        return this.contains(location) ? this : null;
    }
}

