/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.broad.igv.charts.Axis;
import org.broad.igv.charts.AxisPanel;
import org.broad.igv.charts.ChartLayout;
import org.broad.igv.charts.ScatterPlot;
import org.broad.igv.charts.SelectionPath;
import org.broad.igv.charts.XYDataPoint;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.util.IGVMouseInputAdapter;

public class ChartPanel
extends JPanel
implements Serializable {
    ScatterPlot scatterPlot;
    public static final BasicStroke DOT1 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
    public static final BasicStroke DOT2 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 1.0f}, 0.0f);
    PlotPanel plotPanel;
    AxisPanel xAxisPanel;
    AxisPanel yAxisPanel;
    LegendPanel legendPanel;
    boolean lassoInProgress = false;
    SelectionPath lassoPath = null;

    public ChartPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new ChartLayout());
        this.plotPanel = new PlotPanel();
        this.plotPanel.setBackground(PreferencesManager.getPreferences().getAsColor("BACKGROUND_COLOR"));
        this.plotPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.add((Component)this.plotPanel, "Chart");
        this.xAxisPanel = new AxisPanel();
        this.xAxisPanel.setPreferredSize(new Dimension(1000, 60));
        this.xAxisPanel.setFont(FontManager.getDefaultFont());
        this.add((Component)this.xAxisPanel, "XAxis");
        this.yAxisPanel = new AxisPanel();
        this.yAxisPanel.setPreferredSize(new Dimension(60, 1000));
        this.yAxisPanel.setFont(FontManager.getDefaultFont());
        this.add((Component)this.yAxisPanel, "YAxis");
        this.legendPanel = new LegendPanel();
        this.legendPanel.setPreferredSize(new Dimension(200, 1000));
        Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
        this.legendPanel.setBorder(lineBorder);
        this.add((Component)this.legendPanel, "Legend");
    }

    public void setScatterPlotModel(ScatterPlot scatterPlot) {
        this.scatterPlot = scatterPlot;
        this.xAxisPanel.setAxisModel(scatterPlot.xAxis);
        this.yAxisPanel.setAxisModel(scatterPlot.yAxis);
        this.legendPanel.rebuild();
        this.repaint();
    }

    class PlotPanel
    extends JPanel {
        PlotPanel() {
            this.setToolTipText("Plot panel");
            IGVMouseInputAdapter mouseAdapter = new IGVMouseInputAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (ChartPanel.this.scatterPlot != null && !ChartPanel.this.lassoInProgress) {
                        XYDataPoint dp = ChartPanel.this.scatterPlot.getDataPointAtPixel(mouseEvent.getX(), mouseEvent.getY());
                        if (dp != null) {
                            String description = dp.getDescription();
                            if (description != null) {
                                PlotPanel.this.setToolTipText(description);
                            }
                        } else {
                            PlotPanel.this.setToolTipText("");
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (ChartPanel.this.lassoInProgress) {
                        ChartPanel.this.lassoPath.addPoint(mouseEvent.getPoint());
                        PlotPanel.this.paintImmediately(new Rectangle(0, 0, PlotPanel.this.getWidth(), PlotPanel.this.getHeight()));
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    super.mouseReleased(mouseEvent);
                    if (ChartPanel.this.lassoInProgress) {
                        ChartPanel.this.lassoInProgress = false;
                        if (ChartPanel.this.lassoPath.size() > 2) {
                            Axis xAxis = ChartPanel.this.scatterPlot.xAxis;
                            Axis yAxis = ChartPanel.this.scatterPlot.yAxis;
                            Path2D.Double path = new Path2D.Double(1, ChartPanel.this.lassoPath.size());
                            Iterator<Point> iter = ChartPanel.this.lassoPath.getPoints().iterator();
                            Point p = iter.next();
                            double x = xAxis.getDataValueForPixel(p.x);
                            double y = yAxis.getDataValueForPixel(p.y);
                            ((Path2D)path).moveTo(x, y);
                            while (iter.hasNext()) {
                                p = iter.next();
                                x = xAxis.getDataValueForPixel(p.x);
                                y = yAxis.getDataValueForPixel(p.y);
                                ((Path2D)path).lineTo(x, y);
                            }
                            path.closePath();
                            ChartPanel.this.scatterPlot.selectPointsInPath(path);
                            Rectangle damageRect = ChartPanel.this.lassoPath.getBounds();
                            ChartPanel.this.lassoPath = null;
                            PlotPanel.this.repaint(damageRect);
                        }
                    }
                }

                @Override
                public void igvMouseClicked(MouseEvent mouseEvent) {
                    if (ChartPanel.this.lassoInProgress) {
                        ChartPanel.this.lassoPath.addPoint(mouseEvent.getPoint());
                    } else {
                        ChartPanel.this.scatterPlot.clearSelections();
                        PlotPanel.this.repaint();
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ChartPanel.this.scatterPlot != null) {
                Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                ChartPanel.this.scatterPlot.draw((Graphics2D)g, r, g.getClipBounds());
            }
        }
    }

    class LegendPanel
    extends JComponent {
        int leftMargin = 10;
        int topMargin = 30;
        private Font labelFont;
        private Font headerFont;

        LegendPanel() {
            Font defaultFont = FontManager.getDefaultFont();
            this.labelFont = defaultFont.deriveFont(12);
            this.headerFont = defaultFont.deriveFont(1, 16.0f);
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            this.rebuild();
        }

        void rebuild() {
            if (ChartPanel.this.scatterPlot == null || ChartPanel.this.scatterPlot.getDataModel() == null) {
                return;
            }
            this.removeAll();
            String categoryName = ChartPanel.this.scatterPlot.getDataModel().getCategoryName();
            if (categoryName == null || categoryName.equals("")) {
                return;
            }
            this.add(Box.createVerticalStrut(this.topMargin));
            JLabel catLabel = new JLabel(" " + categoryName);
            catLabel.setFont(this.headerFont);
            this.add(catLabel);
            this.add(new JLabel(" "));
            if (!ScatterPlot.isDataCategory(categoryName)) {
                Rectangle pointShape = new Rectangle(10, 10);
                ArrayList<String> seriesNames = new ArrayList<String>(ChartPanel.this.scatterPlot.getDataModel().getSeriesNames());
                this.sortSeriesNames(seriesNames);
                for (final String sn : seriesNames) {
                    Color c = ChartPanel.this.scatterPlot.getColor(categoryName, sn);
                    LegendIcon icon = new LegendIcon(pointShape, c);
                    String labelString = sn.trim().equals("") ? "<No Value>" : sn;
                    JLabel label = new JLabel(labelString, icon, 2);
                    label.setFont(this.labelFont);
                    final JCheckBox cb = new JCheckBox();
                    cb.setSelected(true);
                    cb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (cb.isSelected()) {
                                ChartPanel.this.scatterPlot.removeSeriesFilter(sn);
                            } else {
                                ChartPanel.this.scatterPlot.addSeriesFilter(sn);
                            }
                            ChartPanel.this.plotPanel.repaint();
                        }
                    });
                    JPanel panel = new JPanel();
                    panel.setAlignmentX(0.0f);
                    panel.setLayout(new BoxLayout(panel, 2));
                    panel.add(cb);
                    panel.add(label);
                    this.add(panel);
                }
                this.revalidate();
            }
        }

        private void sortSeriesNames(List<String> seriesNames) {
            Collections.sort(seriesNames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    double d2;
                    double d1;
                    try {
                        d1 = Double.parseDouble(s1);
                    }
                    catch (NumberFormatException e) {
                        d1 = Double.MAX_VALUE;
                    }
                    try {
                        d2 = Double.parseDouble(s2);
                    }
                    catch (NumberFormatException e) {
                        d2 = Double.MAX_VALUE;
                    }
                    if (d1 == d2) {
                        if (s1.equals("")) {
                            s1 = "ZZZ";
                        }
                        if (s2.equals("")) {
                            s2 = "ZZZ";
                        }
                        return s1.compareTo(s2);
                    }
                    return (int)(d1 - d2);
                }
            });
        }
    }

    static class LegendIcon
    implements Icon {
        Rectangle shape;
        Color color;

        LegendIcon(Rectangle shape, Color color) {
            this.shape = shape;
            this.color = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            Color c = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fillOval(x, y, this.shape.width, this.shape.height);
            graphics.setColor(c);
        }

        @Override
        public int getIconWidth() {
            return this.shape.width;
        }

        @Override
        public int getIconHeight() {
            return this.shape.height;
        }
    }
}

