/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Comparator;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.ChromosomeNameComparator;

public class ChromosomeComparator
implements Comparator<Chromosome> {
    @Override
    public int compare(Chromosome o1, Chromosome o2) {
        boolean o1import = this.isMajor(o1.getName());
        boolean o2import = this.isMajor(o2.getName());
        if (o1import && o2import) {
            return ChromosomeNameComparator.get().compare(o1.getName(), o2.getName());
        }
        if (o1import) {
            return -1;
        }
        if (o2import) {
            return 1;
        }
        if (this.isMyto(o1.getName())) {
            return -1;
        }
        if (this.isMyto(o2.getName())) {
            return 1;
        }
        if (o1.getName().startsWith("chr") && !o2.getName().startsWith("chr")) {
            return -1;
        }
        if (o2.getName().startsWith("chr") && !o1.getName().startsWith("chr")) {
            return 1;
        }
        return o2.getLength() - o1.getLength();
    }

    boolean isMajor(String chr) {
        if (chr.startsWith("chr")) {
            chr = chr.substring(3);
        }
        return chr.length() < 3 && this.isInteger(chr) || chr.equals("X") || chr.equals("Y");
    }

    boolean isMyto(String chr) {
        return chr.equals("chrM") || chr.equals("MT");
    }

    boolean isInteger(String chr) {
        for (int i = 0; i < chr.length(); ++i) {
            if (chr.charAt(i) >= '0' && chr.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }
}

