/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteBaseInfo;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.mods.BaseModificationRenderer;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorUtilities;

public class BaseRenderer {
    static Map<String, Color> shadedColorCache = Collections.synchronizedMap(new HashMap());

    static void drawBase(Graphics2D g, Color color, char c, int pX, int pY, int dX, int dY, boolean bisulfiteMode, BisulfiteBaseInfo.DisplayStatus bisstatus) {
        int fontSize = Math.min(Math.min(dX, dY), 12);
        if (fontSize >= 8 && (!bisulfiteMode || bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.CHARACTER))) {
            Font f = FontManager.getFont(1, fontSize);
            g.setFont(f);
            g.setColor(color);
            GraphicUtils.drawCenteredText(new char[]{c}, pX, pY, dX, dY, g);
        } else {
            if (bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.RECTANGLE) && dX < 3) {
                int expansion = dX;
                pX -= expansion;
                dX += 2 * expansion;
            }
            if (color != null) {
                g.setColor(color);
                g.fillRect(pX, pY, dX, dY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawExpandedInsertions(InsertionMarker insertionMarker, List<Alignment> alignments, RenderContext context, Rectangle rect, boolean leaveMargin, AlignmentTrack.RenderOptions renderOptions) {
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double dX = 1.0 / context.getScale();
            int fontSize = (int)Math.min(dX, 12.0);
            if (fontSize >= 8) {
                Font f = FontManager.getFont(1, fontSize);
                g.setFont(f);
            }
            AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
            for (Alignment alignment : alignments) {
                List<BaseModificationSet> baseModificationSets;
                double pX;
                if (alignment.getEnd() < insertionMarker.position) continue;
                if (alignment.getStart() > insertionMarker.position) {
                    break;
                }
                AlignmentBlock insertion = alignment.getInsertionAt(insertionMarker.position);
                if (insertion == null || !insertion.hasBases()) continue;
                double origin = context.getOrigin();
                double locScale = context.getScale();
                int pixelStart = (int)(((double)insertion.getStart() - origin) / locScale);
                int pixelEnd = (int)((double)pixelStart + (double)insertion.getLength() / locScale);
                if (pixelEnd < rect.x || (double)pixelStart > rect.getMaxX()) continue;
                ByteSubarray bases = insertion.getBases();
                int padding = insertion.getPadding();
                int size = bases.length + padding;
                for (int p = 0; p < size && !((pX = (double)pixelStart + (double)p / locScale) > rect.getMaxX()); ++p) {
                    if (pX + dX < rect.getX()) continue;
                    char c = p < padding ? (char)'-' : (char)bases.getByte(p - padding);
                    Color color = null;
                    color = colorOption.isBaseMod() || colorOption.isSMRTKinetics() ? Color.GRAY : SequenceRenderer.nucleotideColors.get(Character.valueOf(c));
                    if (color == null) {
                        color = Color.black;
                    }
                    if (renderOptions.getShadeBasesOption() && p >= padding) {
                        byte qual = p < padding ? (byte)126 : (byte)insertion.getQuality(p - padding);
                        color = BaseRenderer.getShadedColor(color, qual, renderOptions.getBaseQualityMin(), renderOptions.getBaseQualityMax());
                    }
                    if (dX < 8.0) {
                        g.setColor(color);
                        g.fill(new Rectangle2D.Double(pX, rect.y, dX, rect.height));
                        continue;
                    }
                    BaseRenderer.drawBase(g, color, c, (int)pX, rect.y, (int)dX, rect.height - (leaveMargin ? 2 : 0), false, null);
                }
                insertion.setPixelRange(context.translateX + pixelStart, context.translateX + pixelEnd);
                if (!colorOption.isBaseMod() || (baseModificationSets = alignment.getBaseModificationSets()) == null) continue;
                BaseModificationRenderer.drawBlock(origin, locScale, rect, g, renderOptions, baseModificationSets, insertion);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    public static Color getShadedColor(Color color, byte qual, int minQ, int maxQ) {
        if (qual >= maxQ) {
            return color;
        }
        float alpha = qual < minQ ? 0.2f : Math.max(0.2f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        String key = ColorUtilities.colorToString(color) + "_" + alpha;
        Color c = shadedColorCache.get(key);
        if (c == null) {
            c = ColorUtilities.modifyAlpha(color, (int)(alpha * 255.0f));
            shadedColorCache.put(key, c);
        }
        return c;
    }
}

